/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)close.c	5.2	7/30/85
 */

/*
 * f_clos(): f77 file close
 * t_runc(): truncation
 * f_exit(): I/O library exit routines
 */

#include "fio.h"

static char FROM_OPEN[] =	"\2";
static char clse[]	=	"close";

#ifdef SILICON_SOLUTIONS
extern unit_list[];
#endif SILICON_SOLUTIONS

f_clos(a) cllist *a;
{	unit *b;
	int n;

	lfname = NULL;
	elist = NO;
	external = YES;
	errflag = a->cerr;
#ifdef SILICON_SOLUTIONS
	lunit = tr_unit(a->cunit,clse);
#else
	lunit = a->cunit;
	if(not_legal(lunit)) return(OK);
#endif SILICON_SOLUTIONS
	if(lunit==STDERR && (!a->csta || *a->csta != FROM_OPEN[0]))
		err(errflag,F_ERUNIT,"can't close stderr");

	b= &units[lunit];
	if(!b->ufd) return(OK);
	if(a->csta && *a->csta != FROM_OPEN[0])
		switch(lcase(*a->csta))
		{
	delete:
		case 'd':
			fclose(b->ufd);
			if(b->ufnm) unlink(b->ufnm); /*SYSDEP*/
			break;
		default:
	keep:
		case 'k':
			if(b->uwrt && (n=t_runc(b,errflag,clse))) return(n);
			fclose(b->ufd);
			break;
		}
	else if(b->uscrtch) goto delete;
	else goto keep;
#ifdef SILICON_SOLUTIONS
	rm_unit(lunit);
#endif SILICON_SOLUTIONS
	if(b->ufnm) free(b->ufnm);
	b->ufnm=NULL;
	b->ufd=NULL;
	return(OK);
}

f_exit()
{
	ftnint lu, dofirst = YES;
	cllist xx;
	xx.cerr=1;
	xx.csta=FROM_OPEN;

#ifdef SILICON_SOLUTIONS
       for(lu=1; lu < MXUNIT;)
        {
                if (unit_list[lu] != EMPTY)
                   if ((lu != STDERR) || (lu != STDOUT) || (lu != STDIN)) {
                      xx.cunit=unit_list[lu];
                      f_clos(&xx);
                      dofirst = NO;
                      }
                lu++;
        }
#else 
	for(lu=STDOUT; (dofirst || lu!=STDOUT); lu = ++lu % MXUNIT)
	{
		xx.cunit=lu;
		f_clos(&xx);
		dofirst = NO;
	}
#endif SILICON_SOLUTIONS
}

t_runc (b, flag, str)
unit	*b;
ioflag	flag;
char	*str;
{
	long	loc;

	if (b->uwrt)
		fflush (b->ufd);
	if (b->url || !b->useek || !b->ufnm)
		return (OK);	/* don't truncate direct access files, etc. */
	loc = ftell (b->ufd);
	if (truncate (b->ufnm, loc) != 0)
		err (flag, errno, str)
	if (b->uwrt && ! nowreading(b))
		err (flag, errno, str)
	return (OK);
}


#ifdef SILICON_SOLUTIONS
rm_unit(unit)
ftnint unit;
{
        unit_list[unit] = EMPTY; /* del closed unit from table*/
}
#endif SILICON_SOLUTIONS


