/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)pow_rr.c	5.1	6/7/85
 */
#include	<errno.h>
int errno;

static int	Inf	= 0x7f800000;
static int	NaN	= 0x7fffffff;

float
pow_rr(arg1,arg2)
float *arg1, *arg2;
{
	long l;
	double exp(), log();

	if (*(int *)arg1 & 0x7fffffff == 0) {
		if (*(int *)arg2 < 0) {
			errno = EDOM;
			return *(float *)&Inf;
		}
		else if (*(int *)arg2 == 0) {
			errno = EDOM;
			return *(float *)&NaN;
		}
		else
			return(0.);
	}
	if(*(int *)arg2 < 0) {
		l = *(int *)arg1;
		if(l != *(int *)arg1) {
			errno = EDOM;
			return *(float *)&NaN;
		}
	}
	return (float)(exp(*arg2 * log(*arg1)));
}
