#!/bin/csh -f 
# link /.vmunix.hostname to /usr/vmunix.hostname to /usr/vmunix.cputype
# if vmunix.cputype exists
if ($#argv < 2 ) then
	echo "Usage: install_kernel hostname cputupe"
	exit 1
endif

set NAME = $1
set CPUTYPE = $2
if (! -e /usr/vmunix.$CPUTYPE ) then
	echo "The kernel for cpu type $CPUTYPE appears not to exist."
	echo "It will have to be config'ed if the kernel objects for $CPUTYPE"
	echo "have been installed, or retreived from the distribution"
	echo "tape."
	echo ""
	echo -n "Hit <return> to continue :"
	set dummy = $<
	exit 1 
else

	ln -s /usr/vmunix.$CPUTYPE /usr/vmunix.$NAME


	echo "Links to a generic kernel in the file /usr/vmunix.$CPUTYPE"
	echo "have been made in order to make $NAME bootable from its"
	echo "server. However, for better performance and memory usage"
	echo "it is recommended that an optimized kernel be built and "
	echo "installed in place of the link that currently occupies "
	echo "the pathname /usr/vmunix.$NAME"
	echo -n "Hit <return> to continue :"
	set dummy = $<
	exit 0
endif

	



