#! /bin/csh -f
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

repeat 8 echo ""
echo "                 First-time admin initialization"
echo ""
echo ""
#
# Make sure we are single user ad uid == root...
#
if ( SU_IGNORE == 0 && ( ! { check_single_user } ) ) then
	echo "To run admin initialization, you must be root and the system"
	echo "must be running single user."
	goto abort
endif
#
# make sure we have a tmp directory and it is empty.
# Save copies of all the stuff we are going to change.
#
if ( -e $ADM_DIR/tmp ) \
	/bin/rm -rf $ADM_DIR/tmp
mkdir $ADM_DIR/tmp
if ( ! { SaveVirgin } ) then
	echo "$ADM_DIR/$0 : can't save virgin files"
	exit(1)
endif

#
# get the new hostname...
#
first_HOSTNAME
if ( $status != 0 ) then
	goto abort
else
	setenv HOSTNAME `cat $ADM_DIR/tmp/hostname`
endif
/bin/hostname $HOSTNAME
#
# get network controller and inet addr info...
#
first_NETWORK
if ( $status != 0 ) \
	goto abort
#
# get password maintenace mode
#
first_PMODE
if ( $status != 0 ) \
	goto abort

############################################################################
##     OK, now take all this wonderful info and do something with it      ##
############################################################################

echo "==== updating /etc/rc.local ===="
ed - /etc/rc.local << EOF_EOF_EOF >& /dev/null
/   hostname/
c
    hostname $HOSTNAME
.
w
q
EOF_EOF_EOF

#
# Generate a block of lines to be included in the host file
#
# Get temp copy of /etc/hosts
# for each net interface
#	generate line for hostfile
# move new hostfile lines to end of new hostfile
#
echo "==== updating /etc/hosts ===="
cd $ADM_DIR/tmp
foreach f ( /etc/rc.local /etc/hosts )
	cp $f .
	if ( $status != 0 ) then
		echo "$0 : failed on cp $f"
		goto abort
	endif
end

set NET_CTLR = `grep '^NET_CTLR:[	 ]' net_info`
set NET_INET = `grep '^NET_INET:[	 ]' net_info`
set NET_DEST = `grep '^NET_DEST:[	 ]' net_info`
shift NET_CTLR
shift NET_INET
shift NET_DEST
if ( $NET_CTLR[1] == "nonet" ) then
        goto noconnect
endif
cp /dev/null hostfile.lines
while ( $#NET_CTLR > 0 )
	set CTLR = $NET_CTLR[1]
	set INET = $NET_INET[1]
	set DEST = $NET_DEST[1]
	echo "$INET	${HOSTNAME} ${HOSTNAME}.$CTLR" >> hostfile.lines
	shift NET_CTLR
	shift NET_INET
	shift NET_DEST
end
cat hostfile.lines >> hosts
/bin/rm hostfile.lines

#
# Copy the new versions of rc.local and hosts to /etc
#
cp hosts /etc/hosts
if ( $status != 0 ) then
	echo "$0 : error copying $ADM_DIRtmp/hosts /etc/hosts"
	goto abort
endif
(cd /dev ; ./MAKEDEV enet0) >& /dev/null

noconnect:
##########################################################################
# uucp setup...
##########################################################################
echo "==== setting up uucp directories ===="
foreach i ( /usr/lib/uucp /usr/spool/uucp /usr/spool/uucppublic	\
 /usr/spool/uucp/XTMP /usr/spool/uucp/CORRUPT /usr/spool/uucp/AUDIT	\
 /usr/spool/uucp/LCK /usr/spool/uucp/LOG /usr/spool/uucp/STST )
	if ( ! -d $i ) then
		if ( -e $i ) \
			/bin/rm -f $i
		/bin/mkdir $i
	endif
	/etc/chown uucp $i
	/bin/chmod 755 $i
	/bin/chgrp daemon $i
end
/bin/chmod 777 /usr/spool/uucppublic /usr/spool/uucp/LCK

foreach i (uucico uux uuxqt uucp xferstats)
	if ( ! -d /usr/spool/uucp/LOG/$i ) then
		if ( -e /usr/spool/uucp/LOG/$i ) \
			/bin/rm -f /usr/spool/uucp/LOG/$i
		/bin/mkdir /usr/spool/uucp/LOG/$i
	endif
	/etc/chown uucp /usr/spool/uucp/LOG/$i
	/bin/chmod 755 /usr/spool/uucp/LOG/$i
	/bin/chgrp daemon /usr/spool/uucp/LOG/$i
end

foreach i ( C. D.${HOSTNAME}X D.${HOSTNAME} D. X. TM. )
	if ( ! -d /usr/spool/uucp/$i ) then
		if ( -e /usr/spool/uucp/$i ) \
			/bin/rm -f /usr/spool/uucp/$i 
		mkdir /usr/spool/uucp/$i
	endif
	/etc/chown uucp /usr/spool/uucp/$i
	/bin/chgrp daemon /usr/spool/uucp/$i
	/bin/chmod 755 /usr/spool/uucp/$i
end

##########################################################################
#
# sendmail.{cf,fc} setup
#
##########################################################################
echo "==== setting up sendmail ===="
/usr/ucb/newaliases >& /dev/null
if ( $status != 0 ) then
	echo "$0 : couldn't access /usr/lib/mail/aliases database"
	goto abort
endif

##########################################################################
#
# Move anything left in tmp to $ADM_DIR/local-data.
#
##########################################################################
echo "==== saving local configuration data ===="
RemoveVirgin
if ( -e $ADM_DIR/local-data ) \
	/bin/rm -rf $ADM_DIR/local-data
mv $ADM_DIR/tmp $ADM_DIR/local-data
mkdir $ADM_DIR/tmp
exit(0)
############################################################################
##############         FINISHED!         ###################################
############################################################################

abort:
if ( ! { RestoreVirgin } ) then
	echo "WARNING - FILES NOT FULLY RESTORED - CONSULT ADMIN MANUAL"
	exit(1)
else
	echo "Files restored - admin quitting on fatal error"
	exit(1)
endif
