# /bin/csh -f
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

set noglob

#
# ask if the operator wants a password master machine
#
loop1:
echo ""
echo "You may define one machine on the network on which will reside the password"
echo "'master' file.  This master file will be consulted to determine whether"
echo "new user names and user id's are unique when they are entered.  Do you want"
echo -n "to define such a master password server? [ynqx?]  "
set ANS = `get_resp`
switch ( $ANS )
	case _HELP_ :
		adm_help TCP_P_SERVER
		goto loop1
		breaksw
	case [QqXx] :
		exit(1)
		breaksw
	case [Yy] :
		goto get_master
		breaksw
	case [Nn] :
		goto no_server
		breaksw
	default :
		echo "Invalid response..."
		goto loop1
		breaksw
endsw

#
# nope - no master.
#
no_master:
cp /dev/null $ADM_DIR/tmp/tcp_p_server
exit(0)

#
# yup - find out who the server is.
#
get_master:
echo -n "Enter the name of the password master machine [<name> or qx?]..."
set ANS = `get_resp`
switch ( $ANS )
	case _HELP_ :
		adm_help TCP_P_SERVER
		goto get_master
		breaksw
	case [QqXx] :
		exit(1)
		breaksw
	default :
		if ( { validate HOSTNAME $ANS } ) then
			if ( $ANS == $HOSTNAME ) then
				cp /dev/null $ADM_DIR/tmp/tcp_p_server
			else
				echo $ANS > $ADM_DIR/tmp/tcp_p_server
			endif
			exit(0)
		else
			echo "Invalid response..."
			goto get_master
		endif
		breaksw
endsw
