# /bin/csh -f
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

start:
set noglob

set NET_CTLR = ""
set NET_INET = ""
set NET_DEST = ""

echo ""
echo "For each network controller, enter the controller name"
echo "and the internet address associated with the controller."
echo "If the controller is a serial line interface, then you will"
echo "also have to specify the internet address of the destination"
echo "(other end of the serial link)."
echo ""
echo "To terminate input, type a blank line (just <return>) at the prompt"
echo "for controller name.  You may type a '?' at any prompt to get help,"
echo "or 'q' or 'x' to abort the admin initialization session."

set N = 1
loop_ctlr:
	echo ""
	echo -n "Controller # $N : "
	set ANS_CTLR = `get_resp`
	switch ( $ANS_CTLR )
		case "" :
			goto finish
			breaksw
		case _HELP_ :
			adm_help NET_CTLR
			goto loop_ctlr
			breaksw
		case [QqXx] :
			exit(1)
			breaksw
	endsw
	validate NET_CTLR $ANS_CTLR
	if ( $status != 0 ) \
		goto loop_ctlr

loop_inet:
	echo -n "Internet address for $ANS_CTLR : "
	set ANS_INET = `get_resp`
	switch ( $ANS_INET )
		case _HELP_ :
			adm_help NET_INET
			goto loop_inet
			breaksw
		case [QqXx] :
			exit(1)
			breaksw
	endsw
	validate NET_INET $ANS_INET
	if ( $status != 0 ) \
		goto loop_inet
	InetInUse $ANS_INET
	if ( $status == 0 ) \
		goto loop_inet

loop_dest:
	switch ( $ANS_CTLR )
	case tty* :
		echo -n "Inet destination address for $ANS_CTLR : "
		set ANS_DEST = `get_resp`
		switch ( $ANS_INET )
			case _HELP_ :
				adm_help NET_DEST
				goto loop_dest
				breaksw
			case [QqXx] :
				exit(1)
				breaksw
		endsw
		validate NET_SLP $ANS_INET $ANS_DEST
		if ( $status != 0 ) \
			goto loop_dest
		breaksw
	default :
		set ANS_DEST = ETHER
		breaksw
	endsw
	set NET_CTLR = ($NET_CTLR $ANS_CTLR)
	set NET_INET = ($NET_INET $ANS_INET)
	set NET_DEST = ($NET_DEST $ANS_DEST)
	@ N ++

goto loop_ctlr

finish:
echo ""
echo ""
echo "Network data entered is as follows:"
echo ""
set NN = 1
while ( $NN < $N )
	printf "%14s %14s %14s\n" $NET_CTLR[$NN] $NET_INET[$NN] $NET_DEST[$NN]
	@ NN ++
end
echo ""
echo "Enter one of the following:"
echo "	'y'		to accept this controller data"
echo "	'n'		to re-enter data"
echo "	'?'		for help"
echo "	'q or x'	to abort admin."
echo ""
echo -n "Enter action: "
set ANS = `get_resp`
switch ( $ANS )
	case _HELP_ :
		goto finish
		breaksw
	case [Yy] :
		echo "NET_CTLR:	$NET_CTLR" > $ADM_DIR/tmp/net_info
		echo "NET_INET:	$NET_INET" >> $ADM_DIR/tmp/net_info
		echo "NET_DEST:	$NET_DEST" >> $ADM_DIR/tmp/net_info
		exit(0)
		breaksw
	case [Nn] :
		goto start
		breaksw
	case [QqXx] :
		exit(1)
		breaksw
	default :
		echo "Invalid response..."
		goto finish
		breaksw
endsw
