/*
 * Name:
 * 	get_resp
 * 
 * Synopsis:
 * 	get_resp <help flag> <validate flag>
 *
 * Description:
 *	Throw away any type-ahead, then read one line from stdin.  If
 *	'validate flag' is not _NO_VALIDATE_ then pass the line on to
 *	the program 'validate', and exit using 
 *
 */

#include <stdio.h>
#include <sys/ioctl.h>

int             show_env = 0;

main(ac, av, ev)
	int             ac;
	char           *av[];
char           *ev[];
{
	int             old_stdin, old_stdout;

	old_stdin = dup(0);
	old_stdout = dup(1);

	close(0);
	close(1);

	if (open("/dev/tty", 0) != 0) {
		fprintf(stderr, "get_resp: didn't get stdin==0\n");
		exit(1);
	}
	if (open("/dev/tty", 1) != 1) {
		fprintf(stderr, "get_resp: didn't get stdout==1\n");
		exit(1);
	}
#ifdef	DEBUG
	if (show_env)
		while (*ev)
			printf("%s\n", *ev++);
#endif	DEBUG

	eat_input();

}



/*
 * eat_input - 
 *
 * throw away any typed-ahead characters. 
 */
eat_input()
{
	long            nleft;
	char            dummy;

	do {
		if (ioctl(0, FIONREAD, &nleft)) {
			perror("eat_input:");
			exit(1);
		}
		if (nleft > 0)
			read(0, &dummy, 1);
	} while (nleft > 0);
}
