/*
 * Name: get_resp 
 *
 * Synopsis: get_resp 
 *
 * Description: Throw away any type-ahead, then read one line from stdin.  If
 * first char of line is '?', then print "_HELP_". 
 */

#include <sys/ioctl.h>

main(ac, av, ev)
	int             ac;
	char           *av[], *ev[];
{
	int             old_stdin, old_stdout, n;
	static char     s[100];
	static char     temp[100];
	register char	*p;

	eat_input();
	n = read(0, s, 99);
	if (n >= 0) {
		while ( *s == ' ' || *s == '\t' ) {
			strcpy(temp, &s[1]);
			strcpy(s, temp);
		}
		if (*s == '?')
			write(1, "_HELP_\n", 7);
		else {
			if (strcmp("-m", av[1])) {
				p = s;
				while ( ' ' < *p && *p <= '~' )
					++p;
				*p++ = '\n';
				*p = 0;
			}
			write(1, s, strlen(s));
		}
	} else
		write(1, "_EOF_\n", 6);
	exit(0);
}



/*
 * eat_input - 
 *
 * throw away any typed-ahead characters. 
 */
eat_input()
{
	long            nleft;
	char            dummy;

	do {
		if (ioctl(0, FIONREAD, &nleft)) {
			perror("eat_input:");
			exit(1);
		}
		if (nleft > 0)
			read(0, &dummy, 1);
	} while (nleft > 0);
}
