#! /bin/csh -f
#
# Variables -
#	HOSTNAME	Hostname
#	HN_{ADM,RC,SET}	Three different source of hostname, all of which
#			should be identical, are the admin database (ADM),
#			/etc/rc (RC), and the hostname command (SET).
#	NET_CTRL[]	Array of network controllers
#	NET_INET[]	Array of internet addresses, matches up one-to-one
#			with elements of NET_CTRL[].
#	NET_DEST[]	Inet destination for point-to-point hookups.  This
#			is the "other end" of a serial line net controller.
#	P_MODE		Type of user account administration to do - legal values
#			are LOCAL, TCP, or YP.
#	TCP_PWD_MASTER	Name of some other machine on the net that is
#			considered to have "master" passwd and group files.
#			Valid only if P_MODE == TCP.
#
setenv ADM_DIR /usr/lib/admin
setenv ADM_DATA $ADM_DIR/local-data
setenv ADM_PROG /etc/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
setenv GID `getegid`
setenv UID `getuid`

setenv SU_IGNORE 0
setenv HARDCOPY 0
while ( $#argv > 0 )
	switch ( $1 )
		case "-h" :
			setenv HARDCOPY 1
		breaksw
		case "-s" :
			setenv SU_IGNORE 1
		breaksw
	endsw
	shift
end

start:
#
# FIRST - a bunch of consistancy checks...
#
if ( ! -d $ADM_DIR ) then
	echo "--- Can't locate $ADM_DIR --- maybe /usr is not mounted ---"
	goto fatal
endif
if ( ! -d $ADM_DATA ) then
	#
	# local-data directory does not exist - this must be the first
	# time admin has run on this system.  Go do initialization, then
	# re-exec admin.
	#
	first_time
	if ( $status == 0 ) then
		goto start
#		exec $ADM_PROG
	else
		exit(1)
	endif
else
	#
	# local-data exists, see if it all looks legit.
	# We will check the folowing files that should exist under local-data:
	#	hostname
	#	p_mode
	#	tcp_p_server
	#	net_info
	#
	# First check for simple existance
	#
	foreach f (hostname p_mode tcp_p_server net_info)
		if ( ! -r $ADM_DATA/$f ) then
			echo "--- Can't locate $ADM_DATA/$f ---"
			goto fatal
		endif
	end
	#
	# OK, they all exist, now try to validate them
	#
	# hostname...
	#
	set HN_SET = `hostname`
	set HN_RC  = `awk '/^[	 ]*hostname/	{print $2}' < /etc/rc.local`
	if ( $#HN_RC == 0 ) \
		set HN_RC  = `awk '/^hostname/	{print $2}' < /etc/rc.local`
	set HN_ADM = `cat $ADM_DATA/hostname`
	if ( $#HN_ADM != 1 ) \
		goto bad_hostname
	if ( $HN_RC != $HN_ADM ) \
		goto hn_mismatch_1
	if ( $HN_SET != $HN_ADM ) \
		goto hn_mismatch_2
	setenv HOSTNAME $HN_ADM
	#
	# p_mode and {yp,tcp}_p_server...
	#
	set P_MODE = `cat $ADM_DATA/p_mode`
	switch ( $P_MODE )
		case LOCAL :
			breaksw
		case TCP :
			set TCP_P_SERVER = `cat $ADM_DATA/tcp_p_server`
			if ( $#TCP_P_SERVER != 1 ) \
				goto bad_tcp_p_server
			breaksw
		case YP :
			breaksw
		default :
			goto bad_p_mode
	endsw
###	#
###	# legal_users...
###	#
###	set LEGAL_USERS = `grep '^LEGAL_USERS:[	 ]' $ADM_DATA/legal_users`
###	if ( $status != 0 ) \
###		goto bad_legal_users
###	shift LEGAL_USERS
	#
	# net_info
	#
	set NET_CTLR = `grep '^NET_CTLR:[	 ]' $ADM_DATA/net_info`
	if ( $status != 0 ) \
		goto bad_net_info
	set NET_INET = `grep '^NET_INET:[	 ]' $ADM_DATA/net_info`
	if ( $status != 0 ) \
		goto bad_net_info
	set NET_DEST = `grep '^NET_DEST:[	 ]' $ADM_DATA/net_info`
	if ( $status != 0 ) \
		goto bad_net_info
	if ( $#NET_CTLR != $#NET_INET ) \
		goto bad_net_info
	if ( $#NET_CTLR != $#NET_DEST ) \
		goto bad_net_info
	shift NET_CTLR
	shift NET_INET
	shift NET_DEST
endif

#
# Looks like the environment is safe to play in.  Present the Menu.
#
menu_top

/bin/rm -rf $ADM_DIR/tmp
/bin/mkdir $ADM_DIR/tmp
exit(0)
#
# Fatal Errors:
#
bad_hostname:
	echo "--- Botched $ADM_DATA/hostname file ---"
	goto fatal
hn_mismatch_1:
	echo "--- Hostname in rc.local does not match $ADM_DATA/hostname ---"
	goto fatal
hn_mismatch_2:
	echo "--- Current hostname does not match $ADM_DATA/hostname ---"
	goto fatal
bad_p_mode:
	echo "--- Botched $ADM_DATA/p_mode file ---"
	goto fatal
bad_legal_users:
	echo "--- Botched $ADM_DATA/legal_users file ---"
	goto fatal
bad_net_info:
	echo "--- Botched $ADM_DATA/net_info file ---"
	goto fatal
fatal:
	echo "--- Admin throwing hands up in utter despair and quitting."
	exit(1)
