#! /bin/csh -f
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
switch ( $1 )

case ADMIN_PARAMS :
	echo ""
	echo "HELP: CHANGE ADMIN PARAMETERS"
	echo "The Change Admin Parameters menu allows the system administrator"
	echo "to change certain system parameters: hostname, password server,"
	echo "user account mode and network configuration."
	echo ""
	breaksw
case CHANGE_NETWORK :
	echo ""
	echo "HELP: CHANGE NETWORK INFO"
	echo "The Change Network menu allows the system administrator to add"
	echo "new network entries to the /etc/hosts file.
	echo ""
	breaksw
case DISKLESS_INSTALL :
	echo ""
	echo "HELP: DISKLESS/CLUSTER INSTALLATION"
	echo "The diskless/cluster install menu allows the creating or"
	echo "deleting of diskless/cluster nodes on a server.  Diskless"
	echo "and cluster nodes have similar private files on a server."
	echo "Adding a diskless or cluster node will create the necessary"
	echo "private files and directories and modify the required system"
	echo "files to support diskless/cluster boot and normal operation."
	echo ""
	breaksw
case DISKLESS_GRAPHICS :
	echo ""
	echo "HELP: DISKLESS/CLUSTER GRAPHICS"
	echo "If a diskless/cluster is a graphics system (color or monochrome)"
	echo "admin sets up the appropriate system files to run the window"
	echo "manager instead of a standard shell."
	echo ""
	breaksw
case DISKLESS_NAME:
	echo ""
	echo "HELP: DISKLESS/CLUSTER NAME"
	echo "The name of the diskless/cluster node is the name by which"
	echo "the node will be known on the local network.  The name is"
	echo "set on the system by the hostname utility and it must agree"
	echo "with an entry in the /etc/hosts file.  A name must start with"
	echo "a letter and be no more than 64 characters long."
	echo ""
	breaksw
case DISKLESS_EADDR:
	echo ""
	echo "HELP: DISKLESS/CLUSTER PHYSICAL ETHERNET ADDRESS"
	echo "This is the hardware address of a diskless node or cluster."
	echo "It is not to be confused with the node's logical 'internet"
	echo "address'.  Admin expects ethernet addresses to be expressed "
	echo "in the form of six hexidecimal numbers each separated by a colon,"
	echo "for example, 70:1:0:70:2:4e.  To obtain the ethernet address"
	echo "of a DISKLESS node, type the command 'dev(0,0)?' on the console"
	echo "of the DISKLESS node while it is in the CPU PROM monitor, where"
	echo "dev = ex if the diskless has an EXELAN (ex) controller or "
	echo "dev = nw if the controller is an Integrated Solutions ECX (nw)."
	echo "If the node being added is a CLUSTER, its ethernet address will"
	echo "be 70:1:0:7f:ff:X, where X = 0 for the cluster server, X = 1 for"
	echo "cluster number 1, X = 2 for cluster number 2, and so on."
	breaksw
case DISKLESS_CPU:
	echo ""
	echo "HELP: DISKLESS/CLUSTER CPU TYPE"
	echo "There are three possible types of CPU board supported with"
	echo "this release of software, the 68k20, the 68225, and the"
	echo "68k30.  The cpu type is displayed on the console by the"
	echo "prom monitor when the machine is reset. The response to "
	echo "this question is used in selecting a kernel for the diskless"
	echo "or cluster machine."
	breaksw
case HOSTNAME :
	echo ""
	echo "HELP: SYSTEM NAME"
	echo "Hostname is a string of up to 64 characters that is the"
	echo "name of this system.  This is the name that other systems"
	echo "on the network will use to talk to this system."
	echo ""
	breaksw
case NET_SETUP :
	echo ""
	echo "HELP: NETWORK SETUP"
	echo "One of the first tasks that the admin utility performs is the"
	echo "determination of whether or not this system will be accessible"
	echo "over a network.  If this is the case, the admin utility will"
	echo "prompt the user for all network interfaces (eg: ex0, ex1, nw0,"
	echo "vb0, ...) and the internet address for each of these devices."
	echo "Each internet address is a string of numbers separated by .'s, of"
	echo "the form XX.YY.ZZ.AA."
	echo ""
	breaksw
case RENAME :
	echo ""
	echo "HELP: RENAMING A SYSTEM"
	echo "If the system name is to changed after it has been set up"
	echo "using the admin program, the admin utility must be rerun"
	echo "essentially from scratch (added users/groups need not be"
	echo "added again)."
	echo ""
	breaksw
case USER_NAME :
	echo ""
	echo "HELP: LOGIN NAME"
	echo "User name is the user's login name.  It must start with a"
	echo "letter and be no more than 256 characters long.  A user's"
	echo "login name is typically also the name of the user's home"
	echo "directory."
	echo ""
	breaksw
case USER_GROUP :
	echo ""
	echo "HELP: GROUP"
	echo "User group is typically the organization/group that a user"
	echo "is associated with.  A user's group determines whether he/she"
	echo "will have access to files that are protected for group access."
	echo "Examples of predefined groups are wheel, staff, operator, etc.."
	echo ""
	breaksw
case USER_HOMEDIR :
	echo ""
	echo "HELP: USER HOME DIRECTORY"
	echo "A user's home directory is the directory in which a user starts"
	echo "out from after logging in.  It is typically the root of a user's"
	echo "personal files and directories.  Typically a user's home"
	echo "directory is located in the /usr partition but need not be."
	echo "A user home directory name must be a valid pathname."
	echo ""
	breaksw
case USER_MAINT :
	echo ""
	echo "HELP: USER MAINTENANCE"
	echo "The User Maintenance menu provides the means of adding or"
	echo "deleting users or groups.  Adding users will create entries"
	echo "in the /etc/passwd file and create a home directory in the"
	echo "specified directory.  Adding groups will modify the /etc/group"
	echo "file."
	echo ""
	breaksw
case USER_REALLIFE :
	echo ""
	echo "HELP: USER REAL NAME"
	echo "A user's reallife data is saved in the password file and is"
	echo "printed by the finger utility and some mail header formats."
	echo "This data is not required for any other purpose."
	echo ""
	breaksw
case USER_SHELL :
	echo ""
	echo "HELP: USER SHELL"
	echo "A user's shell is the command line interpreter that is executed"
	echo "when a user logs in.  Typically it is the C Shell (/bin/csh)."
	echo "An alternative is the Bourne Shell (/bin/sh)."
	echo ""
	breaksw
default :
	echo "Help for $1 not available yet...
	breaksw
endsw
echo -n "type <return> to continue..."
set a = ($<)
exit(0)
