#! /bin/csh
#
# Name:
#	 UNRHOST
#
# syntax:
#
#	 UNRHOST file [file ...]
#
# Description:
#
#	for each file:
#		mv .file. file
#		rm .file.$RHOST
#
#

set i = ( \
/dev			\
/etc/fstab			\
/etc/motd			\
/etc/psdatabase			\
/etc/ttys			\
/etc/utmp			\
/etc/printcap			\
/tmp			\
/usr/adm			\
/usr/lib/mail   			\
/usr/lib/crontab			\
/usr/spool			\
/usr/tmp			\
/vmunix			\
)




foreach f ($i)
	set head = $f:h
	set tail = $f:t
	if ( $head == $tail ) then
		set hidden = .${head}.
	else
		set hidden = ${head}/.${tail}.
	endif
	echo $hidden
	if ( ! -e $hidden ) then
		echo $hidden not found
	else

#
# change original name back (.foo. to foo) and remove the
# symbolic link (.foo.$RHOST).
#
		if ( -e $hidden ) then
			if ( -e $f ) then
				/bin/rm -rf $f
			endif
			mv $hidden $f
			if ( -e ${hidden}'$RHOST' ) \
				/bin/rm -rf ${hidden}'$RHOST'
		endif
	endif
end
