#! /bin/csh -f
#
# SaveVirgin - squirrel away safe copies of files that are to be changed
# during initialization so they can be restored in an emergency.
#
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)
set SAVEFILES = ( 		\
	/etc/passwd		\
	/etc/hosts		\
	/etc/rc.local 		\
	/etc/group		\
	/usr/lib/mail/sendmail.cf	\
	/usr/spool/uucp		\
)

if ( -e $ADM_DIR/tmp/Virgin.tar ) \
	/bin/rm -f $ADM_DIR/tmp/Virgin.tar

tar cf $ADM_DIR/tmp/Virgin.tar $SAVEFILES
if ( $status != 0 ) then
	if ( -e $ADM_DIR/tmp/Virgin.tar ) \
		/bin/rm -f $ADM_DIR/tmp/Virgin.tar
	echo "$ADM_DIR/$0 : unknown error during file save."
	exit(1)
else
	exit(0)
endif
