#! /bin/csh  -f
if ( ! $?ADM_DIR ) \
	set ADM_DIR = /usr/lib/admin
set path = ($ADM_DIR $ADM_DIR/bin /bin /usr/bin /etc)

set noglob

set TYPE = $1
set HOSTNAME = `cat $ADM_DIR/local-data/hostname`
#
# make sure the server has some interface available.
#
if ( $TYPE == cluster ) then
	set VB_IF = `grep -v '^#' /etc/hosts | grep -w ${HOSTNAME}.vb0`
	if ( $status != 0 ) \
		goto no_vb
	set INET = `NextNetAddress $VB_IF`
else
	grep -s 'NET_DEST.*ETHER' $ADM_DIR/local-data/net_info
	if ( $status != 0 ) \
		goto no_ether
endif

#
# get name of the new node
#
nameloop:
echo ""
echo ""
echo -n "Enter the name of the new $TYPE node...(? for help, [qx] to abort)..."
set NAME = `get_resp`
switch ( $NAME )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_NAME
		goto nameloop
		breaksw
	default :
		if ( ! { validate HOSTNAME $NAME } )	\
			goto nameloop
		if ( { NameInUse $NAME } )	\
			goto nameloop
		goto gotname
		breaksw
endsw
gotname:

#
# get net address for new node
#
inetloop:
if ( $TYPE == cluster ) \
	goto gotinet
echo ""
echo ""
echo -n "Internet address for $NAME...(? for help, [qx] to abort)..."
set INET = `get_resp`
switch ( $INET )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_INET
		goto inetloop
		breaksw
	default :
		if ( ! { validate NET_INET $INET } ) \
			goto inetloop
		if ( { InetInUse $INET } )	\
			goto inetloop
		goto gotinet
		breaksw
endsw
gotinet:

# get ethernet address (xx:xx:xx:xx:xx:xx ) for bootd.conf entry
eaddrloop:
#if ( $TYPE == cluster ) then
#	got goteaddr
#endif
echo ""
echo "Physical ethernet address for $NAME (? for help, [qx] to abort)"
echo -n "                           Press RETURN key if address unknown: "
set EADDR = `get_resp`
switch ( $EADDR )
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_EADDR
		goto eaddrloop
		breaksw
	case "":
		set EADDR = 00:00:00:00:00:00
		echo -n The address \"$EADDR\" will be placed in the 
		echo " bootd.conf file."
		echo -n "It should be replaced with the actual address once"	
		echo " it is determined."
		echo -n "Press RETURN to continue:"
		set dummy = $<
		breaksw
	default :
		if ( ! { validate NET_EADDR $EADDR } ) \
			goto eaddrloop
		goto goteaddr
		breaksw
endsw
goteaddr:
#
# See what kind of interface it has.
#
if ( $TYPE == cluster ) then
	set CTLR = vb0
else
	ifaceloop:
	echo ""
	echo ""
	echo -n "Enter the name of the Ethernet controller on $NAME (? for help, [qx] to abort)..."
	set CTLR = `get_resp`
	switch ( $CTLR )
		case [QqXx] :
			exit(0)
			breaksw
		case _HELP_ :
			adm_help NET_CTLR
			goto ifaceloop
			breaksw
		default :
			if ( ! { validate ETHER_CTLR $CTLR } ) \
				goto ifaceloop
			goto gotiface
			breaksw
	endsw
gotiface:
endif

#
# graphics?
#
grloop:
echo ""
echo ""
echo -n "Is $NAME a graphics system? [ynq?]  "
set ans = `get_resp`
switch ( $ans )
	case [Yy] :
		set GRAPHICS = GRAPHICS
		breaksw
	case [Nn] :
		set GRAPHICS = NOGRAPHICS
		breaksw
	case [QqXx] :
		exit(0)
		breaksw
	case _HELP_ :
		adm_help DISKLESS_GRAPHICS
		goto grloop
		breaksw
	default :
		echo "Invalid response...please answer one of [ynq or ?]..."
		goto grloop
		breaksw
endsw

# architecture
# Prompt user for type of architecture V20, V25 or V30
# 
while(1)
	echo ""
	echo ""
	echo "What type of CPU does the $TYPE have?"
	echo ""
	echo "				1)  68k20 (V20)"
	echo "				2)  68225 (V25)"
	echo "				3)  68k30 (V30)"
	echo "				4)  Liberator(VQX)"
	echo ""
	echo -n "Enter one of the above or (? for help or [qx] to abort):"
	set ans = `get_resp`
	switch ($ans)
		case 1:
		case 68K20:
		case 68k20:
		case V20:
		case v20:
		case 20:
			set CPUTYPE = V20
			break
		case 2:
		case 68225:
		case V25:
		case v25:
		case 25:
			set CPUTYPE = V25
			break	
		case 3:
		case 68K30:
		case 68k30:
		case V30:
		case v30:
		case 30:
			set CPUTYPE = V30
			break
		case 4:
		case Liberator:
		case VQX:
		case vqx:
		case Vqx:
		case vQX:
		case qx:
		case QX:
			set CPUTYPE = VQX
			break
		case [QqXx]:
			exit(0)
			breaksw
		case _HELP_:
			adm_help DISKLESS_CPU	
			breaksw
		default:
			echo "Invalid response... try again..."  
			breaksw
	endsw	
end	
#
# OK, we have all we need.  Modify the host file and set up the special
# directories and files.
#
echo ""
echo "The following line will be added to the host file.  Note the name and"
echo "internet address in your System Administrator Guide for future reference:"
echo ""
echo "	$INET     $NAME ${NAME}.${CTLR}"
echo ""
echo -n "Press <return> to continue..."
set dummy = ($<)
echo ==== updating host file
echo "$INET	$NAME ${NAME}.${CTLR}" >> /etc/hosts
echo ""
echo "The following line will added to the /etc/bootd.conf file. Note this"
echo "in the System Administrator Guide for future reference:"
echo ""
echo $EADDR $NAME $HOSTNAME\:/.vmunix.$NAME HOST=$NAME SERVER=$HOSTNAME
echo ""
echo -n "Press <return> to continue..."
set dummy = ($<)
echo ==== updating bootd.conf file ====
echo $EADDR $NAME $HOSTNAME\:/.vmunix.$NAME HOST=$NAME SERVER=$HOSTNAME \
	>> /etc/bootd.conf

echo ==== checking diskless swap area ====
if ( ! -d /usr/spool/diskless ) then
	if ( -e /usr/spool/diskless ) then
		rm -f /usr/spool/diskless
	endif
	mkdir /usr/spool/diskless
	chmod 700 /usr/spool/diskless
endif
echo ==== creating private files and directories
Rhost $NAME $CTLR $GRAPHICS
echo ==== installing kernel ====
install_kernel $NAME $CPUTYPE
exit(0)

#
# Need to configure some interface for server interface...
#
no_vb:
echo "The vb interface is not configured in /etc/hosts.  This configuration may be"
echo "done by selecting the MODIFY ADMIN PARAMETERS option from the admin top"
echo "menu, then selecting the option to modify network interfaces from the next"
echo -n "menu.   Type <return> to continue..."
set dummy = `get_resp`
exit(0)

no_ether:
echo "There is no ethernet interface configured on this machine.  This"
echo "configuration may be done by selecting the MODIFY ADMIN PARAMETERS"
echo "option from the admin top menu, then selecting the option to modify"
echo -n "network interfaces from the next menu.   Type <return> to continue..."
set dummy = `get_resp`
exit(0)
