#include "../condevs.h"

#ifdef TELEBIT

/*
 * First pass at a driver.  This is just a copy of hys.c with the names
 * changed to protect the innocent.  It assumes that the modem is going
 * to always talk at 9600 baud, and it makes no attempt to set up any
 * registers that were not set up in the Hayes.  The only real difference
 * is that the Telebit returns RRING instead of RING, otherwise it could
 * be run with the Hayes driver.
 *
 *	telebpopn(telno, flds, dev) connect to telebit (pulse call)
 *	telebtopn(telno, flds, dev) connect to telebit (tone call)
 *	char *flds[], *dev[];
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		CF_DIAL,CF_DEVICE  -  failed
 */

telebpopn(telno, flds, dev)
char *telno, *flds[];
struct Devices *dev;
{
	return telebopn(telno, flds, dev, 0);
}

telebtopn(telno, flds, dev)
char *telno, *flds[];
struct Devices *dev;
{
	return telebopn(telno, flds, dev, 1);
}

/* ARGSUSED */
telebopn(telno, flds, dev, toneflag)
char *telno;
char *flds[];
struct Devices *dev;
int toneflag;
{
	extern errno;
	char dcname[20];
	char cbuf[MAXPH];
	register char *cp;
	register int i;
	int dh = -1, nrings = 0;

	sprintf(dcname, "/dev/%s", dev->D_line);
	DEBUG(4, "dc - %s\n", dcname);
	if (setjmp(Sjbuf) == 0) {
		signal(SIGALRM, alarmtr);
		getnextfd();
		errno = 0;
		alarm(10);
		dh = open(dcname, 2); /* read/write */
		alarm(0);
	} else {
#ifdef	LNOMDM
		if (setjmp(Sjbuf) == 0) {
			signal(SIGALRM, alarmtr);
			getnextfd();
			errno = 0;
			alarm(10);
			dh = open(dcname, 2|O_NDELAY); /* read/write */
			alarm(0);
			if (dh >= 0) {
				int lnomdm = LNOMDM;
				ioctl(dh, TIOCEXCL, STBNULL);	/* first */
				ioctl(dh, TIOCLBIS, &lnomdm);
			}
		} else {
			DEBUG(1, "timeout telebit open %s\n", dcname);
			logent("telebit open", "TIMEOUT");
			if (dh >= 0)
				close(dh);
			delock(dev->D_line);
			return(CF_DIAL);
		}
#else	LNOMDM
		DEBUG(1, "timeout telebit open %s\n", dcname);
		logent("telebit open", "TIMEOUT");
		if (dh >= 0)
			close(dh);
		delock(dev->D_line);
		return(CF_DIAL);
#endif	LNOMDM
	}
	/* modem is open */
	next_fd = -1;
	if (dh >= 0) {
		fixline(dh, dev->D_speed);
		if (dochat(dev, flds, dh)) {
			logent(dcname, "CHAT FAILED");
			telebcls(dh);
			return CF_DIAL;
		}
		sleep(2);
		slowrite(dh, "+++");
		sleep(2);
		slowrite(dh, "ATZ\r");
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "HSM seems dead");
			telebcls(dh);
			return CF_DIAL;
		}
		sleep(2);
		slowrite(dh, "+++");
		sleep(2);
		slowrite(dh, "ATH0\r");
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "HSM seems dead");
			telebcls(dh);
			return CF_DIAL;
		}
		sleep(2);
		slowrite(dh, "+++");
		sleep(2);
		slowrite(dh, "ATV1E0\r");
		if (expect("OK\r\n", dh) != 0) {
			logent(dcname, "HSM seems dead");
			telebcls(dh);
			return CF_DIAL;
		}
		if (toneflag)
			slowrite(dh, "\rATDT");
		else
			slowrite(dh, "\rATDP");
		slowrite(dh, telno, strlen(telno));
		slowrite(dh, "\r");

		if (setjmp(Sjbuf)) {
			logent(dcname, "TIMEOUT");
			strcpy(devSel, dev->D_line);
			telebcls(dh);
			return CF_DIAL;
		}
		signal(SIGALRM, alarmtr);
		alarm(2*MAXMSGTIME);
		do {
			cp = cbuf;
			while (read(dh, cp ,1) == 1)
				if (*cp >= ' ')
					break;
			while (++cp < &cbuf[MAXPH] && read(dh, cp, 1) == 1 && *cp != '\n')
				;
			alarm(0);
			*cp-- = '\0';
			if (*cp == '\r')
				*cp = '\0';
			DEBUG(4,"\nGOT: %s", cbuf);
			alarm(MAXMSGTIME);
		} while (strncmp(cbuf, "RRING", 4) == 0 && nrings++ < 5);
		if (strncmp(cbuf, "CONNECT", 7) != 0) {
			logent(cbuf, _FAILED);
			strcpy(devSel, dev->D_line);
			telebcls(dh);
			return CF_DIAL;
		}
		i = atoi(&cbuf[8]);
		if (i > 0 && i != dev->D_speed) {	
			DEBUG(4,"Baudrate reset to %d\n", i);
			fixline(dh, i);
		}

	}
	if (dh < 0) {
		logent(dcname, "CAN'T OPEN");
		return dh;
	}
	DEBUG(4, "telebit ok\n", CNULL);
	return dh;
}

telebcls(fd)
int fd;
{
	char dcname[20];

	if (fd > 0) {
		sprintf(dcname, "/dev/%s", devSel);
		DEBUG(4, "Hanging up fd = %d\n", fd);
		sleep(2);
		slowrite(fd, "+++");
		sleep(2);
		slowrite(fd, "ATH0\r");
		if (expect("OK",fd) != 0)
			logent(devSel, "HSM did not respond to ATH0");
		slowrite(fd, "ATZ\r");
		if (expect("OK",fd) != 0)
			logent(devSel, "HSM did not respond to ATZ");
		sleep(1);
		close(fd);
		delock(devSel);
	}
}
#endif TELEBIT
