#ifdef	UTMP

#include "ww.h"
#include <pwd.h>
#include <stdio.h>
#include <utmp.h>
#include <sys/file.h>
#include <sys/types.h>

char *rindex();
char *getlogin();

wwutmp(tname,slot)
char *tname;
int slot;
{
    char *tty;
    struct utmp utmp;
    char *lname;
    struct passwd *pwd;
    int f;

    tty = rindex(tname, '/');
    if (tty == NULL)
	tty = tname;
    else
	tty++;
    bzero((char *)&utmp, sizeof(utmp));
    if ((lname = getlogin()) == NULL) {
	pwd = getpwuid(getuid());
	strncpy(utmp.ut_name, pwd->pw_name, sizeof(utmp.ut_name));
    } else strncpy(utmp.ut_name, lname, sizeof(utmp.ut_name));
    time(&utmp.ut_time);
    if (slot > 0 && (f = open("/etc/utmp", O_WRONLY)) >= 0) {
	lseek(f, (long)(slot*sizeof(utmp)), 0);
	strcpy(utmp.ut_line, tty);
	write(f, (char *)&utmp, sizeof(utmp));
	close(f);
    }
}

clearutmp()
{
    struct ww *w;

    for (w = wwhead.ww_forw; w != &wwhead; w = w->ww_forw)
	wwclrutmp(w->ww_slot);
}

wwclrutmp(slot)
int slot;
{
    struct utmp utmp;
    int f;

    if (slot > 0 && (f = open("/etc/utmp", O_WRONLY)) >= 0) {
	bzero((char *)&utmp, sizeof(utmp));
	lseek(f, (long)(slot*sizeof(utmp)), 0);
	write(f, (char *)&utmp, sizeof(utmp));
	close(f);
    }
}

#endif UTMP
