static char *RCSid = "$Header: machine.c,v 1.1 86/03/11 10:07:17 root Exp $";

/*
 * $Log:	machine.c,v $
 * Revision 1.1  86/03/11  10:07:17  root
 * Initial revision
 * 
 */

/* Copyright (c) 1982 Regents of the University of California */


/*
 * Target machine dependent stuff.
 */

#include "defs.h"
#include "machine.h"
#include "process.h"
#include "runtime.h"
#include "events.h"
#include "main.h"
#include "symbols.h"
#include "source.h"
#include "mappings.h"
#include "object.h"
#include "ops.h"
#include <signal.h>
#include <sys/types.h>

#ifndef public
typedef unsigned int Address;
typedef unsigned char Byte;
typedef unsigned int Word;

# ifdef mc68000
#define NREG 17

#define ARGP 14		/* ARGP and FRP same on 68000's */
#define FRP 14
#define STKP 15
#define PROGCTR 16
# endif mc68000
# ifdef vax
#define NREG 16

#define ARGP 12
#define FRP 13
#define STKP 14
#define PROGCTR 15
# endif vax

#define BITSPERBYTE 8
#define BITSPERWORD (BITSPERBYTE * sizeof(Word))


#include "source.h"
#include "symbols.h"

Address pc;
Address prtaddr;

# define currlevel() ((whatblock(pc))->level)

#endif public

# define isjsr(x) (((x) & 0xffc0) == 0x4e80)
# define isjmp(x) (((x) & 0xffc0) == 0x4ec0)
# define isbsr(x) (((x) & 0xff00) == 0x6100)
# define isbra(x) ((((x) & 0xf000) == 0x6000) && (((x) & 0x0f00) == 0))
# define isbcc(x) ((((x) & 0xf000) == 0x6000) && (((x) & 0x0e00) != 0))
# define isrts(x) ((x) == 0x4e75)
# define isrtr(x) ((x) == 0x4e77)
# define isdbcc(x) (((x) & 0xf0f8) == 0x50c8)
# define islink(x) (((x) & 0xfff8) == 0x4e50)
# define ismoveml(x) (((x) & 0xffc0) == 0x48c0)
# define ismovl(x) (((x) & 0xf000) == 0x2000)

#ifdef mc68000
/*
 * Return the number of arguments passed to the current procedure.
 */

public Word nargspassed(frp)
Frame frp;
{
#define ADDQL	0x508F		/* addql #n,sp	*/
#define AQMASK	0xF1FF		/* mask for addql instruction */
#define ADDL	0xDFFC		/* addl #n,sp	*/
#define ADDW	0xDEFC		/* addw #n,sp	*/
#define LEA	0x4FEF		/* lea sp@(n),sp	*/

    Word num_args;
    u_short ins[3];
    Address addr, disp;

    if (frp == nil)
	return 0;

    addr = frp->save_pc;
again:
    iread(ins, addr, sizeof(ins));
    if ((ins[0] & AQMASK) == ADDQL) {
	num_args = (ins[0]>>9) & 07;
	if (num_args == 0) num_args = 8;
    } else if (ins[0] == LEA || ins[0] == ADDW)
	num_args = ins[1];
    else if (ins[0] == ADDL)
	num_args = *(int *)&ins[1];
    else if (isbra(ins[0])) {
	if ((disp = (char)(ins[0] & 0xff)) == 0)
	    disp = (short)ins[1];
	addr += (disp + 2);
	goto again;
    } else
	num_args = 0;

    /* round up to integral number of words */
    return (num_args + (sizeof(Word) - 1)) / sizeof(Word);

#undef ADDQL
#undef AQMASK
#undef ADDL
#undef ADDW
#undef LEA
}
#else (vax)
#define nargspassed(frame) argn(0, frame)
#endif mc68000

/*
 *	Groaty routine to get the register mask
 *	and stack offset of register save area.
 *	Have to disassemble the stack frame setup code.
 */

public getmask(func,spoff)
Symbol func;
int *spoff;
{
	u_short codebuf[4];
	register Address disp;
	register Address addr;
	register u_short reg_mask;

	if ((addr = func->symvalue.funcv.beginaddr) == nil)
		return 0;

	iread(codebuf, addr, sizeof(codebuf));
	if (isbra(codebuf[0])) {
	    if ((disp = (char)(codebuf[0] & 0xff)) == 0)
		disp = (short)codebuf[1];
	    addr += (disp + 2);
	}
	else if (isjmp(codebuf[0])) {
	    addr = * (Address *) codebuf[1];	/* unlikely to happen */
	}
	else if (!islink(codebuf[0]))
	    return 0;				/* don't understand this! */

	reg_mask = 0;
	iread(codebuf, addr, sizeof(codebuf));
	if (islink(codebuf[0])) {
	    *spoff = (short)codebuf[1];		/* codebuf is a u_short */
	    if (ismovl(codebuf[2]) && ((codebuf[2] & 07760) == 07200)) {
		/* movl rn,sp@ */
		reg_mask = 1 << (codebuf[2] & 0x000f);
	    }
	    else if (ismoveml(codebuf[2])) {
		reg_mask = codebuf[3];
	    }
	}

	return reg_mask;
}


Address printop();

/*
 * Decode and print the instructions within the given address range.
 */

public printinst(lowaddr, highaddr)
Address lowaddr;
Address highaddr;
{
    register Address addr;

    for (addr = lowaddr; addr <= highaddr; ) {
	addr = printop(addr);
    }
    prtaddr = addr;
}

/*
 * Another approach:  print n instructions starting at the given address.
 */

public printninst(count, addr)
int count;
Address addr;
{
    register Integer i;
    register Address newaddr;

    if (count <= 0) {
	error("non-positive repetition count");
    } else {
	newaddr = addr;
	for (i = 0; i < count; i++) {
	    newaddr = printop(newaddr);
	}
	prtaddr = newaddr;
    }
}

Address printop(addr)
Address addr;
{
	Address dest;

	printf("%08x  ", addr);
	addr = disasm(true, addr, &dest);
	printf("\n");
	return (addr);
}

public Address skip_frsetup(startaddr)
Address startaddr;
{
    register Address addr;
    register int disp;
    Opcode ins[3];

    addr = startaddr;
    iread(ins, addr, sizeof(ins));
    if (isbra(ins[0])) {
	addr += 2;
	if ((disp = (char)(ins[0] & 0xff)) == 0)
	    disp = (short)ins[1];
	addr += disp;
	iread(ins, addr, sizeof(ins));
    }
    if (islink(ins[0])) {
	addr += 4;
	iread(ins, addr, sizeof(ins));
	if (ismovl(ins[0]) && ((ins[0] & 07760) == 07200)) {
	    /* movl rn,sp@ */
	    addr += 2;		/* skip opcode */
	    iread(ins, addr, sizeof(ins));
	}
	else if (ismoveml(ins[0])) {
	    /* moveml	#<...>,an@ */
	    addr += 4;		/* skip opcode and reg list mask */
	    iread(ins, addr, sizeof(ins));
	}
#ifdef tws
	if (ismovl(ins[0]) && ((ins[0] & 07777) == 06574)) {
	    /* movl	#nnnn,a6@(n) */
	    addr += 8;	/* skip opcode, #immed and offset */
	    iread(ins, addr, sizeof(ins));
	}
#endif tws
    }
    if (isbra(ins[0])) {
	addr += 2;
	if ((disp = (char)(ins[0] & 0xff)) == 0)
	    disp = (short)ins[1];
	addr += disp;
    }

    return addr;
}

Address staticaddr(addr,opcode)
Address addr;
register u_short *opcode;
{
    register int opval;
    register int opmode;
    register Address retval;

    if (isbsr(*opcode) || isbra(*opcode)) {
	if (*opcode & 0xff) {
	    retval = (char)(*opcode & 0xff) + addr + 2;
	}
	else {
	    retval = (*(short *)(opcode+1)) + addr + 2;
	}
    }
    else if (isjsr(*opcode) || isjmp(*opcode)) {

	opval = (*opcode) & 0x07;
	opmode = ((*opcode) >> 3) & 0x07;

	if (opmode != 7)
	    return nil;

	switch(opval) {

	    case 0:
		retval =  (long) (*(short *) (opcode+1));

	    case 1:
		retval =  (* (Address *)(opcode+1));

	    case 2:
		retval =  ((* (short *)(opcode+1)) + (long)addr + 2);
		
	    case 3:
		retval =  nil;
		
	}
    }
    return retval;
}


/*
 * Print the contents of the addresses within the given range
 * according to the given format.
 */

typedef struct {
    String name;
    String printfstring;
    int length;
} Format;

private Format fmt[] = {
    { "d", " %d", sizeof(short) },
    { "D", " %ld", sizeof(long) },
    { "o", " %o", sizeof(short) },
    { "O", " %lo", sizeof(long) },
    { "x", " %04x", sizeof(short) },
    { "X", " %08x", sizeof(long) },
    { "b", " \\%o", sizeof(char) },
    { "c", " '%c'", sizeof(char) },
    { "s", "%c", sizeof(char) },
    { "f", " %f", sizeof(float) },
    { "g", " %g", sizeof(double) },
    { nil, nil, 0 }
};

private Format *findformat(s)
String s;
{
    register Format *f;

    f = &fmt[0];
    while (f->name != nil and not streq(f->name, s)) {
	++f;
    }
    if (f->name == nil) {
	error("bad print format \"%s\"", s);
    }
    return f;
}

public Address printdata(lowaddr, highaddr, format)
Address lowaddr;
Address highaddr;
String format;
{
    register int n;
    register Address addr;
    register Format *f;
    register Boolean isstring;
    char c;
    union {
	char charv;
	short shortv;
	int intv;
	float floatv;
	double doublev;
    } value;

    if (lowaddr > highaddr) {
	error("first address larger than second");
    }
    f = findformat(format);
    isstring = (Boolean) streq(f->name, "s");
    n = 0;
    value.intv = 0;
    for (addr = lowaddr; addr <= highaddr; addr += f->length) {
	if (n == 0) {
	    printf("%08x: ", addr);
	}
	if (isstring) {
	    putchar('"');
	    dread(&c, addr, sizeof(char));
	    while (c != '\0') {
		printchar(c);
		++addr;
		dread(&c, addr, sizeof(char));
	    }
	    putchar('"');
	    putchar('\n');
	    n = 0;
	    addr += sizeof(String);
	} else {
	    dread(&value, addr, f->length);
#ifdef mc68000
	    switch (f->length) {
	    case 1:
		printf(f->printfstring, value.charv);
		break;
	    case 2:
		printf(f->printfstring, value.shortv);
		break;
	    case 4:
		if (format[0] == 'f')
			printf(f->printfstring, value.floatv);
		else
			printf(f->printfstring, value.intv);
		break;
	    case 8:
		printf(f->printfstring, value.doublev);
		break;
	    }
#else
	    printf(f->printfstring, value);
#endif mc68000
	}
	++n;
	if (n >= (16 div f->length)) {
	    putchar('\n');
	    n = 0;
	}
    }
    if (n != 0) {
	putchar('\n');
    }
    prtaddr = addr;
    return addr;
}

/*
 * The other approach is to print n items starting with a given address.
 */

public printndata(count, startaddr, format)
int count;
Address startaddr;
String format;
{
    register int i, n;
    register Address addr;
    register Format *f;
    register Boolean isstring;
    char c;
    union {
	char charv;
	short shortv;
	int intv;
	float floatv;
	double doublev;
    } value;

    if (count <= 0) {
	error("non-positive repetition count");
    }
    f = findformat(format);
    isstring = (Boolean) streq(f->name, "s");
    n = 0;
    addr = startaddr;
    value.intv = 0;
    for (i = 0; i < count; i++) {
	if (n == 0) {
	    printf("%08x: ", addr);
	}
	if (isstring) {
	    putchar('"');
	    dread(&c, addr, sizeof(char));
	    while (c != '\0') {
		printchar(c);
		++addr;
		dread(&c, addr, sizeof(char));
	    }
	    putchar('"');
	    putchar('\n');
	    n = 0;
	    addr += sizeof(String);
	} else {
	    dread(&value, addr, f->length);
#ifdef mc68000
	    switch (f->length) {
	    case 1:
		printf(f->printfstring, value.charv);
		break;
	    case 2:
		printf(f->printfstring, value.shortv);
		break;
	    case 4:
		if (format[0] == 'f')
			printf(f->printfstring, value.floatv);
		else
			printf(f->printfstring, value.intv);
		break;
	    case 8:
		printf(f->printfstring, value.doublev);
		break;
	    }
#else
	    printf(f->printfstring, value);
#endif mc68000
	    ++n;
	    if (n >= (16 div f->length)) {
		putchar('\n');
		n = 0;
	    }
	    addr += f->length;
	}
    }
    if (n != 0) {
	putchar('\n');
    }
    prtaddr = addr;
}

/*
 * Print out a value according to the given format.
 */

public printvalue(v, format)
long v;
String format;
{
    Format *f;
    char *p, *q;

    f = findformat(format);
    if (streq(f->name, "s")) {
	putchar('"');
	p = (char *) &v;
	q = p + sizeof(v);
	while (p < q) {
	    printchar(*p);
	    ++p;
	}
	putchar('"');
    } else {
	printf(f->printfstring, v);
    }
    putchar('\n');
}

/*
 * Print out an execution time error.
 * Assumes the source position of the error has been calculated.
 *
 * Have to check if the -r option was specified; if so then
 * the object file information hasn't been read in yet.
 */

public printerror()
{
    extern Integer sys_nsig;
    extern String sys_siglist[];
    Integer err;

    if (isfinished(process)) {
	printf("\"%s\" exits with code %d\n", objname, exitcode(process));
	erecover();
    }
    if (runfirst) {
	fprintf(stderr, "Entering debugger ...");
	init();
	fprintf(stderr, " type 'help' for help\n");
    }
    err = errnum(process);
    if (err == SIGINT) {
	printf("\n\ninterrupt ");
	printloc();
    } else if (err == SIGTRAP) {
	printf("\nerror ");
	printloc();
    } else {
	if (err < 0 or err > sys_nsig) {
	    printf("\nsignal %d ", err);
	} else {
	    printf("\n%s ", sys_siglist[err]);
	}
	printloc();
    }
    putchar('\n');
    if (curline > 0) {
	printlines(curline, curline);
    } else {
	printinst(pc, pc);
    }
    erecover();
}

/*
 * Note the termination of the program.  We do this so as to avoid
 * having the process exit, which would make the values of variables
 * inaccessible.  We do want to flush all output buffers here,
 * otherwise it'll never get done.
 */

public endprogram()
{
    Integer exitcode;

    stepto(nextaddr(pc, true));
    printnews();
    exitcode = argn(1, nil);
    printf("\nexecution completed, exit code is %d\n", exitcode);
    getsrcpos();
    erecover();
}
/*
 * Stop program without continued execution!
 * Arrive here when the return address of the program is unclear
 * due to a stack frame of "_main" not being found.
 *
 * Note the termination of the program.  We do this so as to avoid
 * having the process exit, which would make the values of variables
 * inaccessible.  We do want to flush all output buffers here,
 * otherwise it'll never get done.
 */

public stop_program()
{
    Integer exitcode;

    printnews();
    exitcode = argn(1, nil);
    printf("\nExecution completed, exit code is %d\n", exitcode);
    getsrcpos();
    erecover();
}

/*
 * Single step the machine a source line (or instruction if "inst_tracing"
 * is true).  If "isnext" is true, skip over procedure calls.
 */

private Boolean stepped;  /* static ok, as findnextaddr never calls dostep
			     directly or indirectly */

private Address getcall();

public dostep(isnext)
Boolean isnext;
{
    register Address addr;
    register Lineno line;
    String filename;
    Address startaddr, prevaddr;

    stepped = false;

    startaddr = pc;
    prevaddr = startaddr;

    addr = nextaddr(pc, isnext);

if (traceexec)
{
printf(" dostep() #1 pc = 0x%x  nextaddr = 0x%x\n",pc,addr);
fflush(stdout);
}

    if (not inst_tracing and nlhdr.nlines != 0) {
	line = linelookup(addr);
	while (line == 0) {
	    prevaddr = addr;
	    addr = nextaddr(addr, isnext);
	    line = linelookup(addr);
	}
	curline = line;
    } else {
	curline = 0;
    }
    if (not stepped) {
	if (addr == startaddr) {
	    stepto(prevaddr);
	}
	stepto(addr);
    }
    filename = srcfilename(addr);
    setsource(filename);
}

/*
 * Compute the next address that will be executed from the given one.
 * If "isnext" is true then consider a procedure call as straight line code.
 *
 * We must unfortunately do much of the same work that is necessary
 * to print instructions.  In addition we have to deal with branches.
 * Unconditional branches we just follow, for conditional branches
 * we continue execution to the current location and then single step
 * the machine.  We assume that the last argument in an instruction
 * that branches is the branch address (or relative offset).
 */

Address findnextaddr();

public Address nextaddr(startaddr, isnext)
Address startaddr;
boolean isnext;
{
    Address addr;

    addr = usignal(process);
    if (addr == 0 or addr == 1) {
	addr = findnextaddr(startaddr, isnext);
    }
    return addr;
}


Address findnextaddr(startaddr, isnext)
Address startaddr;
Boolean isnext;
{
    static Address default_return;
    register Address addr;
    Address destaddr;
    register Boolean linkdone;
    Opcode ins[6];

    addr = disasm(false, startaddr, &destaddr);

    iread(ins, startaddr, sizeof(ins));

    if (isjsr(ins[0]) || isbsr(ins[0])) {
    	if (isnext)
		return addr;
    	else {

/* In cases where parameters are stuffed onto the stack (before for a
   branch)  The trace logic is dependent on the frame to be set immediatly
   upon entry to the subroutine.
   If the Link instruction is performed immediately the return address
   of the subroutine is sometimes not found by looking for the
   previous stack frame value. When this occurs the return_addr() 
   function returns a null which is then used as the next breakpoint
   to "step" to. When this occurs the program continues execution 
   without hitting any more breakpoints until it has completed.

   Because of this inherent and reoccuring problem, a "backup" return
   address is saved upon subroutine entry, to provide the trace logic
   with some place to go in case it fails to read to correct frame addr.

   Note! The "default" return address is only useful within non traceable
	 routines (during tracing) because it is overwritten after every
	 subsequent traceable branch instruction.
*/
	   stepto(startaddr);
	   pstep(process,DEFSIG);
	   addr = reg(PROGCTR);

	   default_return = startaddr + sizeof(Opcode);
           if (isbsr(ins[0])) 
  	      {
	      default_return = startaddr + sizeof(Opcode);
	      default_return +=((ins[0] & 0xff) ? 0 : sizeof(short));
				/* check for 8/16  bit displacement */
	      }	
	   else
	     default_return += sizeof(Address);

	   if (traceexec) {
		printf("findnextaddr() #1 pc = 0x%x default=0x%x \n",
	 	      addr,default_return); 
		fflush(stdout);
	   }

	   stepped = true;
	   linkdone = false;

	   do {
		iread(ins, addr, sizeof(Opcode));
		if (islink(ins[0])) {
		    linkdone = true;
		    pstep(process,DEFSIG);
		    addr = reg(PROGCTR);
		    iread(ins, addr, sizeof(Opcode));
#ifdef GHS
		    if (ismoveml(ins[0]))
#else
		    if (ismovl(ins[0]) || ismoveml(ins[0]))
#endif GHS
		    {
			pstep(process,DEFSIG);	/* step past any move */
			addr = reg(PROGCTR);
			iread(ins, addr, sizeof(Opcode));
		    }
		    if (isbra(ins[0])) {

			pstep(process,DEFSIG);	/* step past any branch */
			addr = reg(PROGCTR);
		    }
		}
		else {
		    pstep(process,DEFSIG);
		    addr = reg(PROGCTR);
		}
		if (nosource(whatblock(addr))) {
		    linkdone = true;
		}
	    } while (not linkdone);
	    pc = addr;
	    setcurfunc(whatblock(pc));
	    if (not isbperr()) {
	  	printstatus();
	   	/* NOTREACHED */
	    }
	    bpact();
	    if (nosource(curfunc) and canskip(curfunc) and
		    nlhdr.nlines != 0) {
#ifndef	OLD
		addr = default_return;
#else	OLD
	    	addr = return_addr();
#endif	OLD

		if (traceexec) { 
		   printf("findnextaddr()#2 addr=0x%x default_addr= 0x%x\n",addr			,default_return);
		   fflush(stdout);
		   }

#ifndef	OLD
		if (addr == nil)
		   addr = default_return;
#endif	OLD
	    	stepto(addr);
	    	pc = addr;
		dostep(true);	/* we need to step to next line stab */
	    	bpact(); 
	    } else {
	    	callnews(/* iscall = */ true);
	    }
    	}
    }
    else if (isjmp(ins[0]) || isbra(ins[0])) {
	if (destaddr != -1) {
	    return destaddr;
	}
        goto dobcc;
    }
    else if (isrtr(ins[0]) || isrts(ins[0])) {
	if (traceexec)
		{ printf("findnextaddr isrts()\n");
		  fflush(stdout);}
        callnews(/* iscall = */ false);


        addr = return_addr();
	if (addr == pc) {	/* recursive ret to self */
		pstep(process, DEFSIG);
	} else {

/* Arrive here when pc is set to 0 by "falling out" of main (i.e. no exit())

   The stack frame for the routine calling "_main" has the fp (a6) set to 0;
   When the stack frame for the routine calling "_main" is returned from
   the "nextframe" routine, it is considered to be an error and so an error
   result (value 0) is returned as the return address of "_main" which is
   then used as the next address to break/continue exectuion to...
 
   To avoid execution from address 0, the program execution is stopped here.
   Note! This condition only occurs when tracing in DBX.
*/

		if (traceexec) {
	   	   printf("findnextaddr() #3 addr=0x%x  pc=0x%x default=0x%x\n",			 addr,pc,default_return); 
		   fflush(stdout); 
		   }

		if (addr == nil)
	           stop_program(); /* end program without continued execution */
		/* NOT REACHED if addr=nil */

		stepto(addr);
		if (traceexec) {
	   	   printf("FINDNEXTADDR() STEPTO:\n"); 
		   fflush(stdout); 
		   }
		stepped = true; 
			/* note bpact() is not call after this stepto() call,
			   because it is later called in the cont() routine.
			   bpact() should never be called twice during the
			   same "step", otherwise break point management gets
			   out of sync.
			*/
		pc = addr;
		return addr;
	}
	pc = addr;
        bpact();
    }
    else if (isbcc(ins[0]) || isdbcc(ins[0])) {
dobcc:	stepto(startaddr);
	stepped = true;
        pstep(process,DEFSIG);
        addr = reg(PROGCTR);
        pc = addr;
        if (not isbperr()) {
	    printstatus();
        }
    }
    return addr;
}

#ifdef vax
/*
 * Get the displacement of an instruction that uses displacement addressing.
 */

private int getdisp(addr, nbytes, reg, mode)
Address addr;
int nbytes;
String reg;
int mode;
{
    char byte;
    short hword;
    int argval;

    switch (nbytes) {
	case 1:
	    iread(&byte, addr, sizeof(byte));
	    argval = byte;
	    break;

	case 2:
	    iread(&hword, addr, sizeof(hword));
	    argval = hword;
	    break;

	case 4:
	    iread(&argval, addr, sizeof(argval));
	    break;
    }
    if (reg == regname[PROGCTR] && mode >= BYTEDISP) {
	argval += addr + nbytes;
    }
    return argval;
}
#endif vax

#ifdef vax
#define BP_OP       BPT         /* breakpoint trap */
#else
#define BP_OP       OP_BPT      /* breakpoint trap */
#endif vax
#define BP_ERRNO    SIGTRAP     /* signal received at a breakpoint */

/*
 * Setting a breakpoint at a location consists of saving
 * the word at the location and poking a BP_OP there.
 *
 * We save the locations and words on a list for use in unsetting.
 */

typedef struct Savelist *Savelist;

struct Savelist {
    Address location;
#ifdef vax
    Byte save;
#else
    u_short save;
#endif vax
    Byte refcount;
    Savelist link;
};

private Savelist savelist;

/*
 * Set a breakpoint at the given address.  Only save the word there
 * if it's not already a breakpoint.
 */

public setbp(addr)
Address addr;
{
#ifdef vax
    Byte w;
    Byte save;
#else
    u_short w;
    u_short save;
#endif vax

    register Savelist newsave, s;

    if (tracebpts && (0)) {
	printf("at setbp, addr is %x\n",addr);
	fflush(stdout);
    }
    for (s = savelist; s != nil; s = s->link) {
	if (s->location == addr) {
	    s->refcount++;
	    return;
	}
    }
    iread(&save, addr, sizeof(save));
    newsave = new(Savelist);
    newsave->location = addr;
    newsave->save = save;
    newsave->refcount = 1;
    newsave->link = savelist;
    savelist = newsave;
    if (pc == addr) {
	return;
    }
    w = BP_OP;
    iwrite(&w, addr, sizeof(w));
}

/*
 * Unset a breakpoint; unfortunately we have to search the SAVELIST
 * to find the saved value.  The assumption is that the SAVELIST will
 * usually be quite small.
 */

public unsetbp(addr)
Address addr;
{
    register Savelist s, prev;

    prev = nil;
    for (s = savelist; s != nil; s = s->link) {
	if (s->location == addr) {
    	    if (tracebpts && (0))
	    	printf("at unsetbp, found addr %x\n",addr); fflush(stdout);
	    iwrite(&s->save, addr, sizeof(s->save));
	    s->refcount--;
	    if (s->refcount == 0) {
		if (prev == nil) {
		    savelist = s->link;
		} else {
		    prev->link = s->link;
		}
		dispose(s);
	    }
	    return;
	}
	prev = s;
    }
    panic("unsetbp: couldn't find address %d", addr);
}

/*
 * Predicate to test if the reason the process stopped was because
 * of a breakpoint.
 */

public Boolean isbperr()
{
    return (Boolean) (not isfinished(process) and errnum(process) == SIGTRAP);
}

/*
 * Enter a procedure by creating and executing a call instruction.
 */

public beginproc(p, argc)
Symbol p;
Integer argc;
{
#ifdef mc68000
    struct {
	Opcode op;
	long dest;
    } call, save;
    Address call_pc;

    call_pc = 0;
    iread(&save, call_pc, sizeof(save));
    call.op = OP_JSR | 071;		/* jsr absolute long */
    call.dest = codeloc(p);
    iwrite(&call, call_pc, sizeof(call));
    setreg(PROGCTR, call_pc);
#ifdef tws
    stepto(call.dest+4);	/* jsr and execute frame setup code */
#else
    pstep(process, DEFSIG);
#endif tws
    iwrite(&save, call_pc, sizeof(save));

#else (vax)
#define CALLSIZE 7	/* size of call instruction */

    char save[CALLSIZE];
    struct {
	Opcode op;
	unsigned char numargs;
	unsigned char mode;
	char addr[sizeof(long)];	/* unaligned long */
    } call;
    long dest;

    pc = 2;
    iread(save, pc, sizeof(save));
    call.op = O_CALLS;
    call.numargs = argc;
    call.mode = 0xef;
    dest = codeloc(p) - 2 - (pc + 7);
    mov(&dest, call.addr, sizeof(call.addr));
    iwrite(&call, pc, sizeof(call));
    setreg(PROGCTR, pc);
    pstep(process,DEFSIG);
    iwrite(save, pc, sizeof(save));
#endif mc68000
    pc = reg(PROGCTR);
    if (not isbperr()) {
	printstatus();
    }
}
