#include "errno.h"
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"

#define	BOOKKEEPING	1

extern struct packet *FindRep();
extern struct sendpk *FindNewReq(), *FindReq(), *GetReq();
extern struct packet *GetPacketMem();

#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	PKOFF(p,fp)	((char *)((p) + 1) - (char *)(fp))
#define	CMP_SEQID(i,j)	((short)((int)(i) - (int)(j)))
#define	RMBURST(m)	(((m) & (XS_READ|XS_RMASK)) == (XS_READ|XS_RMBURST))

struct cpst {
	unsigned long	copybits;
	unsigned long	rcvdbits;
	unsigned short	copyseqid;
};

unsigned short seqno;
int urgent_tics = (60 / 50) + 1, standby_tics = 60 * 4;
char *RpidToName();

/*
 * Returns pid of replying process, else 0.
 */
unsigned long
xSend(mp, rpid)
register struct wmsg *mp;
register unsigned long rpid;
{
	register struct packet *wp;
	register unsigned long len0, len1, n;
	register int retry;
	register struct cpst cpst, *cp = &cpst;
	int err, repq_was_enabled = EnableRepQueue();
	struct fragment *fp0;
	struct fragment *fp1;
	unsigned char urgent;
	struct sendpk pk;
	unsigned long prereadlen();
	unsigned long gotreply();
	char *mname;
	char foo = '\0', *foop;

	pk.h.retry = 0;
  tryagain:
	fp0 = (struct fragment *)0;
	fp1 = (struct fragment *)0;
	cp->copyseqid = 0;
	cp->copybits = cp->rcvdbits = 0;
	len0 = len1 = 0;
	urgent = PID(rpid) == INTERRUPT_PID;
/* KLUDGE: if we are doing ip encapulation, nothing is urgent! */
	if (urgent && Iface_wipc_ip(rpid))
{
/*printf("Z"); /**/
		urgent = 0;
}
	if (mp->h.xs0 & XS_READ)
		len0 = prereadlen(&mp->seg0, mp->h.xs0);
	if (mp->h.xs1 & XS_READ)
		len1 = prereadlen(&mp->seg1, mp->h.xs1);
	if (len0 + len1 > BIG_PACKET_LEN - SEND_SZ - 8  &&
	    len0 + len1 > (n = (unsigned long)MaxPktLen(rpid) - SEND_SZ - 8)) {
		if (len0 > n)
			len0 = n;
		n -= len0;
		if (len1 > n)
			len1 = n;
	}

	pk.h.type = T_SEND;
	pk.h.version = VERSION;
	pk.h.errcode = 0;
	pk.h.sendseqid = ++seqno;
	pk.h.src = my_rpid(rpid);
	pk.h.dst = rpid;
	bcopy(mp, &pk.msg, sizeof pk.msg); /* pk.msg = *mp;	/* str asg */
	bcopy(mp, &pk.ctl, sizeof pk.ctl);
				/* pk.ctl = *(struct wctl *)mp;	/* str asg */
	if (len0) {
		pk.frag0.srcaddr = mp->seg0.addr;
		pk.frag0.srcxs = mp->h.xs0;
		pk.frag0.off = PKOFF(&pk, &pk.frag0);
		pk.frag0.len = len0;
		pk.frag0.dstaddr = (char *)0;
		pk.frag0.dstxs = pk.frag0.flags = pk.frag0.fragid = 0;
		fp0 = &pk.frag0;
	} else
		bzero(&pk.frag0, sizeof pk.frag0);
	if (len1) {
		pk.frag1.srcaddr = mp->seg1.addr;
		pk.frag1.srcxs = mp->h.xs1;
		pk.frag1.off = PKOFF(&pk, &pk.frag1) + len0 + ((len0 + 3) & ~3);
		pk.frag1.len = len1;
		pk.frag1.dstaddr = (char *)0;
		pk.frag1.dstxs = pk.frag1.flags = pk.frag1.fragid = 0;
		fp1 = &pk.frag1;
	} else
		bzero(&pk.frag1, sizeof pk.frag1);
	pk.cfos_addr = (char *)0;
	pk.cfos_xs = 0;
	if (pk.h.retry == 0) {
		if (RMBURST(mp->h.xs0)  &&  (n = mp->seg0.len - len0)) {
			pk.cfos_addr = mp->seg0.addr + len0;
			pk.cfos_xs = mp->h.xs0;
		} else if (RMBURST(mp->h.xs1)  &&  (n = mp->seg1.len - len1)) {
			pk.cfos_addr = mp->seg1.addr + len1;
			pk.cfos_xs = mp->h.xs1;
		}
	}
	for (retry = 0;  retry < MAX_RETRY;  retry++) {
		pk.h.copyseqid = cp->copyseqid;
		switch (err = SendPacket(&pk, sizeof pk, fp0, fp1)) {
		  /*
		   * These are the error conditions for which
		   * we do not bother to retry.
		   */
		  case ENXIO:	/* could indicate remote machine disconnected */
			mp->h.rcode = err;
			if (!repq_was_enabled)
				DisableRepQueue();
			return 0;
		}
		if (pk.cfos_xs) {
			sendburst(rpid, T_COPY_FROM_REP, pk.h.sendseqid, 0,
					pk.cfos_addr, (char *)0, n,
					pk.cfos_xs, XS_NOSEG, (struct wmsg *)0);
			pk.cfos_addr = (char *)0;
			pk.cfos_xs = 0;
		}
		if (mp->h.rflags & RF_NOREP) {
			if (!repq_was_enabled)
				DisableRepQueue();
			return rpid;
		}
		for (n = 0;
		     wp = FindRep(pk.h.sendseqid,
			     (urgent ? urgent_tics : (retry_tics(retry) + n)));
		     ReleaseRep(wp)) {
			n = 0;
			switch (wp->type) {
			  case T_REPLY:
				if (wp->retry < pk.h.retry)
					break;	/* ignore if not up to date */
				if (gotreply((struct sendpk *)wp, mp, cp)) {
					n = wp->src;
					ReleaseRep(wp);
					if (!repq_was_enabled)
						DisableRepQueue();
					return n;
				}
				ReleaseRep(wp);
				pk.h.retry += 1;
				goto tryagain;
			  case T_COPY_TO_REQ:
				if (gotcptoreq((struct datapk *)wp, cp))
					break;
				continue;
			  case T_COPY_FROM_REQ:
				if (gotcpfmreq((struct cpfmreqpk *)wp, cp))
					break;
				continue;
			  case T_NACK:
				if (wp->errcode == EALREADY) {
					n = standby_tics;
					break;
				}
				mp->h.rcode = wp->errcode;
				ReleaseRep(wp);
				if (mp->h.rcode == ENETRESET) {	/* down & up */
				    if ((foop = RpidToName(rpid)) == (char *)0)
						foop = &foo;
				    printf("TRFS: reconnecting to '%s'\n",foop);
				    MinfoDetach((char *)0, MID(rpid));
				}
				if (!repq_was_enabled)
					DisableRepQueue();
				return 0;
			  default:
				continue;
			}
			retry = 0;
		}
		pk.h.retry += 1;
	}
	if (!repq_was_enabled)
		DisableRepQueue();
	return 0;
}

unsigned long
gotreply(wp, mp, cp)
register struct sendpk *wp;
struct wmsg *mp;
register struct cpst *cp;
{
	if (wp->frag0.len) {
		if (wp->frag0.fragid) {
			if (wp->h.copyseqid != cp->copyseqid  ||
			    (1 << wp->frag0.fragid) - 1 != cp->rcvdbits)
				return 0;	/* current copyto incomplete */
		} else if (cp->copybits != cp->rcvdbits)
			return 0;		/* previous copyto incomplete */
		fcopyout(&wp->frag0);
	}
	bcopy(&wp->msg, mp, sizeof wp->msg); /* *mp = wp->msg;	/* str asg */
	return 1;
}

gotcptoreq(wp, cp)
register struct datapk *wp;
register struct cpst *cp;
{
	register unsigned long idbit;
	register struct fragment *fp = (struct fragment *)0;
	register struct cptoreppk *q;

	if (CMP_SEQID(wp->h.copyseqid, cp->copyseqid) > 0) {
		cp->copyseqid = wp->h.copyseqid;/* new request -- set up */
		cp->rcvdbits = 0;
		cp->copybits = wp->copybits;
	} else if (CMP_SEQID(wp->h.copyseqid, cp->copyseqid) < 0)
		return 0;			/* old request -- ignore */
	if (wp->frag.len) {
		idbit = 1 << wp->frag.fragid;
		if ((cp->rcvdbits & idbit) == 0) {
			fp = &wp->frag;
			cp->rcvdbits |= idbit;
		}
	}
	if ((cp->rcvdbits & wp->copybits) == wp->copybits) {
		q = (struct cptoreppk *)GetPacketMem();
		q->h.type = T_COPY_TO_REP;
		q->h.version = VERSION;
		q->h.retry = 0;
		q->h.errcode = 0;
		q->h.sendseqid = wp->h.sendseqid;
		q->h.copyseqid = wp->h.copyseqid;
		q->h.src = wp->h.dst;
		q->h.dst = wp->h.src;
		q->rcvdbits = cp->rcvdbits;
		SendPacket(q, sizeof *q, 0, 0);
		FreePacketMem(q);
	}
	if (fp)
		fcopyout(fp);
	return 1;
}

gotcpfmreq(wp, cp)
register struct cpfmreqpk *wp;
register struct cpst *cp;
{
	if (CMP_SEQID(wp->h.copyseqid, cp->copyseqid) > 0) {
		cp->copyseqid = wp->h.copyseqid;
		cp->copybits = cp->rcvdbits = 0;
	}
	sendburst(wp->h.src, T_COPY_FROM_REP, wp->h.sendseqid, wp->h.copyseqid,
		wp->srcaddr, wp->dstaddr, wp->len, wp->srcxs, wp->dstxs,
		(struct wmsg *)0);
	return 1;
}

sendburst(rpid, type, sendseqid, copyseqid,
	srcaddr, dstaddr, len, srcxs, dstxs, mp)
register unsigned long rpid;
unsigned char type;
unsigned short sendseqid, copyseqid;
register char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char srcxs, dstxs;
register struct wmsg *mp;
{
	register unsigned long maxfraglen, n, copybits;
	unsigned short fragid = 0;
	register struct datapk *q;

	if (len > (maxfraglen = BIG_PACKET_LEN - sizeof(struct datapk)))
		maxfraglen = MaxPktLen(rpid) - sizeof(struct datapk);
	n = len / maxfraglen;
	if (n * maxfraglen < len)
		n += 1;
	if (n > 1  &&  n > (copybits = MaxPktBurst(rpid))) {
		n = copybits;
		len = n * maxfraglen;
		mp = (struct wmsg *)0;
	}
	copybits = 0;
	if (n) {
		copybits = 1;
		while (--n) {
			copybits <<= 1;
			copybits += 1;
		}
	}
	q = (struct datapk *)GetPacketMem();
	q->h.type = type;
	q->h.version = VERSION;
	q->h.retry = 0;
	q->h.errcode = 0;
	q->h.sendseqid = sendseqid;
	q->h.copyseqid = copyseqid;
	q->h.src = my_rpid(rpid);
	q->h.dst = rpid;
	q->maxfraglen = maxfraglen;
	q->copybits = copybits;
	q->frag.srcxs = srcxs;
	q->frag.dstxs = dstxs;
	q->frag.off = PKOFF(q, &q->frag);
	q->frag.flags = 0;
	do {
		if ((n = len) > maxfraglen)
			n = maxfraglen;
		else if (mp  &&  replywithsegment(mp, rpid, srcaddr, dstaddr,
						n, srcxs, dstxs, fragid) == 0) {
			FreePacketMem(q);
			return 0;
		}
		q->frag.srcaddr = srcaddr;
		q->frag.dstaddr = dstaddr;
		q->frag.len = n;
		q->frag.fragid = fragid++;
		SendPacket(q, sizeof *q, &q->frag, 0);
		srcaddr += n;
		dstaddr += n;
	} while (len -= n);
	FreePacketMem(q);
	return maxfraglen;	/* return amount of data per packet */
}

unsigned long
prereadlen(segp, xs)
register struct wmsg_seg *segp;
unsigned char xs;
{
	register unsigned long len;

	if (xs & XS_READ) {
		switch (xs & XS_RMASK) {
		  case XS_RMZSTR:
			if ((xs & XS_SEGMASK) == XS_KERN) {
				if ((len = strlen(segp->addr) + 1) > segp->len)
					len = segp->len;
				return len;
			}
			/* fall thru */
		  case XS_RMPACKET:
		  case XS_RMBURST:
			return segp->len;
		}
	}
	return 0;
}

/*
 * Returns pid of sending process, else 0.
 */
unsigned long
xReceive(mp, rpid)
struct wmsg *mp;
unsigned long rpid;
{
	register struct sendpk *p;

    again:
	p = FindNewReq(rpid);
	if ((mp->h.rflags & p->msg.h.rflags & RF_NONIDEM)  &&
	    (mp->h.rflags & RF_NOREP) == 0  &&
	    CheckRepRetry(p->h.src, p->h.sendseqid)) {
		xReply(mp, p->h.src);
		goto again;
	}
	SetRepRetry(0, 0xFFFF);

	bcopy(&p->msg, mp, sizeof p->msg); /* *mp = p->msg;	/* str asg */
	if (mp->h.rflags & RF_NOREP) {
		if (GetReq(rpid = p->h.src) != p)
			panic("Receive");
		ReleasePacket(p);
		return rpid;
	}
	p->rocp_xs = 0;
	p->rocp_addr = (char *)0;
	p->flags = 0;
	return p->h.src;
}

/*
 * Returns 0, else error code.
 */
replywithsegment(mp, rpid, srcaddr, dstaddr, len, srcxs, dstxs, fragid)
struct wmsg *mp;
unsigned long rpid;
char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char srcxs, dstxs;
{
	register struct sendpk *wp;
	struct sendpk pk;

	if (len > BIG_PACKET_LEN - SEND_SZ)
		if (len > (unsigned long)MaxPktLen(rpid) - SEND_SZ)
			return E2BIG;
	SetRepRetry(0, 0xFFFF);
	if ((wp = FindReq(rpid)) == (struct sendpk *)0)
		return ESRCH;
	if (mp->h.rflags & RF_NONIDEM) {
		if (len)
			return E2BIG;
		SetRepRetry(rpid, wp->h.sendseqid);
	}
	wp->rocp_xs = 0;
	pk.h.type = T_REPLY;
	pk.h.version = VERSION;
	pk.h.errcode = 0;
	pk.h.sendseqid = wp->h.sendseqid;
	pk.h.copyseqid = wp->h.copyseqid;
	pk.h.src = my_rpid(rpid);
	pk.h.dst = rpid;
	bcopy(mp, &pk.msg, sizeof pk.msg); /* pk.msg = *mp;	/* str asg */
	if (len) {
		pk.frag0.srcaddr = srcaddr;
		pk.frag0.off = PKOFF(&pk, &pk.frag0);
		pk.frag0.len = len;
		pk.frag0.srcxs = srcxs;
		pk.frag0.dstaddr = dstaddr;
		pk.frag0.dstxs = dstxs;
		pk.frag0.flags = 0;
		pk.frag0.fragid = fragid;
		pk.h.retry = wp->h.retry;	/* wait till last instant */
		SendPacket(&pk, sizeof pk, &pk.frag0, 0);
	} else {
		bzero(&pk.frag0, sizeof pk.frag0);
		pk.h.retry = wp->h.retry;	/* wait till last instant */
		SendPacket(&pk, sizeof pk, 0, 0);
	}
	if (GetReq(rpid) != wp)		/* remove original request from recq */
		panic("replywseg");
	if (((wp->flags |= SF_REPLIED) & SF_HOLD) == 0) {
		FlushRepQueue(rpid, wp->h.sendseqid);
		ReleasePacket(wp);
	}
	return 0;
}

xReply(mp, rpid)
struct wmsg *mp;
unsigned long rpid;
{
	struct sendpk *wp;

	if (mp == (struct wmsg *)0) {
		if (wp = GetReq(rpid))
			ReleasePacket(wp);
		else
			return ESRCH;
		return 0;
	}
	return replywithsegment(mp, rpid, (char *)0, (char *)0, 0, 0, 0, 0);
}

xReplyOnCopy(mp, rpid, addr, xs)
struct wmsg *mp;
unsigned long rpid;
char *addr;
unsigned char xs;
{
	register struct sendpk *p;

	xs &= (XS_SEGMASK | XS_READ | XS_WRITE);
	if (mp->h.rflags & RF_NONIDEM)
		xs &= ~XS_WRITE;	/* disallow ReplyOnCopyTo */
	if ((p = FindReq(rpid)) == (struct sendpk *)0)
		return ESRCH;
	bcopy(mp, &p->msg, sizeof p->msg); /* p->msg = *mp;	/* str asg */
	p->rocp_addr = addr;
	p->rocp_xs = xs;
	return 0;
}

xForward(rpid, newrpid)
unsigned long rpid;
unsigned long newrpid;
{
	register struct sendpk *p;
	int err;

	if ((p = GetReq(rpid)) == (struct sendpk *)0)
		return ESRCH;
	if (err = ForwardPacket((struct packet *)p, newrpid)) {
		ReleasePacket(p);		/* whoops!  dropped it. */
		return err;
	}
	return 0;
}

/*
 * Returns 0, else error code.
 */
xCopyTo(rpid, srcaddr, dstaddr, len, srcxs, dstxs)
unsigned long rpid;
char *srcaddr;
register char *dstaddr;
unsigned long len;
unsigned char srcxs, dstxs;
{
	register struct sendpk *p;
	register struct wmsg *mp = (struct wmsg *)0;
	int rslt;

	if ((p = FindReq(rpid)) == (struct sendpk *)0)
		return ESRCH;
	p->flags |= SF_HOLD;
	if ((p->rocp_xs & XS_WRITE)  &&
	    (dstxs & XS_SEGMASK) == (p->rocp_xs & XS_SEGMASK)  &&
#ifdef	SYSV
	    OptimizeCopy() &&
#endif	SYSV
	    dstaddr <= p->rocp_addr  &&  p->rocp_addr < dstaddr + len)
		mp = &p->msg;
	rslt = docopyto(rpid, p, srcaddr, dstaddr, len, srcxs, dstxs, mp);
	if ((p->flags &= ~SF_HOLD) & SF_REPLIED) {
		FlushRepQueue(rpid, p->h.sendseqid);
		ReleasePacket(p);
	}
	return rslt;
}

docopyto(rpid, p, srcaddr, dstaddr, len, srcxs, dstxs, mp)
unsigned long rpid;
register struct sendpk *p;
register char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char srcxs, dstxs;
struct wmsg *mp;
{
	register struct cptoreppk *wp;
	register unsigned long bits, n, maxlen;
	unsigned short copyseqid;
	register int retry;
	int err;

	while (len) {
		copyseqid = ++p->h.copyseqid;
		for (retry = 0;  retry < MAX_RETRY - 2;  retry++) {
			if ((maxlen = sendburst(rpid, T_COPY_TO_REQ,
					p->h.sendseqid, copyseqid,
					srcaddr, dstaddr,
					(retry ? MIN(maxlen,len) : len),
					srcxs, dstxs, mp)) == 0)
				return 0;
			for (; wp = (struct cptoreppk *)FindRep(p->h.sendseqid,
							retry_tics(retry));
			     ReleaseRep(wp)) {
				if (wp->h.copyseqid != copyseqid)
					continue;
				if (wp->h.type == T_NACK) {
					if (wp->h.errcode == EALREADY) {
						retry = 0;
						continue;
					}
					err = wp->h.errcode;
					ReleaseRep(wp);
					return err;
				}
				if (wp->h.type != T_COPY_TO_REP)
					continue;
				retry = 0;
				bits = wp->rcvdbits;
				ReleaseRep(wp);
				goto more;
			}
			mp = (struct wmsg *)0;
		}
		return EIO;
    more:
		while (bits) {
			n = maxlen;
			if (bits & 1) {
				bits >>= 1;
			} else {
				while (((bits >>= 1) & 1) == 0)
					n += maxlen;
				if (err = docopyto(rpid, p, srcaddr, dstaddr,
						   MIN(n, len), srcxs, dstxs,
						   (mp = (struct wmsg *)0)))
					return err;
			}
			if (n >= len)
				return 0;
			len -= n;
			srcaddr += n;
			dstaddr += n;
		}
	}
	return 0;
}

/*
 * Returns 0, else error code.
 */
xCopyFrom(rpid, srcaddr, dstaddr, len, srcxs, dstxs)
unsigned long rpid;
register char *srcaddr, *dstaddr;
register unsigned long len;
unsigned char srcxs, dstxs;
{
	register struct sendpk *p;
	register unsigned long n = 0;
	unsigned long cpfmpreread();
	int rslt = 0;

	if ((p = FindReq(rpid)) == (struct sendpk *)0)
		return ESRCH;
	p->flags |= SF_HOLD;
	if (len) {
		if (p->frag0.len)
			n = cpfmpreread(p, &p->frag0, srcaddr, dstaddr,
							len, srcxs, dstxs);
		if (n == 0  &&  p->frag1.len)
			n = cpfmpreread(p, &p->frag1, srcaddr, dstaddr,
							len, srcxs, dstxs);
		len -= n;
	}
	if (len)
		rslt = docopyfrom(rpid, p, srcaddr + n, dstaddr + n, len,
								srcxs, dstxs);
	if ((p->flags &= ~SF_HOLD) & SF_REPLIED) {
		FlushRepQueue(rpid, p->h.sendseqid);
		ReleasePacket(p);
	}
	return rslt;
}

unsigned long
cpfmpreread(p, fp, srcaddr, dstaddr, len, srcxs, dstxs)
register struct sendpk *p;
register struct fragment *fp;
register char *srcaddr;
char *dstaddr;
register unsigned long len;
unsigned char srcxs, dstxs;
{
	register unsigned long off;

	if ((fp->srcxs & XS_SEGMASK) != (srcxs & XS_SEGMASK)  ||
	    (off = srcaddr - fp->srcaddr) >= fp->len)
		return 0;
	if (len > fp->len - off)
		len = fp->len - off;
	if ((p->rocp_xs & XS_READ)  &&
#ifdef	SYSV
	    OptimizeCopy() &&
#endif	SYSV
	    (srcxs & XS_SEGMASK) == (p->rocp_xs & XS_SEGMASK)  &&
	    srcaddr <= p->rocp_addr  &&  p->rocp_addr < srcaddr + len)
		xReply(&p->msg, p->h.src);
	xcopyout((char *)fp + fp->off + off, dstaddr, len, dstxs);
	off += len;
	fp->srcaddr += off;
	fp->off += off;
	fp->len -= off;
	return len;
}

docopyfrom(rpid, p, srcaddr, dstaddr, len, srcxs, dstxs)
unsigned long rpid;
register struct sendpk *p;
char *srcaddr, *dstaddr;
register unsigned int len;
unsigned char srcxs, dstxs;
{
	register struct datapk *wp;
	register unsigned long bits, n, maxlen;
	unsigned short sendseqid, copyseqid;
	register int retry;
	register struct cpfmreqpk *q = (struct cpfmreqpk *)GetPacketMem();
	int repok, err;

	q->h.type = T_COPY_FROM_REQ;
	q->h.version = VERSION;
	q->h.errcode = 0;
	q->h.sendseqid = sendseqid = p->h.sendseqid;
	q->h.src = my_rpid(rpid);
	q->h.dst = rpid;
	q->srcxs = srcxs;
	q->dstxs = dstxs;
	while (len) {
		q->h.retry = 0;
		q->srcaddr = srcaddr;
		q->dstaddr = dstaddr;
		q->len = len;
		repok = (p->rocp_xs & XS_READ)  &&
#ifdef	SYSV
		    OptimizeCopy() &&
#endif	SYSV
		    (srcxs & XS_SEGMASK) == (p->rocp_xs & XS_SEGMASK)  &&
		    srcaddr <= p->rocp_addr  &&  p->rocp_addr < srcaddr + len;
		for (retry = 0;  retry < MAX_RETRY - 2;  retry++) {
			if (p->cfos_xs  &&  p->cfos_addr == srcaddr  &&
			    (p->cfos_xs & XS_SEGMASK) == (srcxs & XS_SEGMASK))
				copyseqid = 0;
			else {
				if (q->h.retry == 0)
					q->h.copyseqid = ++p->h.copyseqid;
				SendPacket(q, sizeof *q, 0, 0);
				q->h.retry += 1;
				copyseqid = q->h.copyseqid;
			}
			p->cfos_xs = 0;
			for (bits = maxlen = 0;
			     wp = (struct datapk *)FindRep(sendseqid,
						     retry_tics(retry));
			     ReleaseRep(wp)) {
				if (wp->h.copyseqid != copyseqid)
					continue;
				if (wp->h.type == T_NACK) {
					if (wp->h.errcode == EALREADY) {
						retry = 0;
						continue;
					}
					err = wp->h.errcode;
					ReleaseRep(wp);
					FreePacketMem(q);
					return err;
				}
				if (wp->h.type != T_COPY_FROM_REP)
					continue;
				retry = 0;
				if (wp->frag.len  &&
				    (bits & (n = 1 << wp->frag.fragid)) == 0) {
					bits |= n;
					maxlen = wp->maxfraglen;
					if (repok)
						repok = repck(p, wp, bits);
					fxcopyout(&wp->frag, srcaddr, dstaddr,
							len, srcxs, dstxs);
				}
				if (bits == wp->copybits) {
					ReleaseRep(wp);
					goto more;
				}
			}
			if (bits)
				goto more;
		}
		FreePacketMem(q);
		return EIO;
    more:
		while (bits) {
			n = maxlen;
			if (bits & 1) {
				bits >>= 1;
			} else {
				repok = 0;
				p->rocp_xs = 0;
				while (((bits >>= 1) & 1) == 0)
					n += maxlen;
				if (err = docopyfrom(rpid, p, srcaddr, dstaddr,
					     MIN(n, len), srcxs, dstxs)) {
					FreePacketMem(q);
					return err;
				}
			}
			if (n >= len) {
				FreePacketMem(q);
				return 0;
			}
			len -= n;
			srcaddr += n;
			dstaddr += n;
		}
	}
	FreePacketMem(q);
	return 0;
}

fxcopyout(fp, srcaddr, dstaddr, len, srcxs, dstxs)
register struct fragment *fp;
char *srcaddr;
register char *dstaddr;
register unsigned long len;		/* expected length of burst */
unsigned char srcxs, dstxs;
{
	if ((fp->dstxs & XS_SEGMASK) == XS_NOSEG) {
		if ((unsigned long)fp->dstaddr + fp->len > len) {
			if ((unsigned long)fp->dstaddr >= len)
				return;
			fp->len = len - (unsigned long)fp->dstaddr;
		}
		fp->dstaddr += (unsigned long)dstaddr;
		fp->dstxs = dstxs;
	}
	fcopyout(fp);
}

#ifdef	BOOKKEEPING
unsigned long rocp[32];
#endif	BOOKKEEPING

repck(p, wp, bits)
register struct sendpk *p;
register struct datapk *wp;
unsigned long bits;
{
	register unsigned long len, maxlen, copybits;
	register char *srcaddr;
	unsigned long dataqck();

	if ((p->rocp_xs & XS_READ) == 0  ||
	    (wp->frag.srcxs & XS_SEGMASK) != (p->rocp_xs & XS_SEGMASK))
		return 0;
	maxlen = wp->maxfraglen;
	srcaddr = wp->frag.srcaddr - (maxlen * wp->frag.fragid);
	copybits = wp->copybits;
	len = maxlen;
	while (copybits >>= 1)
		len += maxlen;
	if (p->rocp_addr < srcaddr  ||  srcaddr + len <= p->rocp_addr)
		return 1;		/* maybe next burst */
	copybits = wp->copybits;
	if (bits != copybits  &&  (bits | dataqck(wp)) != copybits)
		return 1;
	xReply(&p->msg, p->h.src);
#ifdef	BOOKKEEPING
	rocp[nbits(copybits^bits) + 1] += 1; /* pkts left, including current */
#endif	BOOKKEEPING
	return 0;
}

retry_tics(retry)
int retry;
{
	static short inited = 0;
	static unsigned short rt_table[8] = {
		1, 1, 2, 2, 3, 3, 4, 4	/* initially secs; converted to tics */
	};
	extern int hz;

	if (!inited  &&  hz) {
		standby_tics = 4 * hz;		/* 4 seconds */
		urgent_tics = hz / 50;		/* 20 msec, rounded up */
		if (urgent_tics * 50 < hz)
			urgent_tics += 1;
		for (inited = 0;  inited < 8;  inited += 1)
			rt_table[inited] *= hz;
	}
	return rt_table[retry & 7];
}

#ifdef	WDEBUG
spdump(p)
register struct sendpk *p;
{
	printf("snd: ");  hdump(&p->h);
	printf(" f0: ");  frdump(&p->frag0);
	printf(" f1: ");  frdump(&p->frag1);
	printf(" ct: ");  ctldump(&p->ctl);
	printf(" ms: ");  ctldump(&p->msg);
	printf("     ");  printf("fl=%x rxs=%x rad=%x cxs=%x cad=%x\n",
				p->flags, p->rocp_xs, p->rocp_addr,
				p->cfos_xs, p->cfos_addr);
}

cfrqdump(p)
register struct cpfmreqpk *p;
{
	printf("cfr: ");  hdump(&p->h);
	printf("     ");  printf("sad=%x dad=%x len=%x sxs=%x dxs=%x\n",
				p->srcaddr, p->dstaddr, p->len,
				p->srcxs, p->dstxs);
}

hdump(p)
register struct packet *p;
{
	printf("ty=%x ver=%x retry=%x err=%x sndsq=%x cpseq=%x src=%x dst=%x\n",
		p->type, p->version, p->retry, p->errcode,
		p->sendseqid, p->copyseqid, p->src, p->dst);
}

frdump(p)
register struct fragment *p;
{
	printf("fl=%x frid=%x sxs=%x dxs=%x len=%x off=%x sad=%x dad=%x\n",
		p->flags, p->fragid, p->srcxs, p->dstxs,
		p->len, p->off, p->srcaddr, p->dstaddr);
}

ctldump(p)
register struct wctl *p;
{
	printf("rc=%x rf=%x xs0=%x xs1=%x",
		p->h.rcode, p->h.rflags, p->h.xs0, p->h.xs1);
	if (p->h.xs0)
		printf(" s0ad=%x s0len=%x", p->seg0.addr, p->seg0.len);
	if (p->h.xs1)
		printf(" s1ad=%x s1len=%x", p->seg1.addr, p->seg1.len);
	printf("\n");
}
#endif	WDEBUG
