#define	WMSG_SZ		64

#define	MID_MASK	0x7FFF0000
#define	PID_MASK	0x00007FFF

#define	RESERVED_MIDS	16		/* max number of pseudo-mids */
#define	BROADCAST_MID	0x7FFF0000	/* pseudo-mid for broadcasting */
#define	SELF_MID	0x7FFE0000	/* pseudo-mid for loopback */
#ifndef is68k_kobj
#ifdef NPC
#define	NPC_MID		0x7FFD0000	/* pseudo-mid for NPC */
#endif NPC
#endif	is68k_kobj
#define	INTERRUPT_PID	0x00007FFF	/* pseudo-pid of interrupt handler */
#define	SERVER_PID	0x00007FFE	/* pseudo-pid of every wipc server */

#define	MID(rpid)	((rpid) & MID_MASK)
#define	PID(rpid)	((rpid) & PID_MASK)

struct	wmsg_hdr {		/* header: at beginning of every request */
	unsigned char	rcode;		/* request/reply code */
	unsigned char	rflags;		/* flags; see below */
#define		RF_NOREP	1	/*   don't wait for a reply */
#define		RF_NONIDEM	2	/*   request is not idempotent */
#ifdef	SYSV
#define		RF_UNIVERSE_SYSV 4	/*   universe is SYSV */
#define		RF_UMBZ		0xF8
#else	SYSV
#define		RF_UMBZ		0xFC
#endif	SYSV
#define		RF_USER		(1<<7)	/*   request originated from user */
#define		RF_CRCOUSIN	(1<<6)	/*   create new cousin if necessary */
#define		RF_ALT		(1<<5)	/*   alternate flag (miscellaneous) */
	unsigned char	xs0;		/* seg 0 access qualifiers */
#define		XS_READ		1	/*   segment read permission is ok */
#define		XS_WRITE	2	/*   segment write permission is ok */
#define		XS_RMASK	(3<<2)	/*   read mode: how to xmit at send */
#define		 XS_RMPACKET	 (0<<2)	/*	append readable segments */
#define		 XS_RMZSTR	 (1<<2)	/*	data is zero-term'd string */
#define		 XS_RMBURST	 (2<<2)	/*	follow with COPYFROM burst */
#define		 XS_RMNONE	 (3<<2)	/*	no segment data at send */
#define		XS_SEGMASK	(3<<6)	/*  segment qualifers */
#define		 XS_NOSEG	 (0<<6)	/*	invalid segment spec */
#define		 XS_USER	 (1<<6)	/*	user virtuial segment */
#define		 XS_KERN	 (2<<6)	/*	kernel virtuial segment */
#define		 XS_PHYS	 (3<<6)	/*	physical segment */
#define		XS_UMBZ		0xF0
	unsigned char	xs1;		/* seg 1 access qualifiers */
};

struct	wmsg_seg {		/* seg 0 follows header, seg 1 follows seg 0 */
	char		*addr;		/* segment base address */
	unsigned long	len;		/* segment length */
};

struct	wctl {
	struct wmsg_hdr	h;
	struct wmsg_seg	seg0;
	struct wmsg_seg	seg1;
};

struct	wmsg {
	struct wmsg_hdr	h;
	struct wmsg_seg	seg0;
	struct wmsg_seg	seg1;
	char		pad[WMSG_SZ - sizeof(struct wctl)];
};
