#include "../h/ucode.h"
/******************************************************************************
* UCoutput(n, p1, p2, ... pn ):  
*	Loads n parameters into the FIFO of the GIP
*
* C Interface:
*	UCoutput(n, p1, p2, ... pn )
*	int nparms;
*	int p1, p2, p3;
*
* Assembly Interface:
*	+---------------------------------+
*	| nparms                          |  0 (L)
*	+---------------------------------+
*	|////////////////| p1             |  6 (W)
*	+---------------------------------+
*	|////////////////| p2             | 10 (W)
*	+---------------------------------+
*			.
*	+---------------------------------+
*	|////////////////| pn             | ((4 * n) + 2) (W)
*	+---------------------------------+
*
* C Return:
* Assembly Return:
*	all registers returned as passed
******************************************************************************/
	.text
	.globl	_UCoutput
_UCoutput:
#ifdef	DEBUG_UCODE	/**/
	/* KLUDGE, make shure that we own gip: u.u_procp->p_flag & SOWNGIP */
	moveml	#<d0-d1,a0-a1>,sp@-
	movl	_u+84,a0
	btst	#3,a0@(46)
	jne	1f
	jsr	_gpillegal
    1:	moveml	sp@+,#<d0-d1,a0-a1>
#endif	DEBUG_UCODE	/**/
	link	a6,#0			/* establish frame pointer */
	moveml	#<d0-d3,a0-a1>,sp@-	/* save registers */
	movl	_gpaddr,a1		/* fifo pointer */
	lea	a6@(10),a0		/* generate parameter pointer */
	movw	a0@,d0			/* get parameter count */
	addl	#4,a0			/* adjust for word */
	movw	d0,d1
	addw	_GPflevel,d1
	movw	d1,_GPflevel
	subw	#GPFIFOMAX-2,d1		/* leave some slack */
	jlt	4f
    1:	movw	#0x400,d2
    2:	subw	#1,d2
	jeq	5f
    	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
	movw	d0,_GPflevel
	jra	4f
    3:	movw	a0@,a1@			/* load fifo */
	addl	#4,a0
    4:	dbf	d0,3b			/* test for done */
	moveml	sp@+,#<d0-d3,a0-a1>	/* restore */
	unlk	a6			/* remove stack frame */
	rts				/* return */
    5:	btst	#GPUSEINT_B,_gptype
	jeq	1b
	movw	sr,d2			/* save current priority */
	movw	#0x2600,d0
	movw	d0,sr			/* goto high priority */
	movw	#GP_INTON,a1@		/* send interrupt on cmd */
	pea	GP_FIFOPRI
	movl	#_gpaddr,sp@-
	jbsr	_sleep			/* goto sleep waiting for memory */
	addql	#8,sp
	movl	_gpaddr,a1		/* fifo pointer */
	movl	a6,a0
	lea	a6@(10),a0		/* generate parameter pointer */
	movw	a0@,d0			/* get parameter count */
	addl	#4,a0			/* adjust for word */
	movw	d0,_GPflevel		/* fifo is now empty */
	movw	d2,sr			/* restore priority */
	jra	4b
