#include "../h/ucode.h"
/*******************************************************************************
* CPUgetdisp: 
*	Get control of the graphics display memory for the CPU.
*
* Assembly Interface:
*	input:	no parameters
*	output:	all registers saved
*******************************************************************************/
	.text
	.globl	_CPUgetdisp
_CPUgetdisp:
	btst	#GPHASGIP_B,_gptype	/* check if we should be using gip */
	jeq	4f
#ifdef	DEBUG_UCODE	/**/
	/* KLUDGE, make shure that we own gip: u.u_procp->p_flag & SOWNGIP */
	/* NOTE: the font daemon calls this without ownership of the GIP!! */
	moveml	#<d0-d1,a0-a1>,sp@-
	movl	_u+84,a0
	btst	#3,a0@(46)
	jne	1f
	jsr	_gpillegal
    1:	moveml	sp@+,#<d0-d1,a0-a1>
#endif	DEBUG_UCODE	/**/
	tstw	_GPflevel		/* is fifo empty ? */
	jeq	4f			/* */
	moveml	#<d0-d2,a0-a1>,sp@-	/* save */
	movl	_gpaddr,a0		/* get fifo pointer */
	movw	#GP_INTOF,a0@		/* send interrupt off cmd */
	movl	#0x64,d0		/* 68020 constant */
    1:	dbf	d0,1b			/* 2usec, fifo trickle */
    1:	movw	#0x400,d1
    2:	subw	#1,d1
	jeq	5f
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b /* wait till empty */
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b
    3:	clrw	_GPflevel		/* fifo is now empty */
	moveml	sp@+,#<d0-d2,a0-a1>	/* restore */
    4:	rts				/* return */
    5:	btst	#GPUSEINT_B,_gptype	/* did not empty by polling */
	jeq	1b			/* use interrupts, if allowed */
	movw	sr,d2			/* save current priority */
	movw	#0x2600,d0
	movw	d0,sr			/* go to high priority */
	movl	_gpaddr,a0
	movw	#GP_INTON,a0@		/* send interrupt on cmd */
	pea	GP_FIFOPRI
	movl	#_gpaddr,sp@-
	jbsr	_sleep			/* goto sleep waiting for memory */
	addql	#8,sp
	movw	d2,sr			/* restore priority */
	jra	3b
