#include "../h/ucode.h"
/******************************************************************************
* ToggleURaster(mask, mx, my, raster, rx, ry, w, h)
*
* Selectively toggles pixels in the rectangle of width "w" and height "h"
* located at ("rx", "ry") of "raster".  A pixel is toggled wherever there is
* a 1 bit in the rectangle of the same size at ("mx", "my") in "mask".
* mask is assumed to be in user space.
*
* C Interface:
*
*	ToggleURaster(mask, mx, my, raster, rx, ry, w, h)
*	RASTER *mask, *raster;
*	int mx, my, rx, ry, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| mask                            |  0 (L)
*	+---------------------------------+
*	|////////////////| mx             |  6 (W)
*	+---------------------------------+
*	|////////////////| my             | 10 (W)
*	+---------------------------------+
*	| raster                          | 12 (L)
*	+---------------------------------+
*	|////////////////| rx             | 18 (W)
*	+---------------------------------+
*	|////////////////| ry             | 22 (W)
*	+---------------------------------+
*	|////////////////| w              | 26 (W)
*	+---------------------------------+
*	|////////////////| h              | 30 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_ToggleURaster
_ToggleURaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */

	/* Get C parameters */
	movl	a6@(0+8),a0		/* get mask pointer */
	movl	a0@(2),a2		/* get mask address */
	movw	a0@,a0			/* get mask width */
	movw	a6@(6+8),d0		/* get mask X coordinate */
	movw	a6@(10+8),d1		/* get mask Y coordinate */
	movl	a6@(12+8),a1		/* get raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	movw	a6@(18+8),d2		/* get raster X coordinate */
	movw	a6@(22+8),d3		/* get raster Y coordinate */
	movw	a6@(26+8),d4		/* get width */
	movw	a6@(30+8),d5		/* get height */

	/* Setup registers */
	jsr	setup			/* do the setup */
	blt	return			/* return if nothing to do */
	andw	#0xf,d1			/* adjust rotation */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display */
#endif UCODE

	/* Toggle the rectangle */
    1:	movl	a2@,d6			/* read initial source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	eorw	d6,a3@			/* combine source with destination */
	addw	a4,a2			/* bump source address */
	addw	a4,a3			/* bump destination address */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	eorw	d6,a3@			/* combine source with destination */
	addw	a4,a2			/* point to next source word */
	addw	a4,a3			/* point to next destination word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a2@,d6			/* read final source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	eorw	d6,a3@			/* combine source with destination */
	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */
					/* all done */
returnd:	
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release diaplay */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
