#include "../h/ucode.h"
/******************************************************************************
* screen
*
* This extended raster descriptor represents the ISI screen.
*
*******************************************************************************/
	.globl	_screen			/* screen raster */
	.globl	_screen0		/* screen raster */
	.globl	_screen1		/* screen raster */
	.globl	_screen2		/* screen raster */
	.globl	_screen3		/* screen raster */
	.globl	_gpaddr			/* address of gip fifo register */
	.globl	_gpwcs			/* address of gip wcs */
	.data
_screen0:
_screen:
	.word	BXMAX/8			/* width in bytes of a display line */
	.long	_vidbuf			/* virtual address of raster */
	.long	_vidbuf+0x40000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_screen1:
	.word	BXMAX/8			/* width in bytes of a display line */
	.long	_vidbuf+0x40000		/* virtual address of raster */
	.long	_vidbuf+0x80000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_screen2:
	.word	BXMAX/8			/* width in bytes of a display line */
	.long	_vidbuf+0x80000		/* virtual address of raster */
	.long	_vidbuf+0xc0000		/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_screen3:
	.word	BXMAX/8			/* width in bytes of a display line */
	.long	_vidbuf+0xc0000		/* virtual address of raster */
	.long	_vidbuf+0x100000	/* EXTENDED end of display memory */
	.long	_vidbuf+0x28000		/* EXTENDED end of visable memory */

_gpaddr:.long	0x000000
_gpwcs:	.long	0x000000
