#include "../h/ucode.h"
/******************************************************************************
* InvertRaster(raster, x, y, w, h)
*
* Inverts the rectangle of width "w" and height "h" located at ("x", "y") of
* "raster".
*
* C Interface:
*
*	InvertRaster(raster, x, y, w, h)
*	RASTER *raster;
*	int x, y, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| raster                          |  0 (L)
*	+---------------------------------+
*	|////////////////| x              |  6 (W)
*	+---------------------------------+
*	|////////////////| y              | 10 (W)
*	+---------------------------------+
*	|////////////////| w              | 14 (W)
*	+---------------------------------+
*	|////////////////| h              | 18 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_InvertRaster
_InvertRaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */
#ifdef UCODE_BOX
#ifdef UCODE_ALU
#ifdef UCODE_PITCH
	btst	#GPHASGIP_B,_gptype	/* check if we have a GIP */
	beq	manual			/* no do it the hard way */

	btst	#GPCOLOR_B,_gptype	/* is this a color system */
	bne	manual			/* do by hand if color */

	/* See if within display memory */
	movl	a6@(0+8),a0		/* get raster pointer */
	movw	a0@,a1			/* get raster width in bytes */
	movl	#0,a2			/* indicate no source */
	movl	a0@(2),a3		/* get dest raster address */
	jsr	dispchk			/* check */
	bne	manual			/* no do it the hard way */
	movw	a6@(14+8),d2		/* get width */
	cmpw	#32,d2			/* we also can't do widths less */
	ble	manual			/* than 32 bits! */

	/* Set toggle mode */
	movw	#GP_ALUT,d0		/* alu toggle command */
	jsr	alu_mode		/* alu mode set */

	/* Check destination pitch and set if necessary */
	jsr	dst_pitch		/* check and set */

	/* Get rectangle and adjust to positive width and height */
 	movw	a6@(6+8),d0		/* get X coordinate */
	movw	a6@(10+8),d1		/* get Y coordinate */
	movw	a6@(14+8),d2		/* get width */
	movw	a6@(18+8),d3		/* get height */
	jsr	Adjust			/* adjust */

	/* Let GIP draw box */
	jsr	box			/* do box clear */
	bra	return			/* return */

#endif UCODE_PITCH
#endif UCODE_ALU
#endif UCODE_BOX
	/* Get C parameters */
manual: movl	a6@(0+8),a0		/* get raster pointer */
	movw	a0@,a1			/* get raster width */
	movl	a0@(2),a3		/* get raster address */
	movw	a6@(6+8),d2		/* get X coordinate */
	movw	a6@(10+8),d3		/* get Y coordinate */
	movw	a6@(14+8),d4		/* get width */
	movw	a6@(18+8),d5		/* get height */

	/* Setup registers */
	movl	#0,a2			/* indicate no source */
	jsr	setup			/* do the setup */
	blt	return			/* return if nothing to do */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display */
#endif UCODE

	/* Invert the rectangle */
    1:	eorw	d2,a3@+			/* complement left partial */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	notw	a3@+			/* complement a middle word */
	dbf	d0,2b			/* loop until row finished */

    3:	eorw	d3,a3@			/* complement right partial */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

returnd:	
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
