#include "../h/ucode.h"
/******************************************************************************
* CopyPattern(raster, x, y, w, h, pattern, xphase, yphase)
*
* Copies the 16 by 16 rectangle pointed to by "pattern" over the rectangle of
* width "w" and height "h" at coordinates ("x", "y") of "raster".  "Xphase"
* and "yphase" specify a screen coordinate that would contain the upper left
* corner of the pattern if it were extended to cover that point.
*
* C Interface:
*
*	CopyPattern(raster, x, y, w, h, pattern, xphase, yphase)
*	RASTER *raster;
*	int x, y, w, h;
*	PATTERN *pattern;
*	int xphase, yphase;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| raster			  |  0 (L)
*	+---------------------------------+
*	|////////////////| x              |  6 (W)
*	+---------------------------------+
*	|////////////////| y              | 10 (W)
*	+---------------------------------+
*	|////////////////| w              | 14 (W)
*	+---------------------------------+
*	|////////////////| h              | 18 (W)
*	+---------------------------------+
*	| pattern			  | 20 (L)
*	+---------------------------------+
*	|////////////////| xphase         | 26 (W)
*	+---------------------------------+
*	|////////////////| yphase         | 30 (W)
*	+---------------------------------+
*
*	NOTE: a6 (frame pointer) is used as a temp ! 
*
******************************************************************************/
	.globl	_CopyPattern
	.text
_CopyPattern:
	link	a6,#0			/* create new stack frame */
	moveml	#<d2-d7,a2-a6>,sp@-	/* save working registers */

#ifdef UCODE_BOXP
#ifdef UCODE_PITCH
	/* See if within display memory */
	movl	a6@(20+8),a0		/* get source raster pointer */
	movl	a0@(2),a2		/* get raster address */
	movw	a0@,a0			/* get raster width */
	movl	a6@(0+8),a1		/* get destination raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	jsr	dispchk			/* check */
	bne	manual			/* no do it the hard way */

	/* Set the source and destination pitch */
	jsr	set_pitch

	/* Get parameters and normalize destination rectangle */
	movw	a6@(6+8),d0		/* get destination X coordinate */
	movw	a6@(10+8),d1		/* get destination Y coordinate */
	movw	a6@(14+8),d2		/* get width */
	movw	a6@(18+8),d3		/* get height */
	jsr	Adjust			/* adjust to positive */
	movw	d0,d4			/* save normalized dest X */
	movw	d1,d5			/* save normalized dest Y */

	movw	a6@(26+8),d0		/* get source X coordinate */
	movw	a6@(30+8),d1		/* get source Y coordinate */

	/* Fill rectangle with pattern */ 
	jsr	boxp			/* do box pattern */
	bra	return			/* return */
#endif UCODE_PITCH
#endif UCODE_BOXC

	/* Get C parameters */
manual:	movl	a6@(0+8),a1		/* get raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	movw	a6@(6+8),d2		/* get X coordinate */
	movw	a6@(10+8),d3		/* get Y coordiante */
	movw	a6@(14+8),d4		/* get width */
	movw	a6@(18+8),d5		/* get height */
	movl	a6@(20+8),a5		/* get pattern address */
	movw	a6@(26+8),d0		/* get X phase */
	movw	a6@(30+8),d1		/* get Y phase */
	
	/* Setup pointers into pattern */
	movl	a5,a6
	addl	#0x20,a6		/* compute first address beyond */
	movw	d3,d6			/* get Y coordinate of area */
	subw	d1,d6			/* compute up rotation necessary */
	andw	#0x0F,d6		/* take modulo 16 */
	aslw	#1,d6			/* make a word index out of it */
	addw	d6,a5			/* find first pattern address */

	/* Compute right rotation necessary to put pattern in phase */
	andw	#0x0F,d0		/* rotation is simply phase mod 16 */

	/* Setup registers for copy */
	movw	d0,d7			/* save rotation */
	jsr	lsetup			/* setup for long operations */
	blt	return			/* return if nothing to do */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display */
#endif UCODE
	movw	d7,d1			/* restore rotation where it belongs */

	/* Fill the area with the pattern */
    1:	movw	a5@,d6			/* get next pattern word */
	swap	d6			/* put it in high word */
	movw	a5@+,d6			/* put it in low word too */
	rorl	d1,d6			/* rotate according to phase */
	movl	d6,a4			/* store it in a safe place */

	cmpl	a6,a5			/* reached end of pattern? */
	bne	9f			/* branch if not */
	subl	#0x20,a5		/* point back to beginning if so */

    9:	movl	a4,d6			/* get a copy of pattern word */
	andl	d2,d6			/* keep valid bits */
	notl	d2			/* reverse left mask */
	movl	a3@,d7			/* read destination bits */
	andl	d2,d7			/* keep bits outside range */
	orl	d6,d7			/* combine with pattern bits */
	movl	d7,a3@+			/* write destination back */
	notl	d2			/* restore left mask */

	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movl	a4,a3@+			/* write out pattern word */
	dbf	d0,2b			/* loop until row finished */

    3:	movl	a4,d6			/* get a copy of pattern word */
	andl	d3,d6			/* keep valid bits */
	notl	d3			/* reverse right mask */
	movl	a3@,d7			/* read destination bits */
	andl	d3,d7			/* keep bits outside range */
	orl	d6,d7			/* combine with source bits */
	movl	d7,a3@			/* write destination back */
	notl	d3			/* restore right mask */

	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	/* Clean up stack and return */
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a6>	/* restore working registers */
	unlk	a6			/* unlink stack frame */
	rts				/* and return */
