#include "../h/ucode.h"
/******************************************************************************
* CopyRaster(sraster, sx, sy, draster, dx, dy, w, h)
*
* Copies the rectangle of width "w" and height "h" from location ("sx", "sy")
* of "sraster" to location "("dx", "dy") of "draster".
*
* C Interface:
*
*	CopyRaster(sraster, sx, sy, draster, dx, dy, w, h)
*	RASTER *sraster, *draster;
*	int sx, sy, dx, dy, w, h;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| sraster                         |  0 (L)
*	+---------------------------------+
*	|////////////////| sx             |  6 (W)
*	+---------------------------------+
*	|////////////////| sy             | 10 (W)
*	+---------------------------------+
*	| draster                         | 12 (L)
*	+---------------------------------+
*	|////////////////| dx             | 18 (W)
*	+---------------------------------+
*	|////////////////| dy             | 22 (W)
*	+---------------------------------+
*	|////////////////| w              | 26 (W)
*	+---------------------------------+
*	|////////////////| h              | 30 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_CopyRaster
_CopyRaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */
#ifdef UCODE_BOXC
#ifdef UCODE_PITCH
	/* See if within display memory */
	movl	a6@(0+8),a0		/* get source raster pointer */
	movl	a0@(2),a2		/* get raster address */
	movw	a0@,a0			/* get raster width */
	movl	a6@(12+8),a1		/* get destination raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	jsr	dispchk			/* check */
	bne	manual			/* no do it the hard way */

	/*	Set the source and destination pitch */
	jsr	set_pitch

	/* Get parameters and normalize rectangles */
	movw	a6@(18+8),d0		/* get destination X coordinate */
	movw	a6@(22+8),d1		/* get destination Y coordinate */
	movw	a6@(26+8),d2		/* get width */
	movw	a6@(30+8),d3		/* get height */
	jsr	Adjust			/* adjust to positive */
	movw	d0,d4			/* save normalized dest X */
	movw	d1,d5			/* save normalized dest Y */

	movw	a6@(6+8),d0		/* get source X coordinate */
	movw	a6@(10+8),d1		/* get source Y coordinate */
	movw	a6@(26+8),d2		/* get width */
	movw	a6@(30+8),d3		/* get height */
	jsr	Adjust			/* adjust to positive */

	/* Copy rectangle */ 
	jsr	boxc			/* do box copy */
	bra	return			/* return */

#endif UCODE_PITCH
#endif UCODE_BOXC
	/* Get C parameters */
manual:	movl	a6@(0+8),a0		/* get source raster pointer */
	movl	a0@(2),a2		/* get raster address */
	movw	a0@,a0			/* get raster width */
	movw	a6@(6+8),d0		/* get source X coordinate */
	movw	a6@(10+8),d1		/* get source Y coordinate */
	movl	a6@(12+8),a1		/* get destination raster pointer */
	movl	a1@(2),a3		/* get raster address */
	movw	a1@,a1			/* get raster width */
	movw	a6@(18+8),d2		/* get destination X coordinate */
	movw	a6@(22+8),d3		/* get destination Y coordinate */
	movw	a6@(26+8),d4		/* get width */
	movw	a6@(30+8),d5		/* get height */

	/* Setup registers */
	jsr	setup			/* do the setup */
	blt	return			/* return if nothing to do */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display for CPU */
#endif UCODE

	/* Copy according to direction and alignment */
	movw	d1,d0			/* get rotation */
	andw	#0xf,d0			/* test rotation mod 16 */
	beq	align			/* branch if aligned */

	cmpl	#0,a4			/* test inc direction for unaligned */
	bgt	uninc			/* branch if incrementing */
	bra	undec			/* branch if decrementing */

align:	cmpl	#0,a4			/* test inc direction for unaligned */
	bgt	alinc			/* branch if incrementing */
	bra	aldec			/* branch if decrementing */

	/* Copy unaligned, incrementing addresses */
uninc:
	tstw	d1			/* check for pre-load case */
	blt	incp1			/* yep, negative shift */

	andw	#0xf,d1			/* take shift mod 16 */
	addql	#2,a0			/* bump source vertical increment */
	addql	#2,a2			/* bump source address */

    1:	movw	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination bits */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@+			/* write destination back */
	notw	d2			/* restore left mask */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	movw	d6,a3@+			/* write it out */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	cmpw	#0x0,d3			/* check if no final mask */
	jeq	7f			/* loop around if true */
	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

    7:	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

incp1:	andw	#0xf,d1			/* get a positive shift count */
    1:	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination bits */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@+			/* write destination back */
	addql	#2,a2			/* bump source address */
	notw	d2			/* restore left mask */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	movw	d6,a3@+			/* write it out */
	addql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	cmpw	#0x0,d3			/* check if no final mask */
	jeq	7f			/* loop around if true */
	movl	a2@,d6			/* read left source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

    7:	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Copy unaligned, decrementing addresses */
undec:	tstw	d1			/* check for pre-load case */
	blt	decp1			/* yep, negative shift */

	andw	#0xf,d1			/* take shift mod 16 */
	subql	#2,a0			/* adjust src vertical incr */

    1:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination bits */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d2			/* restore left mask */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	subql	#2,a2			/* point to next word */
	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	movw	d6,a3@-			/* write it out */
	dbf	d0,2b			/* loop until row finished */

    3:	cmpw	#0x0,d3			/* check if no final mask */
	jeq	7f			/* loop around if true */
	movw	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@-,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

    7:	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

decp1:	andw	#0xf,d1			/* convert shift to positive */
    1:	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination bits */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
    	subql	#2,a2			/* bump source address */
	notw	d2			/* restore left mask */
	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movl	a2@,d6			/* read a source word */
	lsrl	d1,d6			/* align with destination */
	movw	d6,a3@-			/* write it out */
	subql	#2,a2			/* point to next word */
	dbf	d0,2b			/* loop until row finished */

    3:	cmpw	#0x0,d3			/* check if no final mask */
	jeq	7f			/* loop around if true */
	movl	a2@,d6			/* read right source word */
	lsrl	d1,d6			/* align with destination */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@-,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

    7:	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Copy aligned, incrementing addresses */
alinc:	addql	#2,a2			/* point to first source word */

	tstw	d4			/* null middle section? */
	bge	aligen			/* do slow version if not */

	cmpw	#0xFFFF,d2		/* starts on word boundary? */
	bne	aligen			/* do slow version if not */

	tstw	d3			/* ends on word boundary? */
	bne	aligen			/* do slow version if not */

	/* Copy aligned, word width, word boundary alignment */
	addw	#2,a0			/* correct source increment */
	addw	#2,a1			/* correct destination increment */

    1:	movw	a2@,a3@			/* copy a word */
	addw	a0,a2			/* bump source address */
	addw	a1,a3			/* bump destination address */
	dbf	d5,1b			/* do next word */

	bra	returnd			/* return */

	/* Copy aligned, incrementing address, arbitrary width */
aligen:
    1:	movw	a2@+,d6			/* read left source word */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination bits */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@+			/* write destination back */
	notw	d2			/* restore left mask */

	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movw	a2@+,a3@+		/* write it out */
	dbf	d0,2b			/* loop until row finished */

    3:	movw	a2@,d6			/* read left source word */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	bra	returnd			/* return */

	/* Copy aligned, decrementing addresses */
aldec:	addql	#2,a2			/* point to first source word */
    1:	movw	a2@,d6			/* read right source word */
	andw	d2,d6			/* keep valid bits */
	notw	d2			/* reverse left mask */
	movw	a3@,d7			/* read destination word */
	andw	d2,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d2			/* restore left mask */

	movw	d4,d0			/* initialize word counter */
	blt	3f			/* skip loop if zero */

    2:	movw	a2@-,a3@-		/* read a source word */
	dbf	d0,2b			/* loop until row finished */

    3:	movw	a2@-,d6			/* read right source word */
	andw	d3,d6			/* keep valid bits */
	notw	d3			/* reverse right mask */
	movw	a3@-,d7			/* read destination bits */
	andw	d3,d7			/* keep bits outside range */
	orw	d6,d7			/* combine with source bits */
	movw	d7,a3@			/* write destination back */
	notw	d3			/* restore right mask */

	addw	a0,a2			/* bump source address to next row */
	addw	a1,a3			/* bump destination address to next row */
	dbf	d5,1b			/* loop until block finished */

	/* Clean up stack and return */
returnd:
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display */
#endif UCODE_DEBUG
return:
	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
