#include "../h/ucode.h"
/******************************************************************************
* ClearRaster(raster, x, y, w, h, color)
*
* Clears the rectangle of "raster" specified by "x", "y", "w", and "h" to
* "color".
*
* C Interface:
*
*	ClearRaster(raster, x, y, w, h, color)
*	RASTER *raster;
*	int x, y, w, h;
*	COLOR color;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| raster pointer                  |  0 (L)
*	+---------------------------------+
*	|////////////////| x              |  6 (W)
*	+---------------------------------+
*	|////////////////| y              | 10 (W)
*	+---------------------------------+
*	|////////////////| w              | 14 (W)
*	+---------------------------------+
*	|////////////////| h              | 18 (W)
*	+---------------------------------+
*	|////////////////| color          | 22 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_ClearRaster
_ClearRaster:
	link	a6,#0			/* establish frame pointer */
	moveml	#<d2-d7,a2-a5>,sp@-	/* save registers */
#ifdef UCODE_BOX
#ifdef UCODE_ALU
#ifdef UCODE_PITCH
	/* See if within display memory */
	movl	a6@(0+8),a0		/* get raster pointer */
	movw	a0@,a1			/* get raster width in bytes */
	movl	#0,a2			/* indicate no source */
	movl	a0@(2),a3		/* get dest raster address */
	jsr	dispchk			/* check */
	bne	manual			/* no do it the hard way */

	/* Clear according to specified color */
	movw	a6@(22+8),d7		/* get color */
	btst	#GPCOLOR_B,_gptype	/* is this a color system */
	jeq	1f			/* no, set alu mode */
	movw	d7,d0			/* load the color value */
	jsr	set_color
	jra	2f

    1:	tstw	d7			/* test color */
	bne	gwhite			/* branch if white */
gblack: movw	#GP_ALUC,d0		/* alu clear command */
	bra	1f			/* go set */
gwhite: movw	#GP_ALUS,d0		/* alu set command */
    1:	jsr	alu_mode		/* alu mode set */

	/* Check destination pitch and set if necessary */
    2:	jsr	dst_pitch		/* check and set */

	/* Get rectangle and adjust to positive width and height */
 	movw	a6@(6+8),d0		/* get X coordinate */
	movw	a6@(10+8),d1		/* get Y coordinate */
	movw	a6@(14+8),d2		/* get width */
	movw	a6@(18+8),d3		/* get height */
	jsr	Adjust			/* adjust */

	/* Let GIP draw box */
	jsr	box			/* do box clear */
	bra	return			/* return */

#endif UCODE_PITCH
#endif UCODE_ALU
#endif UCODE_BOX
	/* Get C parameters */
manual: movl	a6@(0+8),a0		/* get raster pointer */
	movw	a0@,a1			/* get raster width */
	movl	a0@(2),a3		/* get raster address */
	movw	a6@(6+8),d2		/* get X coordinate */
	movw	a6@(10+8),d3		/* get Y coordinate */
	movw	a6@(14+8),d4		/* get width */
	movw	a6@(18+8),d5		/* get height */
	movw	a6@(22+8),d7		/* get color */

	/* Setup registers */
	movl	#0,a2			/* indicate no source */
	jsr	lsetup			/* do the setup */
	blt	return			/* return if nothing to do */
#ifdef UCODE
	jsr	_CPUgetdisp		/* get display for CPU */
#endif UCODE

	/* Clear according to specified color */
	tstw	d7			/* test color */
	bne	white			/* branch if white */

	/* Clear rectangle to black */
black:	notl	d2			/* complement left mask for clearing */
	notl	d3			/* complement right mask too */

    1:	andl	d2,a3@+			/* clear left partial long */
	movw	d4,d6			/* initialize word counter */
	blt	3f

    2:	clrl	a3@+			/* clear a middle long */
	dbf	d6,2b			/* loop until entire middle cleared */

    3:	andl	d3,a3@			/* clear right partial long */
	addw	a1,a3			/* bump pointer to next row */
	dbf	d5,1b			/* loop until all rows cleared */
	bra	returnd			/* return */

	/* Clear rectangle to white */
white:	moveq	#-1,d0			/* get all ones for setting */

    1:	orl	d2,a3@+			/* set left partial long */

	movw	d4,d6			/* initialize word counter */
	blt	3f

    2:	movl	d0,a3@+			/* set a middle long */
	dbf	d6,2b			/* loop until entire middle set */

    3:	orl	d3,a3@			/* set right partial long */
	addw	a1,a3			/* bump pointer to next row */
	dbf	d5,1b			/* loop until all rows cleared */

	/* Clean up stack and return */
returnd:
#ifdef UCODE_DEBUG
	jsr	_CPUrlsdisp		/* release display by CPU */
#endif UCODE_DEBUG
return:	moveml	sp@+,#<d2-d7,a2-a5>	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
