/*
 *	Here lies the structure of a rectangle and all of the routines
 *	needed to deal with them.  Dealing with rectangle is simply set
 *	theory, and all those little set theoretical functions we just love.
 *	A tile is simply a rectangle which is linked to other rectangles, so
 *	all of the following routines are used when dealing with tiles.
 */
#ifndef _RECTANGLE
#define _RECTANGLE

/*
 * A rectangle is simply its dimensions
 */
struct rectangle
{
	word	    x;
	word	    y;
	word	    w;
	word	    h;
};

/*
 * These are the routines needed, see rectangle.c
 */
extern bool	Within();	
extern bool	Overlap();
extern bool	Adjacent();
extern void	Union();
extern void	Intersection();
extern void	Top();
extern void	Bottom();
extern void	Left();
extern void	Right();

#endif
