/******************************************************************************
* CharacterWidth(font, character)
*
* Returns the width in pixels of "character" in "font".
*
* C Interface:
*
*	int CharacterWidth(font, character)
*	FONT font;
*	char character;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| font                            |  0 (L)
*	+---------------------------------+
*	|////////////////| character      |  6 (W)
*	+---------------------------------+
*
******************************************************************************/
	.text
	.globl	_CharacterWidth
_CharacterWidth:
	movl	sp@(4),a0		/* get font address */
	movb	sp@(7+4),d0		/* get character code */
	andw	#0xFF,d0		/* strip high bits of character */
	aslw	#3,d0			/* compute offset in info table */
	lea	a0@(8,d0:w),a0		/* compute address of table entry */
	movb	a0@,d0			/* retrieve the width */
	extw	d0			/* extend to word */
	extl	d0			/* extend to long for C */
	rts				/* return */
