/******************************************************************************
* Adjust
*
* This routine adjust rectangles with negative widths or heights to equivalent
* rectangles with positive widths and heights.  On entry, the registers should
* contain:
*
*	D0 (W):		X coordinate of rectangle
*	D1 (W):		Y coordinate of rectangle
*	D2 (W):		width of rectangle
*	D3 (W):		height of rectangle
*
* On exit, the registers contain:
*
*	D0 (W):		X coordinate of adjusted rectangle
*	D1 (W):		Y coordinate of adjusted rectangle
*	D2 (W):		width of adjusted rectangle
*	D3 (W):		height of adjusted rectangle
*
* Except for the registers used to pass and return values, all registers are
* preserved.
*
******************************************************************************/
	.text
	.globl Adjust
Adjust:	tstw	d2			/* test the width */
	bgt	1f			/* skip adjust if already positive */
	addw	d2,d0			/* compute X before source left edge */
	addqw	#1,d0			/* X of source left edge */
	negw	d2			/* make width positive */
    1:	tstw	d3			/* test the height */
	bgt	2f			/* skip adjust if already positive */
	addw	d3,d1			/* compute Y before source top */
	addqw	#1,d1			/* Y of source top */
	negw	d3			/* make height positive */
    2:	rts				/* return */
