#include <ucode.h>

#ifdef LOAD_WCS
#include "gipucode.h"

load_wcs ()
{ 
	int words, i, s;
	unsigned short *addr;

	for (words = 0; words <= 2047; words++)	{ /* 2k words control store */
		for (i= 3; i >= 0; i--) {
			if (words <= (uc_words/4)-1)
				gpaddr->gp_snake = (short)(uc_data[words*4+i]);
			else
		      		/* fill rest of WCS with init */
				gpaddr->gp_snake = (short)(initial[i]);
			for (s = 1; s <= 16; s++) 
				gpaddr->gp_shift = 0xffff;
		}
		addr  = gpwcs + words;
		*addr = (short) 0xffff;
	}
	verify ();
	zap ();
}

verify ()
{ 
	int words, i, s, data, errors;
	unsigned short *addr;

	errors = 0;
	for (words = 0; words <= (uc_words/4)-1; words++) {
		addr  = gpwcs + words;
		if (*addr);
		for (s = 1; s <= 16; s++) /* skip over uc address */
			gpaddr->gp_shift = 0xffff;
		for (i= words*4 + 3; i >= words*4; i--) {
			for (s = 1; s <= 16; s++) 
				gpaddr->gp_shift = 0xffff;
			data = gpaddr->gp_snake;
			if (data != uc_data[i])
				errors++;
		}
	}
	if (errors != 0) {
		gptype &= ~GPHASGIP;
		printf ("gp: microcode verify failed %d.\n",errors);
	}
}

#else LOAD_WCS

load_wcs()
{
	zap();		/* reset the gip board */
}
#endif LOAD_WCS

zap()
{
	if (gptype & GPCOLOR)
		load_lookup();
}

load_lookup()
{
	LoadGlobalLUT( 0,  0,  0,  0);		/* black */
	LoadGlobalLUT( 1, 15, 15, 15);		/* white */
	LoadGlobalLUT( 2, 11, 11, 11);		/* gray50 */

	LoadGlobalLUT( 3,  9,  9,  9);		/* gray25 */
	LoadGlobalLUT( 4, 13, 13, 13);		/* gray75 */
	LoadGlobalLUT( 5,  8,  8,  8);		/* gray12 */
	LoadGlobalLUT( 6, 14, 14, 14);		/* gray87 */
	LoadGlobalLUT( 7, 10, 10, 10);		/* gray37 */
	LoadGlobalLUT( 8, 12, 12, 12);		/* gray62 */

	LoadGlobalLUT( 9, 15,  0,  0);		/* RED */
	LoadGlobalLUT(10,  0, 15,  0);		/* GREEN */
	LoadGlobalLUT(11,  0,  0, 15);		/* BLUE */
	LoadGlobalLUT(12, 15,  5,  5);		/* Red */
	LoadGlobalLUT(13,  5, 15,  5);		/* Green */
	LoadGlobalLUT(14,  5,  5, 15);		/* Blue */
	LoadGlobalLUT(15, 15, 10, 10);		/* red */
}
