#include "./h/graphics.h"

typedef struct {
	short	width;		/* width in bytes of a display line */
	char	*address;	/* virtual address of raster */
	char	*eod_address;	/* EXTENDED end of display memory */
	char	*eov_address;	/* EXTENDED end of visable memory */
} ERASTER;

extern ERASTER screen;		/* defined in raster/screen.s */
extern ERASTER screen0;
extern ERASTER screen1;
extern ERASTER screen2;
extern ERASTER screen3;

extern short cliplx, clipux, cliply, clipuy;
int offscreen_off = 0;
int offscreen_len = 0;

InitializeVT(bxmax, bymax, videom, size)
	int bxmax;		/* visiable width of screen in bits */
	int bymax;		/* visiable height of screen in bits */
	char *videom;		/* pointer to viedo memory */
	int size;		/* total size of display memory */
{
	offscreen_off = (bxmax*bymax)/8;
	offscreen_len = 0;

	/* patch screen size information in graphics/sscreen.s */
	SCREENX = 0;
	SCREENY = 0;
	SCREENW	= bxmax;
	SCREENH = bymax;

	/* patch screen size information in raster/screen.s */
	screen0.width = bxmax/8;
	screen0.address = videom;
	screen0.eod_address = screen0.address + size;
	screen0.eov_address = screen0.address + offscreen_off;

	screen1.width = screen0.width;
	screen1.address = screen0.eod_address;
	screen1.eod_address = screen1.address + size;
	screen1.eov_address = screen1.address + offscreen_off;

	screen2.width = screen1.width;
	screen2.address = screen1.eod_address;
	screen2.eod_address = screen2.address + size;
	screen2.eov_address = screen2.address + offscreen_off;

	screen3.width = screen2.width;
	screen3.address = screen2.eod_address;
	screen3.eod_address = screen3.address + size;
	screen3.eov_address = screen3.address + offscreen_off;

	/* patch cliping information in raster/bounds.s */
	cliplx = 0; clipux = bxmax;
	cliply = 0; clipuy = bymax;

	gpget();
	InitializeBlock();
	InitializeCursor();
	InitializeWindow();
	gpgive();
}

TerminateVT()
{
}
