#ifndef _VT_PARAM
#define _VT_PARAM

#ifdef	KERNEL
extern char * 	vtpool;	    /* pointer to freespace pool, vt_space.c */
#endif	KERNEL
/*
 *	Different defines needed for virtual terminals
 */
  
#define	    NVT	    17	    /* Number of virtaul terminals allowed */
#define     NCOLOR  16	    /* Number of system loaded colors, 9 predefined */
#define	    NISTYLES 64	    /* Number of unique icon styles  */
#define	    NICON   128	    /* Number of system loaded icons, 9 predefined  */
#define	    ACTSIZ  32	    /* Size of an action table in bytes */
			    /* Size of freespace pool for screen display    */
#define     VTSIZE  ((1024*24)+(NVT*4096))
#define	    NNOTE   8	    /* Number of notes in a vt */

/*
 *	The following are translation table names
 */
#define	    NORMAL	0	/* regular table number */
#define	    SHIFT	1	/* shift table number  */
#define	    CTRLT	2	/* control table number  */
#define	    CTRLSHFT	3	/* shifted control table number */

/*
 * different defines used with the translation tables
 */
#define	    BADCODE 0xff	/* illegal code, do not use	            */

#endif
