#include "types.h"
#include "../vt/vt_hdrs.h"
#include "../vt/vt_kernel.h"
#include "../vt/vt_key.h"

/*
 * Routines to handle mouse and keyboard input from the serial I/O drivers
 */

#define LEFT_BUTTON	0x4
#define MID_BUTTON	0x2
#define RIGHT_BUTTON	0x1

#define NPANES		10
#define IBUTTONS	(VT_MOUSE_RIGHT|VT_MOUSE_LEFT|VT_MOUSE_MIDDLE)

extern int	  	mactive, kactive;
extern struct tty	vt_tty[];
extern char	  	mousetab[];
extern struct popquiz	popquiz;
extern struct trackcursor trackcursor;
extern char		flushmouseok;
extern char		flushvtok;
extern char		markneeded;
extern struct mark	vt_marks[];

char			msbuf[5];	/* mouse input buffer */
int			mscnt = 0;	/* count of mouse bytes */
int			mscnt_err = 0;	/* count of mouse bytes out of sync */
int			mousestate = IBUTTONS;
short			minx, miny, maxx, maxy, mousex, mousey;

/*
 * Take the next input character from the mouse input routine for workstation 
 * mouse line discipline
 */
vtmouse(c, tp)
    register int 		c;
    struct tty			*tp;
{
    register int 		buttons = 0;
    register int 		cnt = mscnt;	

    if (cnt == 0) {
	/* 
	 * See if its a start of valid mouse seq, this will not always
	 * synchronize correctly if input characters are dropped, the result
	 * being a jumpy mouse.
	 */
	if ((c&0xF8) == 0x80) {
	    if (c & LEFT_BUTTON)
		buttons |= VT_MOUSE_LEFT;
	    if (c & MID_BUTTON)
		buttons |= VT_MOUSE_MIDDLE;
	    if (c & RIGHT_BUTTON)
		buttons |= VT_MOUSE_RIGHT;
	    msbuf[cnt++] = buttons;
	} else
	    mscnt_err++; 			/* not a good start */
    } else {
#ifdef SAVE_EVENT
	if ((c&0xF8) == 0x80) {	/* lost a byte */
	    mscnt_err++;
	    vtmousein(0, 0, msbuf[0]);
	    cnt = 0;
	    if (c & LEFT_BUTTON)
		buttons |= VT_MOUSE_LEFT;
	    if (c & MID_BUTTON)
		buttons |= VT_MOUSE_MIDDLE;
	    if (c & RIGHT_BUTTON)
		buttons |= VT_MOUSE_RIGHT;
	    msbuf[cnt++] = buttons;
	} else {
#endif SAVE_EVENT
	msbuf[cnt++] = c;
	if (cnt == 3)
	    	vtmousein(msbuf[0], msbuf[1], msbuf[2]);
	else if (cnt >= 5) {
	    	vtmousein(msbuf[0], msbuf[3], msbuf[4]);
		cnt = 0;
	}
#ifdef SAVE_EVENT
	}
#endif SAVE_EVENT
    }
    mscnt = cnt;
}

vtmousein(buttons,mx,my)
    register short	buttons;
    register short	mx;		/* mouse x increment */
    register short	my;		/* mouse y increment */
{
    register unsigned char  mflag;  /* flag for negative velocity */

    /* Check for the stupid case (no change in position or buttons!) */
    if (mx || my) {
	/* Scale the mouse input according to mousetab */
	if (mx < 0) { 
	    mflag = 1; mx = -mx;
	} else
	    mflag = 0;
	if (mx > VT_MTABSIZE) {
	    if (mousetab[VT_MTABSIZE] != 0 && mx > mousetab[VT_MTABSIZE]) 
		mx = mx * mousetab[VT_MTABSIZE];
	} else
	    mx = mousetab[mx];
	if (mflag) 
	    mx = -mx;
	if (my < 0) { 
	    mflag = 1; 
	    my = -my;
	} else
	    mflag = 0;
	if (my > VT_MTABSIZE) {
	    if (mousetab[VT_MTABSIZE] != 0 && my > mousetab[VT_MTABSIZE]) 
		my = my * mousetab[VT_MTABSIZE];
	} else
	    my = mousetab[my];
	if (mflag) 
	    my = -my;

	/* Set current mouse position */
	mousex += mx;
	mousey -= my;

	/* Clip the mouse if needed */
	if (mousex < minx) 
	    mousex = minx;
	if (mousey < miny) 
	    mousey = miny;
	if (mousex > maxx) 
	    mousex = maxx;
	if (mousey > maxy) 
	    mousey = maxy;

    	/* wake up type ahead daemon to move the cursor */
	flushvtok = 1;
	flushmouseok = 1;
	wakeup((caddr_t)&flushvtok);
    }

    /* Send mouse information to the correct window */
    vtsendmouse( buttons, mousex, mousey);
}

/* Send mouse reports to the correct keyboard driver */
vtsendmouse(buttons, x, y)
    register short	buttons;
    register short	x;		/* mouse x position */
    register short	y;		/* mouse y position */
{
    register struct tty    *vp;
    int 		   *window;
    int			   relx, rely, pane, w;
    short		   change;
    register int	   s;

    change = buttons ^ mousestate;

    if ((int)popquiz.win > 1) {
	if (change)
	    wakeup((caddr_t)&popquiz.buttons);
	goto out;
    } else if (trackcursor.type) {
	if (change)
	    wakeup((caddr_t)&trackcursor.thickness);
	goto out;
    }

    if (!change) {
	change |= VT_MOUSE_NOBUTTON;
	buttons |= VT_MOUSE_NOBUTTON;
    }
    
    vp = &vt_tty[w = mactive];
    if (WithinWindow( vp->v_win, x, y)) {	/* inside mouse-active window */
	if (WithinPane(vp->v_win, DISPLAY, x, y))
	    pane=DISPLAY;
	else {
	    for (pane = 0; pane < NPANES; pane++)
		if (WithinPane(vp->v_win, pane, x, y))
		    break;
	    if (pane == NPANES) 
		    pane = DISPLAY;
	    vp = &vt_tty[0];
	}
    } else {					/* inside some other window  */
	vp = &vt_tty[0];			/* pass info to desktop proc */
	ContainingPane( x, y, &window, &pane);
	if (pane < 0) 
	    pane = DISPLAY;
	for (w=0; w<NVT+1; w++)
	    if (vt_tty[w].v_win == window) 
		break;
    }
    SetActiveCursor(vp->v_win);
    MapCoordinates(vp->v_win, DISPLAY, x, y, &relx, &rely);

    if (change & vp->v_mmask)
	(*keybsw[vp->v_te].k_mouse)
		(vp->v_keyb, buttons, (w<<8)|pane, relx, rely);
out:mousestate = buttons & 7;
    return;
}

/* Input routine for workstation keyboard line discipline, ignore input if not open */
vtkeyboard(c, tp)
    unsigned char c;
    struct tty *tp;
{
    register struct tty *vp = &vt_tty[kactive];
  
    if (vp->t_state & TS_ISOPEN) {
	if (vt_marks[kactive].req&MARKING) {
	    vt_marks[kactive].req |= CANCEL;
	    markneeded = 1;
	    wakeup((caddr_t)&markneeded);
	}
	(*keybsw[vp->v_te].k_keyin)(vp->v_keyb, c);
    }
}
