
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* #ident	"@(#)kern-port:sys/signal.h	10.9" /* */

#ifndef	KERNEL

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (ASCII FS) */
#define	SIGILL	4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define SIGABRT 6	/* used by abort, replace SIGIOT in the  future */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#endif	KERNEL
#ifdef	KERNEL
#define	SIGUSR1_SV	16	/* user defined signal 1 */
#define	SIGUSR2_SV	17	/* user defined signal 2 */
#define	SIGCLD_SV	18	/* death of a child */
#else	KERNEL
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#endif	KERNEL
#define	SIGPWR	19	/* power-fail restart */

			/* SIGWIND and SIGPHONE only used in UNIX/PC */
/*#define SIGWIND 20*/	/* window change */
/*#define SIGPHONE 21*/	/* handset, line status change */

#define SIGPOLL 22	/* pollable event occured */

#ifdef	KERNEL
#define	NSIG_SV	23	/* The valid signal number is from 1 to NSIG-1 */
#else	KERNEL
#define	NSIG	23	/* The valid signal number is from 1 to NSIG-1 */
#define MAXSIG	32	/* size of u_signal[], NSIG-1 <= MAXSIG*/
			/* MAXSIG is larger than we need now. */
			/* In the future, we can add more signal */
			/* number without changing user.h */
#endif	KERNEL

#if lint
#define SIG_ERR (int(*)())0
#else
#define SIG_ERR	(int(*)())-1
#endif
#ifndef	SIG_DFL
#define	SIG_DFL	(int(*)())0
#endif
#if lint
#define	SIG_IGN	(int (*)())0
#else
#ifndef	SIG_IGN
#define	SIG_IGN	(int (*)())1
#endif
#endif
#if lint
#define SIG_HOLD (int(*)())0
#else
#ifdef	KERNEL
#define SIG_HOLD_SV (int(*)())2
		/* SOME DAY IT SHOULD BECOME void */
#else	KERNEL
#define SIG_HOLD (int(*)())2
#endif	KERNEL
#endif

/* The following definitions are only used by kernel */
#ifdef	KERNEL
#define SIGNO_MASK	0xff
#define SIGDEFER	0x100
#define SIGHOLD		0x200
#define SIGRELSE	0x400
#define SIGIGNORE	0x800
#define SIGPAUSE	0x1000
/*
 * A mask for signals which don't get reset while switching universes
 */
#define SIG_ACROSS	(0x7f) 	/* upto SIGTERM */
#else	KERNEL
/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

#endif	KERNEL
