/*
 *	For RFS to Ethernet
 *		5/5/87
 */


#define	RFSNET_MAXTSDUSIZE 4096		/* max TSDU size         */
#define	RFSNET_MAXETSDUSIZE 4096	/* max ETSDU size        */
#define	RFSNET_MAXCDATASIZE -2		/* max connect data size */
#define	RFSNET_MAXDDATASIZE -2		/* max discon data size  */
#define	RFSNET_MAXADDRSIZE 8		/* address size, basically two ints */
#define	RFSNET_MAXOPTSIZE -2		/* options size not supported */
#define	RFSNET_MAXTIDUSIZE 4096		/* max TIDU size         */
#define	RFSNET_SERVTYPE	T_COTS_ORD	/* provider service type */

struct rfsnet {
	int	lup_flags;
	uint	lup_state;	/* TI state */
	uint	lup_baddr[2];	/* address that is bound */
	uint	lup_daddr[2];	/* dest. address */
#define	NETADDR		0
#define	PORTADDR	1
	int	lup_qlen;	/* #of outstanding connects */
	int	lup_aqlen;	/* #of outstanding connects allowed */
	queue_t	*qptr;		/* back ptr to write queue */
	struct ifnet *lup_ifp;	/* pointer to output interface */
	struct arpcom *lup_ac;	/* pointer to Ethernet common part */
	int	lup_seq;	/* packet sequence number */
	int	lup_rseq;	/* drop duplicate incomming packets */
	int	lup_retry;	/* retry count */
	mblk_t	*lup_m;		/* last mblk sent out waiting for ack */
};

/*
 * Header packet that is attached to all out going messages.  This enables
 * the other side to now which port and the length of the incomming message.
 */
struct rfs_net_pkt {
    int port;
    int len;			/* len, last packet and ack */
    char type;			/* type of mblk */
    int seq;			/* sequence number of packet */
				/* valid only for the first one of chain */
};

#define RNLAST -1		/* indicates last packet */
#define RNACK -2		/* This packet is an ack */
#define RN_RETRIES 5		/* number of retries before giving up */

/*
 * XXX This may not be a good idea.  The user level code treats the address
 * as a string of bytes.  I know that it's two words, first the net address,
 * then the port number.  The way the address is interpolated seems to be
 * up to the driver.
 */
struct rfs_addr {
    unsigned addr;
    int port;
};

/*
 * When a T_CONN_IND is issued, the server must store the sources net
 * address, port number and sequence number.  The server will the create
 * a new stream and send a T_CONN_CON back giving the driver the same
 * sequence number which it can then find the client's destination address.
 */
struct rfs_net_match {
    unsigned addr;
    int port;
    int SEQ_number;
};

/* Minimum and Maximum port numbers when the provider has to search
 * for an address for binding. These two numbers just random choice.
 * May either change later or disappear altogether.
 */
#define	RFSNET_MINPORTNO	10
#define	RFSNET_MAXPORTNO	1024

/* flags */
#define	RFSNET_INUSE		0x00000001
#define	RFSNET_CHST		0x00000002
#define	RFSNET_BOUND		0x00000004
#define	RFSNET_CONNECTED	0x00000008
#define	RFSNET_DISCONNECTED	0x00000010
#define RFSNET_INPROGRES	0x00000020 /* packet is outbound on this
					    * queue hold all other requests
					    * until ack is received.
					    */
#define RFSNET_WANTED		0x00000040
#define RFSNET_CLOSING		0x00000080 /* close in progress, flushing */

#define	MAX_REPLYSIZ	(sizeof(union T_primitives)+RFSNET_MAXADDRSIZE)
				/* As options are unsupported */
#define	makerr(x,y)	((x<<16)|y)
#define	RFSNET_SLP		(PZERO+2)	/* Priority for sleeping */

#define IS_LOCKED(rn) \
	(rn->lup_flags & RFSNET_INPROGRES)

#define LOCK_OUTBOUND(rn) \
{ \
    register int s = splimp(); \
    if (rn->lup_flags & RFSNET_INPROGRES) { \
	splx(s); \
	return (1); \
    } \
    rn->lup_flags |= RFSNET_INPROGRES; \
    splx(s); \
}
	
#define UNLOCK_OUTBOUND(rn) \
{ \
    register int s = splimp(); \
    rn->lup_flags &= ~RFSNET_INPROGRES; \
    if (rn->qptr) \
	qenable (rn->qptr); \
    if (rn->lup_flags & RFSNET_CLOSING) { \
    	rn->lup_flags &= ~RFSNET_CLOSING; \
	wakeup (&rn->lup_flags); \
    } \
    splx (s); \
}  

/*
 * Debuging info
 */
#define RN_DEBUG
#ifndef RN_DEBUG
#define RfsNetDeubg(x) ;
#endif

#define RN_G	0x00000001	/* general info during open, close, ...etc */
#define RN_I	0x00000002	/* net_to_rfs specific */
#define RN_O	0x00000004	/* rfs_to_net specific */
#define RN_C	0x00000008	/* client side */
#define RN_S	0x00000010	/* server side */
#define RN_NOISE 0x00000020	/* printf's not generally useful */
#define RN_ERR	0x00000040	/* error messages */
#define RN_ACK	0x00000080	/* show ack packets */
#define RN_WARN	0x00000100	/* non-fatal problems */
#define RN_ALL	0xffffffff	/* all possible levels */
