/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
#ident	"@(#)kern-port:sys/region.h	10.5"
*/

/*
 * There are two types of region, sharable and private.
 * The sharable region is so much similar to the BSD shared 
 * text region, such that it is described by struct text.
 * The private region is a new concept, it is defined by
 * the following structure.
 *
 * Per private region descriptor.  One is allocated for
 * every active private region in the system.
 */

typedef	struct	region	{
	struct region  *r_forw;	/* forward link */
	struct region  *r_back;	/* backward link */
	struct vnode   *r_vptr;	/* vnode of prototype */
	short	r_pgsz;		/* size in pages */
	swblk_t	r_ptdaddr;	/* disk address of page table */
	struct dmap r_dmap;	/* region swap map */
} reg_t;


/*	
 *	A region list is a contiguous array of pregions.
 *	Each pregion describes the
 *	region which is attached to the process.
 */

typedef struct pregion {
	struct pregion  *p_forw;	/* forward link */
	struct pregion  *p_back;	/* backward link */
	union {
		struct text	*pr_ps;	/* pointer to shared region	*/
		struct region	*pr_pp;	/* pointer to private region	*/
	} p_un;
	struct pregion	*p_xlink;	/* link to shared pregions	*/
	struct proc	*p_procp;	/* pointer to owning proc	*/
	caddr_t 	p_regva;	/* User virtual address of	*/
					/* region.			*/
	struct pte	*p_pte;		/* pointer to region page table */
	short		p_type;		/* Type.			*/
	short 		p_flags;	/* flags			*/
} preg_t;
					/* process including null one.	*/
#define p_ps	p_un.pr_ps
#define p_pp	p_un.pr_pp


/*	Pregion flags.
 */

#define	PF_RDONLY	0x0001		/* Read-only attach.		*/

/*	Pregion types.
 */

#define	PT_UNUSED	0x00		/* Unused region.		*/
#define	PT_SHMEM	0x04		/* Shared memory region.	*/
#define	PT_LIBTXT	0x06		/* Shared library text region.	*/
#define	PT_LIBDAT	0x07		/* Shared library data region.	*/

extern preg_t	*pregion;		/* Global array of pregions */
extern preg_t	nullpregion;		/* A null preg_t. */
extern preg_t	prfree;			/* List of free pregions list */
extern int	pregpp;			/* Number of pregions per	*/
extern reg_t	*region;		/* Global array of regions */
extern reg_t	nullregion;		/* A null region. */
extern reg_t	rfree;			/* List of free regions */
extern int	nregion;		/* total number of regions */
extern int	npregion;		/* total number of pregions */
extern int	nprocsh;		/* number of process using shared */
					/* memory or libraries		  */

reg_t		*reg_alloc();		/* allocate a region */
void		reg_free();		/* free a region */
preg_t		*preg_alloc();		/* allocate a pregion list */
void		preg_free();		/* free a pregion list */
preg_t		*preg_attachreg();	/* attach a region to a process */
preg_t		*preg_vtopreg();	/* page to pregion */
preg_t		*preg_fork();		/* fork the parent's pregion */
preg_t		*preg_ptetopreg();	/* pte to pregion */

#define	SOFFMASK	0x0001ffff	/* segment(region) offset mask */
