/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:sys/mount.h	10.10"		*/
/*
 *	Rfsmount structure.
 *	One allocated on every remote mount.
 */

#ifdef	KERNEL
#ifndef	SYSV_DIRSIZ
#define SYSV_DIRSIZ	14
#endif
#define	NMSZ	SYSV_DIRSIZ + 1		/* size of advertised name */
#else	/* KERNEL */
#ifndef DIRSIZ				/* REMOTE */
#define DIRSIZ	14
#endif
#define	NMSZ	DIRSIZ + 1		/* size of advertised name */
#endif	/* KERNEL */

struct	rfsmount	{
	struct vfs	*m_vfsp;	/* vfs structure for this filesystem */
	dev_t		m_dev;		/* device mounted */
	struct vnode	*m_rfsvp;	/* vnode for rfs mounted */
	ushort	m_flags;		/* status */
	char	m_rflags;		/* set to MLBIN for mount remotely  */
	char	*m_name;		/* name advertised resource */
};

#define	VFSTORFS(vfsp)	VTORFS((((struct rfsmount *)vfsp->vfs_data)->m_rfsvp))
#ifdef KERNEL
/*
 * mount table
 */
extern struct rfsmount	rfsmount[];
extern int	nrfsmount;

struct vnode *makerfsnode();
#endif	KERNEL

/* alloction flags (m_flags) */

#ifdef	MFREE
#undef	MFREE		/* If defined by mbuf.h */
#endif
#define	MFREE	0x0	/* Unused - free */
#define	MINUSE	0x1	/* In use - fs mounted on this entry */
#define	MINTER	0x2	/* Mount system call is using this entry */
#define	MRDONLY	0x4	/* File system is mounted read only */

#define	rdonlyfs(mp)	(((mp)->m_flags & MRDONLY) || (server() \
				&& (srmount[u.u_mntindx].sr_flags & MRDONLY)))

/* remoteness flags (m_rflags) */
/* (or'ed with m_flags in srmount, so must use different bits) */

#define MLBIN      0x10
#define MDOTDOT    0x20
#define MFUMOUNT   0x40
#define MLINKDOWN  0x80

/* Flag bits passed to the mount system call */
#define	MS_RDONLY	0x1	/* read only bit */
#define MS_FSS		0x2	/* FSS (4-argument) mount */

/* Server mount structure. Holds:
 *	1. DOT-DOT
 *	2. LBIN
 * connections.
 *
 * Search the table looking for (sysid, rootinode) pair.
 */

 struct srmnt {
	sysid_t sr_sysid;
	char    sr_flags;
	struct vnode *sr_rootvnode;	/* inode on server's machine */
	int     sr_mntindx;		/* mount index of requestor  */
	int 	sr_refcnt;		/* number of open files      */
	int	sr_dotdot;		/* for lbin mount, so .. works */
	long	sr_bcount;
	int	sr_slpcnt;
} ;
extern struct srmnt srmount[];

/* Return values if crossing mount point */
 
#define DOT_DOT	0x1
#define LBIN	0x2
/*	#define MRDONLY	0x4	*/
