/*
static char SCCSID[] = "@(#)fp.h	2.1	";
*/
/*
 *	parameters of the implementation
 */
#define EXPSIZE 8
#define EXPOFFSET ((1 << (EXPSIZE - 1)) - 2)
#define INFEXP ((1 << EXPSIZE) - 1)
#define MAXEXP ((1 << EXPSIZE) - 2)
#define FRACSIZE 23
#define HIDDENBIT 0x00800000L
#define CARRYBIT (HIDDENBIT << (GBITS + 1))
#define GBITS 2
#define NORMMASK 0xfe000000L

/*
 *	macros to pick pieces out of long integers
 *	this must change if FRACSIZE changes
 *	presently we assume two 12-bit pieces
 */
#define CHUNK 12
#define lmul(x,y) ((long) (x) * (long) (y))
#define lo(x) ((x) & 0xfff)
#define hi(x) ((x) >> CHUNK)
#define hibit(x) (((short)(x) >> (CHUNK - 1)) & 1)

struct fpnum {
	unsigned sign:1;
	unsigned exp:EXPSIZE;
	long unsigned frac:FRACSIZE;
};

typedef struct fpnum fp;

static fp zero;
static fp infinity = {0, ~0, 0};

/* These redefinition macros are due to the fact that C compilers return
 * structures from functions in incompatible ways. This code assumes that
 * C structures of longword size are returned by value through the 
 * compilers temporary data registers. Some compilers, however [like ours] 
 * return these structures by reference through the temporary
 * registers causing the return values of these routines (which are 
 * address') to be mis-interpreted as single prec. floating point values. 
 * The macros used here should give future ports the flexibility to adapt 
 * to either compiler approach while localizing changes to this file.
 * Note: These macros assume that the integer return values of functions
 *       are the same size as IEEE single precision floating pt values. 
 * BCN 02/88
 */
#ifdef	is68k

#define FP	int
#define RETURN(x)	return (*((int *)&(x)))

#else 

#define FP   	fp
#define RETURN(x)	return(x)

#endif	is68k

/* This storage class should be used to recieve fpnum data from a routine
 * that returns type FP where the resulting type cannot be assumed (or cast) 
 * to be an longword type.
 */ 
union fpconv {		
    fp fp;		/* IEEE single precision floating pt. data type */
    FP conv;		/* longword received from FP function(); */
};
typedef union fpconv FPconv;

FP fladd(), flsub(), flmul(), fldiv(), flneg(), fp_addmag(), fp_submag();
FP itof(), uitof(), ultof(), ltof();
