#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "../h/types.h"
#include "../h/param.h"
#include "../h/user.h"
#include "../h/reboot.h"
#undef	NFS
#include "../h/mount.h"
#include "../h/buf.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/inode.h"
#include "../ufs/mount.h"
#include "../ufs/fs.h"

#include "../machine/machparam.h" /* resolves hibyte for use in ustat below */

#include "../sysv/sys/statfs.h"
#include "../sysv/sys/ustat.h"
#include "../sysv/sys/utsname.h"
#include "../sysv/sys/uadmin.h"
#include "../sysv/sys/stream.h"	/* used to resolve refrences in cirmgr.h */
#include "../sysv/sys/nserve.h"	/* used to resolve MAXDNAME used in cirmgr.h */
#include "../sysv/sys/cirmgr.h"	/* used to define struct gdp and GDPDIS */

utssys(uap)
	register struct a {
		char	*cbuf;
		int	mv;
		int	type;
	} *uap;
{
	struct ustat ust;
	struct sysv_statfs stfs;
	extern char hostname[];

	switch (uap->type) {
	case 0:		/* uname */
		{	register int i;

		for(i = 0; i < (sizeof(utsname.nodename)-1); i++)
			utsname.nodename[i] = hostname[i];
		utsname.nodename[i] = '\0';
		u.u_error =  copyout(&utsname, uap->cbuf,
		  sizeof(struct utsname));
		return;
		}

	/* case 1 was umask */

	case 2: {		/* ustat */
#ifdef RFS
		register int trouble;
		extern struct gdp gdp[];
		extern int maxgdp;

		if (uap->mv < 0) {
			/*
			 * what happens if NFS mount point maps into this
			 * RFS structure.  You get the wrong information.
			 */
			trouble = ~hibyte(uap->mv) & 0xff;
			if (trouble < maxgdp &&
			    (gdp[trouble].flag & GDPCONNECT)) {
				duustat(); /* only returns if error */
				return;
			}
		}
#endif RFS
		ustat1(uap->mv, uap->cbuf);
		return;
	}
	default:
		u.u_error = EFAULT;
	}
}

ustat1(dev, buf)
int dev;
char *buf;
{
	register struct a {
		int	dev;
		char *buf;
	} ua;

	ua.dev = dev;
	ua.buf = buf;
	
	u.u_ap = (int *) &ua;
	ustat(u.u_ap);
}


/*
 * administrivia system call
 */

uadmin()
{
	register struct a {
		int	cmd;
		int	fcn;
		int	mdep;
	} *uap;
	static ualock;

	if (ualock || !suser())
		return;
	ualock = 1;
	uap = (struct a *)u.u_ap;
	switch (uap->cmd) {

	case A_SHUTDOWN:
	case A_REBOOT:
		boot(RB_BOOT, (uap->fcn == AD_HALT)? RB_HALT : 0);
		break;

	case A_REMOUNT:
	default:
		u.u_error = EINVAL;
	}
	ualock = 0;
}

#endif	SYSV
