/* Copyright (c) 1984 AT&T	 */
/* All Rights Reserved  	 */

/* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	 */
/* The copyright notice above does not evidence any   	 */
/* actual or intended publication of such source code.	 */

/* #ident	"@(#)kern-port:nudnix/serve.c	10.45"		 */
#if	defined(SYSV) && defined(RFS)
/*
 * JAMES - remote file server for unix 
 *
 * JAMES is a kernel daemon process that handles requests for file activity from
 * remote unix systems. 
 *
 */

#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../h/param.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/stream.h"
#include "../sysv/sys/comm.h"
#include "../h/user.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/cirmgr.h"
#include "../sysv/sys/message.h"
#include "../h/proc.h"
#include "../h/vnode.h"
#include "../h/vfs.h"
#include "../h/file.h"
#include "../h/pathname.h"
#include "../sysv/sys/stat.h"
#include "../h/stat.h"
#include "../sysv/sys/sysinfo.h"
#include "../sysv/sys/idtab.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/recover.h"
#include "../sysv/sys/signal.h"
#include "../sysv/sys/mount.h"
#include "../ufs/inode.h"
#include "../ufs/mount.h"
#include "../sysv/sys/sysmacros.h"
#include "../sysv/sys/que.h"

#define TERMSIG	(1L << (SIGTERM-1))
#define USR1SIG	(1L << (SIGUSR1_SV-1))

int             currserv;		/* current number of servers running */

extern rcvd_t   cr_rcvd ();
extern struct rd_user *cr_rduser ();
extern struct timeval time;
extern int      msgflag;
extern rcvd_t   rd_recover;
void
rm_msgs_list (), chkrsig ();

serve ()
{
    rcvd_t          de_queue ();
    rcvd_t          slbmount ();
    rcvd_t          make_gift (), setrsig ();
    rcvd_t          gift;		/* what the requestor wanted	 */
    rcvd_t          queue;		/* receive descriptor msg arrived on	 */
    register struct request *msg_in;
    register struct response *msg_out;
    register struct sndd *sdp;		/* reply path back to requestor	 */
    register struct gdp *gdpp;
    register struct vnode *vp;
    int             insize, outsize;	/* size of out/incoming msg		 */
    register int    ret_val;		/* general ret val		 */
    int             ocount;		/* save incoming u.u_count	 */
    int             i;			/* temporary variable		 */
    int             bcount;		/* Read, write block count */
    int             s;
    mblk_t         *bp, *nbp, *sbp, *chkrdq ();
    queue_t        *qp;
    struct message *msig;

    extern rcvd_t   nsqueue;
    extern struct proc *s_active;	/* server active list */
    extern lock_t   procslock;
    extern rcvd_t   srmnt ();

    /* ignore all signals except SIGKILL and SIGTERM */
    for (i = 0; i < NSIG; i++)
	u.u_signal[i] = SIG_IGN;
    u.u_signal[SIGKILL] = 0;
    u.u_signal[SIGTERM] = 0;
    u.u_signal[SIGUSR1] = 0;
#ifdef DEBUG
    /***	clrilocks();	***/
#endif
    if ((sdp = cr_sndd ()) == NULL) {
	if (s_active)
	    psignal (s_active, SIGUSR1);
	u.u_gift = NULL;
	idleserver++;
	serve_exit ();
    }
    strcpy (u.u_comm, "server");	/* was originally copied to
					 * u.u_psargs */
    u.u_cred = crdup (u.u_cred);

    while (TRUE) {
	/***	ASSERT(noilocks() == 0);	***/
	strcpy (u.u_comm, "server");
	sdp->sd_queue = NULL;
	sdp->sd_stat = (SDUSED | SDSERVE);
	sdp->sd_srvproc = NULL;
	u.u_gift = sdp;			/* for copyin (write, ioctl) */
	u.u_procp->p_sig &= ~(USR1SIG | TERMSIG);
	idleserver++;
	if ((queue = de_queue ((rcvd_t) ANY, &bp, sdp, &insize)) == (rcvd_t) NULL) {
	    /***	ASSERT(noilocks() == 0);	***/
	    serve_exit ();
	}
	u.u_procp->p_rrlink = s_active;
	s_active = u.u_procp;
	msig = (struct message *) bp->b_rptr;
	u.u_procp->p_sig = u.u_procp->p_cursig = 0;
	idleserver--;
	if (++currserv > (maxserve - 1))/* last server can't sleep */
	    u.u_procp->p_sig |= USR1SIG;
	else if (idleserver == 0) {
	    s = spl5 ();
	    msgflag |= MORE_SERVE;
	    splx (s);
	    wakeup ((caddr_t) & rd_recover->rd_qslp);
	}
psmsg:
	msg_in = (struct request *) PTOMSG (msig);

	strcpy (u.u_comm, "server");
	sysinfo.serve++;
	gift = NULL;
	ret_val = 0;
	/*
	 * set up u area for syscall just like in real syscall () 
	 */
	u.u_procp->p_epid = msg_in->rq_pid;
	/* set sysid to index of stream where message came from */
	qp = (queue_t *) msig->m_queue;
	gdpp = GDP (qp);
	if (gdpp->sysid == 0) {
	    printf ("Invalid sysid for incomming packet\n");
	    gdpp->sysid = 13;	/* bogus */
	}
	u.u_procp->p_sysid = gdpp->sysid;
	u.u_uid = gluid (gdpp, msg_in->rq_uid);
	u.u_gid = glgid (gdpp, msg_in->rq_gid);
	u.u_groups[0] = u.u_gid;
	u.u_groups[1] = NOGROUP;

	u.u_mntindx = msg_in->rq_mntindx;	/* for nami stuff */
	u.u_arg[0] = (int) msg_in->rq_data;	/* pathname in data part */
	u.u_rfspnp = (struct pathname *) NULL;
	u.u_ap = u.u_arg;
	u.u_error = 0;
	u.u_r.r_val1 = 0;
	u.u_gift->sd_copycnt = 0;
	u.u_copymsg = 0;
	u.u_procp->p_systemcall = msg_in->rq_opcode;
	u.u_rlimit[RLIMIT_FSIZE].rlim_max =
	  u.u_rlimit[RLIMIT_FSIZE].rlim_cur =
	  u.u_rlimit[RLIMIT_CORE].rlim_max =
	  u.u_rlimit[RLIMIT_CORE].rlim_cur = (msg_in->rq_ulimit) << 9;
	u.u_rflags = 0;

	/* fail request if resource is in funny state - e.g., in fumount */
	if (u.u_procp->p_systemcall != DUSRMOUNT) {
	    if (srmount[u.u_mntindx].sr_flags & MINTER) {
		freemsg (bp);
		rmactive (u.u_procp);
		DUPRINT1 (DB_RECOVER, "request for MINTER resource \n");
		continue;
	    }
	    /* following two sd fields used by recovery/fumount */
	    sdp->sd_mntindx = u.u_mntindx;
	    sdp->sd_srvproc = u.u_procp;
	}

	dinfo.isyscall++;		/* incoming system calls */
	sysinfo.syscall++;		/* total system calls */
	DUPRINT3 (DB_SYSCALL, "server: opcode %d (%s)\n",
		u.u_procp->p_systemcall, sysname (u.u_procp->p_systemcall));

	switch (u.u_procp->p_systemcall) {
	  case DUACCESS:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_fmode;
	    set_dir (msg_in, queue);
	    u.u_ruid = u.u_uid;
	    u.u_rgid = u.u_gid;
	    access (u.u_ap);
	    break;
	  case DUCHDIR:
	    {
		u.u_arg[0] = (int) msg_in->rq_data;
		set_dir (msg_in, queue);
		vp = u.u_cdir;
		VN_HOLD (vp);
		chdir (u.u_ap);
		if (!u.u_error) {
		    if (gift = make_gift (u.u_cdir, FILE_QSIZE, sdp))
			srmount[u.u_mntindx].sr_refcnt++;
		    else {
			VN_RELE (u.u_cdir);
		    }
		    u.u_cdir = NULL;
		}
		else {			/* locked above, release if failed  */
		    VN_RELE (vp);
		}
		break;
	    }
	  case DUCHMOD:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_fmode;
	    set_dir (msg_in, queue);
	    chmod (u.u_ap);
	    break;
	  case DUIUPDATE:
	    {
		struct vattr    vattr;

		vp = queue->rd_vnode;
		VN_HOLD (vp);
		vattr_null (&vattr);
		vattr.va_atime = vattr.va_mtime = time;
		if (vp->v_vfsp->vfs_flag & VFS_RDONLY)
		    u.u_error = EROFS;
		else
		    u.u_error = VOP_SETATTR (vp, &vattr, u.u_cred);
		VN_RELE (vp);
		break;
	    }
	  case DUUPDATE:
	    {
		register struct vfs *vfsp = queue->rd_vnode->v_vfsp;

		VFS_SYNC (vfsp);
		break;
	    }
	  case DUCHOWN:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = (int) gluid (gdpp,
				      msg_in->rq_newuid);
	    u.u_arg[2] = (int) glgid (gdpp,
				      msg_in->rq_newgid);
	    set_dir (msg_in, queue);
	    chown (u.u_ap);
	    break;
	  case DUCHROOT:
	    {
		u.u_arg[0] = (int) msg_in->rq_data;
		set_dir (msg_in, queue);
		if (vp = u.u_rdir) {
		    VN_HOLD (vp);
		}
		/*** need lock & unlock for AP ***/
		sysv_chroot (u.u_ap);
		if (!u.u_error) {
		    if (gift = make_gift (u.u_rdir, FILE_QSIZE, sdp))
			srmount[msg_in->rq_mntindx].sr_refcnt++;
		    else {
			VN_RELE (u.u_rdir);
		    }
		    u.u_rdir = NULL;
		}
		else if (vp) {
		    VN_RELE (vp);
		}
		break;
	    }
	  case DUIPUT:
	    {
		register struct srmnt *smp;

		dinfo.isyscall--;
		sysinfo.syscall--;
		if (queue->rd_qtype & RDLBIN) {
		    smp = &srmount[u.u_mntindx];
		    vp = smp->sr_rootvnode;
		    --srmount[smp->sr_dotdot].sr_refcnt;
		    slbumount (smp, vp);
		    del_rcvd (queue, sdp->sd_queue);
		    VN_RELE (vp);
		}
		else {
		    vp = queue->rd_vnode;
		    if (--srmount[msg_in->rq_mntindx].sr_refcnt == 0) {
			printf ("serve DUIPUT: free srmount entry\n");
			srmount[msg_in->rq_mntindx].sr_flags = MFREE;
		    }
		    del_rcvd (queue, sdp->sd_queue);
		    VN_RELE (vp);
		}
		break;
	    }
	  case DUCLOSE:
	    {
		register struct vnode *tvp;
		register int    flag;
		register enum vtype type;
		register dev_t  rdev;
		register struct file *ffp;
		struct flock    ld;

		queue = setrsig (msig, queue);
		vp = queue->rd_vnode;
		ld.l_type = F_UNLCK;	/* set to unlock entire file */
		ld.l_whence = 0;	/* unlock from start of file */
		ld.l_start = 0;
		ld.l_len = 0;		/* do entire file */
		(void) VOP_LOCKCTL (vp, &ld, F_SETLK, u.u_cred, 0);
		/* The following emulates vno_close */
		flag = msg_in->rq_mode;
		/********
    			if (flag & (FSHLOCK | FEXLOCK))
    				vno_bsd_unlock(fp, (FSHLOCK | FEXLOCK));
    			********/
		type = vp->v_type;
		/********
    				Do we need the following!!
    			if ((type == VBLK) || (type == VCHR)) {
    				rdev = vp->v_rdev;
    				for (ffp = file; ffp < fileNFILE; ffp++) {
    #ifdef	TRFS
    					if (ffp->f_type != DTYPE_VNODE &&
    						ffp->f_type != DTYPE_TRFS)
    #else	TRFS
    					if (ffp->f_type != DTYPE_VNODE)
    #endif	TRFS
    						continue;
    					if (ffp->f_count &&
    					    (tvp = (struct vnode *)ffp->f_data) &&
    					    tvp->v_rdev == rdev && tvp->v_type == type) {
    						VN_RELE(vp);
    						return (0);
    					}
    				}
    #ifdef	TRFS
    				if (ImportedDev(vp->v_rdev)) {
    					VN_RELE(vp);
    					return(0);
    				}
    #endif	TRFS
    			}
    			*******/
		chkrsig ();
		if (msg_in->rq_count > 1)
		  break;

		if (setjmp (&u.u_qsave))
		    u.u_error = EINTR;
		else
		    u.u_error = VOP_CLOSE (vp, flag, u.u_cred);
		del_rduser (queue);
		break;
	    }
	  case DUCOREDUMP:
	    {
		struct vnode   *vvp;
		struct vattr    vattr;

		u.u_arg[0] = (int) msg_in->rq_data;
		u.u_cmask = msg_in->rq_cmask;
		set_dir (msg_in, queue);
		u.u_error = 0;
		u.u_procp->p_systemcall = DUCOREDUMP;
		vattr_null (&vattr);
		vattr.va_type = VREG;
		vattr.va_mode = 0666;
		vattr.va_size = 0;
		u.u_error = vn_create ("core", UIOSEG_KERNEL, &vattr,
				       NONEXCL, VWRITE, &vvp);
		if (!u.u_error)
		    if (gift = make_gift (vvp, FILE_QSIZE, sdp)) {
			srmount[msg_in->rq_mntindx].sr_refcnt++;
			/* prele (ip); */
		    }
		    else
			VN_RELE (vvp);
		break;
	    }

	  case DUCREAT:
	    queue = setrsig (msig, queue);
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_fmode;
	    u.u_cmask = msg_in->rq_cmask;
	    set_dir (msg_in, queue);
	    if (setjmp (&u.u_qsave))
		u.u_error = EINTR;
	    else
		creat (u.u_ap);
	    chkrsig ();
	    if (!u.u_error) {
		register struct file *fp;
		register int    i;

		i = u.u_r.r_val1;
		fp = u.u_ofile[i];
		vp = (struct vnode *) (fp->f_data);
		if (gift = make_gift (vp, FILE_QSIZE, sdp)) {
		    srmount[msg_in->rq_mntindx].sr_refcnt++;
		    crfree (fp->f_cred);
		    fp->f_count = 0;
		}
		else {
		    DUPRINT3 (DB_SERVE, "serve: creat make_gift fails, vp %x, fp %x\n", vp, fp);
		    closef (fp, 1);
		}
		u.u_ofile[i] = NULL;
	    }
	    break;

	  case DUEXEC:
	  case DUEXECE:
	    {
		extern struct vnode *eval2_hdr ();
		struct pathname pn;
		register struct pathname *pnp = &pn;
		struct vattr    vattr;
		register struct response *msg;
		register int    len;

		dinfo.isysexec++;	/* incoming exec's */
		sysinfo.sysexec++;	/* total exec's */
		u.u_arg[0] = (int) msg_in->rq_data;
		set_dir (msg_in, queue);
		if (u.u_error = pn_get (u.u_arg[0], UIOSEG_KERNEL, pnp)) {
		    pn_free (pnp);
		    break;
		}
		if (vp = eval2_hdr (pnp)) {
		    if (!u.u_error)
			u.u_error = VOP_GETATTR (vp, &vattr, u.u_cred);
		    if ((!u.u_error) &&
			(gift = make_gift (vp, FILE_QSIZE, sdp))) {
			gift->rd_qtype |= RDTEXT;
			while ((nbp =
				alocbuf (sizeof (struct response)
					 - DATASIZE + MAXCOMLEN + 1,
					 BPRI_MED)) == NULL);
			msg = (struct response *) PTOMSG (nbp->b_rptr);
			msg->rp_type = RESP_MSG;
			u.u_msgend = msg->rp_data + MAXCOMLEN + 1;
			msg->rp_mode = 0;
			if (vattr.va_mode & VSUID)
			    msg->rp_mode |= ISUID;
			if (vattr.va_mode & VSGID)
			    msg->rp_mode |= ISGID;
			if (vattr.va_mode & VSVTX)
			    msg->rp_mode |= ISVTX;
			u.u_copymsg = msg;
			u.u_copymsg->rp_bp = (long) nbp;
			len = (pnp->pn_path - pnp->pn_buf) +
			  pnp->pn_pathlen;
			ASSERT (len <= MAXCOMLEN);
			bcopy ((caddr_t) pnp->pn_buf,
			       (caddr_t) msg->rp_data, len);
			msg->rp_data[len] = 0;
			srmount[msg_in->rq_mntindx].sr_refcnt++;
		    }
		    else
			VN_RELE (vp);
		}
		pn_free (pnp);
		break;
	    }

	  case DUFCNTL:		/* Simulate everything before
					 * VOP_LOCKCTL */
	    queue = setrsig (msig, queue);
	    vp = queue->rd_vnode;
	    u.u_rflags |= U_RCOPY;
	    if (setjmp (&u.u_qsave))
		u.u_error = EINTR;
	    else {
		struct flock    ld;
		register struct flock *ldp;
		int             oldwhence;

		ldp = &ld;
		if (u.u_error = copyin ((caddr_t) msg_in->rq_fcntl,
					(caddr_t) ldp, sizeof (*ldp)))
		    goto fcntlerr;
		oldwhence = ldp->l_whence;

		/*
		 * System V uses a different flock struct than BSD so we need
		 * to fudge up the struct for bsd. 
		 */
		i = ldp->l_xxx;
		ldp->l_xxx = ldp->l_pid;
		ldp->l_pid = i;

		/*
		 * *** NOTE *** The SVID does not say what to return on file
		 * access errors! Here, EBADF is returned, which is
		 * compatible with S5R3 and is less confusing than EACCES 
		 */
		/* check access permissions */
		if (msg_in->rq_cmd != F_GETLK) {
		    switch (ldp->l_type) {
		      case F_RDLCK:
			if (!(msg_in->rq_fflag & FREAD))
			    u.u_error = EBADF;
			break;

		      case F_WRLCK:
			if (!(msg_in->rq_fflag & FWRITE))
			    u.u_error = EBADF;
			break;

		      case F_UNLCK:
			break;

		      default:
			u.u_error = EINVAL;
		    }
		}
		if (u.u_error)
		    goto fcntlerr;
		/* convert offset to start of file */
		if (u.u_error = rfs_rewhence (vp, ldp, msg_in->rq_foffset, 0))
		    goto fcntlerr;

		/* convert negative lengths to positive */
		if (ldp->l_len < 0) {
		    ldp->l_start += ldp->l_len;
		    ldp->l_len = -(ldp->l_len);
		}

		/* check for validity */
		if (ldp->l_start < 0) {
		    u.u_error = EINVAL;
		    goto fcntlerr;
		}

		/*
		 * Dispatch out to vnode layer to do the actual locking.
		 * Then, translate error codes for SVID compatibility 
		 */
		u.u_error = VOP_LOCKCTL (vp, ldp, msg_in->rq_cmd, u.u_cred, 0);
		if (u.u_error) {
		    if (u.u_error == EWOULDBLOCK)
			u.u_error = EACCES;
		    goto fcntlerr;
		}
		/*
		 * See comment above about this bait and switch
		 */
		i = ldp->l_xxx;
		ldp->l_xxx = ldp->l_pid;
		ldp->l_pid = i;
		
		/* if F_GETLK, return flock structure to user-land */
		if (msg_in->rq_cmd == F_GETLK) {
		    /* per SVID, change only 'l_type' field if unlocked */
		    if (ldp->l_type == F_UNLCK)
		      copyout ((caddr_t)&ldp->l_type,
			       (caddr_t)&((struct flock *)msg_in->rq_fcntl)->l_type,
			       sizeof (ldp->l_type));
		    else {
			if ((u.u_error = rfs_rewhence (vp, ldp,
						       msg_in->rq_foffset,
						       oldwhence)) == 0)
			  u.u_error = copyout ((caddr_t) ldp,
					       (caddr_t) msg_in->rq_fcntl,
					       sizeof (*ldp));
		    }
		}
	    }
    fcntlerr:
	    u.u_rflags &= ~U_RCOPY;
	    chkrsig ();
	    break;
	  case DUFSTAT:
	    {
		struct stat     ub;
		struct sysv_stat sub;

		vp = queue->rd_vnode;
		switch (vp->v_type) {
		  case VREG:
		  case VDIR:
		  case VLNK:
		  case VBLK:
		  case VCHR:
		  case VFIFO:
		    u.u_error = vno_stat (vp, &ub);
		    break;

		  case VSOCK:

		  default:
		    panic ("server sysv_fstat");
		    /* NOTREACHED */
		}
		if (u.u_error == 0) {
		    sub.st_dev = ub.st_dev;
		    sub.st_ino = (ushort) ub.st_ino;
		    sub.st_mode = ub.st_mode;
		    sub.st_nlink = ub.st_nlink;
		    sub.st_uid = ub.st_uid;
		    sub.st_gid = ub.st_gid;
		    sub.st_rdev = ub.st_rdev;
		    sub.st_atime = ub.st_atime;
		    sub.st_mtime = ub.st_mtime;
		    sub.st_ctime = ub.st_ctime;
		    if (vp->v_type == VDIR) {
			VN_HOLD (vp);
			u.u_error = bsd_to_sysv (vp, ub.st_size, &sub.st_size);
			VN_RELE (vp);
		    }
		    else
			sub.st_size = ub.st_size;
		}
		if (u.u_error == 0)
		    u.u_error = copyout ((caddr_t) & sub,
					 (caddr_t) msg_in->rq_bufptr,
					 (u_int) sizeof (sub));
		if (!u.u_error) {
		    register struct mount *mp;

		    mp = (struct mount *) (queue->rd_vnode->v_vfsp->vfs_data);
		    ((struct sysv_stat *) u.u_copymsg->rp_data)->st_dev = mp - mounttab;

		    adjust_time ((struct sysv_stat *) u.u_copymsg->rp_data, qp);
		    stat_rmap (gdpp, (struct sysv_stat *) u.u_copymsg->rp_data);
		}
		break;
	    }
	  case DUFSTATFS:
	    statfs1 (queue->rd_vnode, msg_in->rq_bufptr,
		     msg_in->rq_len, msg_in->rq_fstyp);
	    break;
	  case DUGETDENTS:
	    {
		struct uio      auio;
		struct iovec    aiov;
		struct file	f;

		forgery (&f, vp, msg_in);
		vp = queue->rd_vnode;
		aiov.iov_base = (caddr_t) msg_in->rq_base;
		aiov.iov_len = msg_in->rq_count;
		auio.uio_iov = &aiov;
		auio.uio_iovcnt = 1;
		auio.uio_seg = UIOSEG_USER;
		auio.uio_resid = msg_in->rq_count;
		if ((u.u_error =
		     sysv_to_bsd (vp, msg_in->rq_offset, &f)) == 0) {
			auio.uio_offset = f.f_offset;
			auio.uio_offset_sysv = f.f_offset_sysv;
			auio.uio_offset_buf = f.f_offset_buf;
			u.u_error = VOP_S5GETDENTS (vp, &auio, u.u_cred, 0);
		}
		if (u.u_error)
		  break;
		if ((ret_val = msg_in->rq_count - auio.uio_resid) > 0)
		  if (u.u_copymsg)
		    u.u_copymsg->rp_offset = auio.uio_offset_sysv;
		break;
	    }
	  case DUIOCTL:
	    queue = setrsig (msig, queue);
	    u.u_rflags |= U_RCOPY;
	    if (setjmp (&u.u_qsave))
		u.u_error = EINTR;
	    else {
		vp = queue->rd_vnode;
		switch (vp->v_type) {
		  case VCHR:
		    u.u_error = VOP_IOCTL (vp, msg_in->rq_cmd,
			      msg_in->rq_ioarg, msg_in->rq_fflag, u.u_cred);
		    break;
		  default:
		    u.u_error = ENOTTY;
		    break;
		}
	    }
	    u.u_rflags &= ~U_RCOPY;
	    chkrsig ();
	    break;
	  case DULBMOUNT:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_newmntindx;
	    set_dir (msg_in, queue);
	    gift = slbmount ();
	    if (!gift)
		break;
	    /* keep track of who we gave it to */
	    if ((cr_rduser (gift, sdp->sd_queue)) == (struct rd_user *) NULL) {
		del_rcvd (gift, (queue_t *) NULL);
		u.u_error = ENOSPC;
		break;
	    }
	    break;
	  case DULINK:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    set_dir (msg_in, queue);
	    link (u.u_ap);
	    if (!u.u_error) {
		if (gift = make_gift (u.u_pdir, FILE_QSIZE, sdp)) {
		    srmount[msg_in->rq_mntindx].sr_refcnt++;
		}
		else
		    VN_RELE (u.u_pdir);
		u.u_pdir = NULL;
	    }
	    break;

	  case DULINK1:{		/* Emulates late half of vn_link */
		register struct vnode *fvp;
		struct vnode   *tdvp;
		struct pathname pn;
		register        tmp;

		fvp = tdvp = (struct vnode *) 0;
		u.u_error = pn_get (msg_in->rq_data, UIOSEG_KERNEL, &pn);
		if (u.u_error)
		    break;
		set_dir (msg_in, queue);
		if ((tmp = msg_in->rq_link) != 0)
		    fvp = rcvd[tmp].rd_vnode;
		u.u_error = lookuppn (&pn, FOLLOW_LINK, &tdvp,
				      (struct vnode **) 0);
		if (u.u_error)
		    goto linkerr;
		/*
		 * Make sure both source vnode and target directory vnode are
		 * in the same vfs and that it is writeable. 
		 */
		if ((fvp == (struct vnode *) NULL) ||
		    fvp->v_vfsp != tdvp->v_vfsp) {
		    u.u_error = EXDEV;
		    goto linkerr;
		}
		if (tdvp->v_vfsp->vfs_flag & VFS_RDONLY) {
		    u.u_error = EROFS;
		    goto linkerr;
		}
		/*
		 * do the link 
		 */
		u.u_error = VOP_LINK (fvp, tdvp, pn.pn_path, u.u_cred);
	linkerr:
		pn_free (&pn);
		/* fvp will be freed from the remote side */
		if (tdvp)
		    VN_RELE (tdvp);
		break;
	    }
	  case DUMKDIR:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_fmode;
	    set_dir (msg_in, queue);
	    mkdir (u.u_ap);
	    break;
	  case DUMKNOD:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_fmode;
	    u.u_arg[2] = (dev_t) msg_in->rq_dev;
	    u.u_cmask = msg_in->rq_cmask;
	    set_dir (msg_in, queue);
	    mknod (u.u_ap);
	    break;
	  case DUOPEN:
	    queue = setrsig (msig, queue);
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_mode;
	    u.u_arg[2] = msg_in->rq_crtmode;
	    u.u_cmask = msg_in->rq_cmask;
	    set_dir (msg_in, queue);
	    if (setjmp (&u.u_qsave))
		u.u_error = EINTR;
	    else
		sysv_open (u.u_ap);
	    DUPRINT2 (DB_SIGNAL, "serve: after open sig %x\n",
		      u.u_procp->p_sig);
	    chkrsig ();
	    if (!u.u_error) {
		register struct file *fp;
		register int    i;
		i = u.u_r.r_val1;
		fp = u.u_ofile[i];
		vp = (struct vnode *) (fp->f_data);
		if (gift = make_gift (vp, FILE_QSIZE, sdp)) {
		    srmount[msg_in->rq_mntindx].sr_refcnt++;
		    crfree (fp->f_cred);
		    fp->f_count = 0;
		}
		else {
		    DUPRINT3 (DB_SERVE, "serve: creat make_gift fails, vp %x, fp %x\n", vp, fp);
		    closef (fp, 1);
		}
		u.u_ofile[i] = NULL;
	    }
	    break;
	  case DUREAD:
	    {
		struct uio      auio;
		struct iovec    aiov;
		struct file 	f;

		dinfo.isysread++;	/* incoming read's */
		sysinfo.sysread++;
		queue = setrsig (msig, queue);
		aiov.iov_base = (caddr_t) msg_in->rq_base;
		aiov.iov_len = msg_in->rq_count;
		auio.uio_iov = &aiov;
		auio.uio_iovcnt = 1;
		auio.uio_offset = msg_in->rq_offset;
		auio.uio_seg = UIOSEG_USER;
		auio.uio_resid = msg_in->rq_count;
		/* u.u_fmode = msg_in->rq_fmode;	 */
		vp = queue->rd_vnode;
		ocount = msg_in->rq_count;
		bcount = u.u_ru.ru_inblock;
		forgery (&f, vp, msg_in);
		freemsg (bp);
		/*
		 * if (type == IFREG || type == IFDIR || type == IFIFO) plock
		 * (ip); 
		 */
		if (setjmp (&u.u_qsave))
		    u.u_error = EINTR;
		else {
		    switch (vp->v_type) {

		      case VREG:
			u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					      ((msg_in->rq_fmode & FAPPEND) != 0 ?
					       IO_APPEND | IO_UNIT : IO_UNIT),
					      u.u_cred);
			/*
			 * Credentials of the opener are not available at
			 * this time 
			 */
			break;
		      case VLNK:
		      case VBLK:
		      case VCHR:
			u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					      ((msg_in->rq_fmode & FAPPEND) != 0 ?
					       IO_APPEND : 0), u.u_cred);
			break;
		      case VDIR:
			if ((u.u_error =
			     sysv_to_bsd (vp, msg_in->rq_offset, &f)) == 0) {
				auio.uio_offset = f.f_offset;
				auio.uio_offset_sysv = f.f_offset_sysv;
				auio.uio_offset_buf = f.f_offset_buf;
				u.u_error = VOP_S5GETDENTS (vp, &auio, u.u_cred, 1);
			}
			break;
		      case VFIFO:
			u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					      ((msg_in->rq_fmode & FNDELAY) != 0 ?
					       IO_APPEND | IO_NDELAY : IO_APPEND),
					      u.u_cred);
			break;

		      case VSOCK:
		      default:
			panic ("server DUREAD");
			/* NOTREACHED */
		    }
		    /*
		     * if (type == IFREG || type == IFDIR || type== IFIFO)
		     * prele (ip); 
		     */
		}
		chkrsig ();
		srmount[u.u_mntindx].sr_bcount += (u.u_ru.ru_inblock - bcount);
		ret_val = auio.uio_resid;
		dinfo.ireadch += ocount - auio.uio_resid;	/* incoming ch's read */
		sysinfo.readch += ocount - auio.uio_resid;
		break;
	    }
	  case DUREADI:
	    {
		struct uio      auio;
		struct iovec    aiov;
		struct file	f;

		dinfo.isyscall--;
		sysinfo.syscall--;
		aiov.iov_base = (caddr_t) msg_in->rq_base;
		aiov.iov_len = msg_in->rq_count;
		auio.uio_iov = &aiov;
		auio.uio_iovcnt = 1;
		auio.uio_offset = msg_in->rq_offset;
		auio.uio_seg = UIOSEG_USER;
		auio.uio_resid = msg_in->rq_count;
		/* u.u_fmode = msg_in->rq_fmode;	 */
		vp = queue->rd_vnode;
		bcount = u.u_ru.ru_inblock;
		freemsg (bp);
		forgery (&f, vp, msg_in);
		/* plock (queue->rd_inode); */
		switch (vp->v_type) {

		  case VREG:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					  ((msg_in->rq_fmode & FAPPEND) != 0 ?
					   IO_APPEND | IO_UNIT : IO_UNIT), u.u_cred);
		    /*
		     * Credentials of the opener are not available at this
		     * time 
		     */
		    break;
		  case VLNK:
		  case VBLK:
		  case VCHR:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					  ((msg_in->rq_fmode & FAPPEND) != 0 ?
					   IO_APPEND : 0), u.u_cred);
		    break;
		  case VDIR:
		    if ((u.u_error = sysv_to_bsd (vp, msg_in->rq_offset, &f)) == 0) {
			    auio.uio_offset = f.f_offset;
			    auio.uio_offset_sysv = f.f_offset_sysv;
			    auio.uio_offset_buf = f.f_offset_buf;
			    u.u_error = VOP_S5GETDENTS (vp, &auio, u.u_cred, 1);
		    }
		    break;

		  case VFIFO:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_READ,
					  ((msg_in->rq_fmode & FNDELAY) != 0 ?
					   IO_APPEND | IO_NDELAY : IO_APPEND),
					  u.u_cred);
		    break;

		  case VSOCK:
		    u.u_error = soreceive ((struct socket *) vp, 0, &auio, 0, 0);
		    break;

		  default:
		    panic ("server DUREADI");
		    /* NOTREACHED */
		}
		/* prele (queue->rd_inode); */
		srmount[u.u_mntindx].sr_bcount += (u.u_ru.ru_inblock - bcount);
		ret_val = auio.uio_resid;
		break;
	    }
	  case DURSIGNAL:
	    {
		register struct proc *l;
		register int    s;

		dinfo.isyscall--;
		sysinfo.syscall--;
		for (l = s_active; l != NULL; l = l->p_rrlink) {
		    if (l == u.u_procp)
			continue;
		    DUPRINT3 (DB_SIGNAL, "DURSIGNAL: l->p_sysid = %d  u.u_procp->p_sysid %d\n", l->p_sysid, u.u_procp->p_sysid);
		    if ((l->p_epid == (short) msg_in->rq_pid) &&
			(l->p_sysid == u.u_procp->p_sysid)) {
			psignal (l, SIGTERM);
			break;
		    }
		}
		if (l == NULL) {
		    s = splrf ();
		    sdp->sd_srvproc = NULL;
		    queue = inxtord (msig->m_dest);
		    if ((sbp = chkrdq (queue, msg_in->rq_pid,
				       msg_in->rq_sysid)) == NULL) {
			splx (s);
			if (queue->rd_sdnack != NULL)
			    nackflush (queue, -1);
		    }
		    else {
			splx (s);
			freemsg (bp);
			bp = sbp;
			msig = (struct message *) bp->b_rptr;
			msig->m_stat |= SIGNAL;
			if (queue->rd_sdnack)
			    nackflush (queue, (int) (queue->rd_qsize - queue->rd_qcnt));
			set_sndd (sdp, (queue_t *) msig->m_queue, (index_t) msig->m_gindex, (int) msig->m_gconnid);
			goto psmsg;
		    }
		}
		freemsg (bp);
		rmactive (u.u_procp);
		continue;
	    }
	  case DURMDIR:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    set_dir (msg_in, queue);
	    rmdir (u.u_ap);
	    break;
	  case DURMOUNT:
	    /* nami part of rmount */
	    u.u_arg[1] = (int) msg_in->rq_data;
	    set_dir (msg_in, queue);
	    rmount ();
	    break;
	  case DUSRMOUNT:
	    /* Server side of remote mount */
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = (int) msg_in->rq_flag;
	    if (gdpp->mntcnt == 0) {
		hibyte (gdpp->sysid) =
		  lobyte (loword (msg_in->rq_sysid));
		u.u_procp->p_sysid = gdpp->sysid;
		gdpp->time = msg_in->rq_synctime - time.tv_sec;
	    }
	    gift = srmnt (gdpp);
	    if (u.u_error == 0) {
		gdpp->mntcnt++;
		gift->rd_refcnt++;
	    }
	    break;
	  case DUSRUMOUNT:
	    {
		register struct srmnt *smp;

		smp = &srmount[u.u_mntindx];
		vp = smp->sr_rootvnode;
		if (srumount (smp, vp)) {
		    del_rcvd (queue, sdp->sd_queue);
		    gdpp->mntcnt--;
		    VN_RELE (vp);
		}
		break;
	    }
	  case DUSEEK:
	    ret_val = VTOI (queue->rd_vnode)->i_size;
	    break;
	  case DUSTAT:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_bufptr;
	    set_dir (msg_in, queue);
	    sysv_stat (u.u_ap);
	    if (!u.u_error) {
		register struct mount *mp;
		register dev_t  dev;

		dev = ((struct sysv_stat *) u.u_copymsg->rp_data)->st_dev;
		for (mp = mounttab; mp < &mounttab[NMOUNT]; mp++)
		    if ((mp->m_bufp != 0) && dev == mp->m_dev)
			break;
		((struct sysv_stat *) u.u_copymsg->rp_data)->st_dev = mp - mounttab;

		adjust_time ((struct sysv_stat *) u.u_copymsg->rp_data, qp);
		stat_rmap (gdpp, (struct sysv_stat *) u.u_copymsg->rp_data);
	    }
	    break;
	  case DUSTATFS:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    u.u_arg[1] = msg_in->rq_bufptr;
	    u.u_arg[2] = msg_in->rq_len;
	    u.u_arg[3] = msg_in->rq_fstyp;
	    set_dir (msg_in, queue);
	    sysv_statfs (u.u_ap);
	    break;
	  case DUUNLINK:
	    u.u_arg[0] = (int) msg_in->rq_data;
	    set_dir (msg_in, queue);
	    unlink (u.u_ap);
	    break;
	  case DUUTIME:
	    {
		time_t          stv[2];

		u.u_arg[0] = (int) msg_in->rq_data;	/* pathname */
		u.u_arg[1] = (int) msg_in->rq_bufptr;	/* times */
		if (msg_in->rq_bufptr != NULL) {
		    u.u_copybp = NULL;	/* can't presend data */
		    if (u.u_error = copyin ((caddr_t) msg_in->rq_bufptr,
				       (caddr_t) stv, (u_int) sizeof (stv)))
			break;
		    else {
			stv[0] -= GDP (qp)->time;
			stv[1] -= GDP (qp)->time;
			u.u_arg[1] = (int) stv;
		    }
		}
		set_dir (msg_in, queue);
		utime (u.u_ap);
		break;
	    }
	  case DUUTSSYS:
	    {
		register struct mount *mp;
		if (msg_in->rq_dev < 0 || msg_in->rq_dev >= (long) NMOUNT) {
		    u.u_error = EINVAL;
		    break;
		}
		mp = &mounttab[msg_in->rq_dev];
		if (mp->m_bufp == NULL) {
		    u.u_error = EINVAL;
		    break;
		}
		/******
    			if((ip = iget(mp, mp->m_mount->i_number)) == NULL) {
    				u.u_error = ENONET;
    				break;
    			}
    			*******/
		u.u_arg[0] = (int) msg_in->rq_bufptr;
		u.u_arg[1] = mp->m_dev;
		u.u_arg[2] = 2;		/* ustat only */
		/* iput(ip); */
		utssys (u.u_ap);
		break;
	    }

	  case DUWRITE:
	    {
		struct uio      auio;
		struct iovec    aiov;
		int             offset;
		struct file	f;

		dinfo.isyswrite++;	/* incoming write's */
		sysinfo.syswrite++;
		queue = setrsig (msig, queue);
		vp = queue->rd_vnode;
		aiov.iov_base = (caddr_t) msg_in->rq_base;
		/* u.u_fmode = msg_in->rq_fmode;	 */
		/*
		 * if (type == IFREG || type == IFDIR || type== IFIFO) plock
		 * (ip); 
		 */
		/***********************
    			if(u.u_fmode & FAPPEND) {
    				u.u_offset = ip->i_size;
    				offset = u.u_offset;
    			} else
    			*************************/
		forgery (&f, vp, msg_in);
		offset = auio.uio_offset = msg_in->rq_offset;
		aiov.iov_len = msg_in->rq_count;
		auio.uio_iov = &aiov;
		auio.uio_iovcnt = 1;
		auio.uio_seg = UIOSEG_USER;
		auio.uio_resid = msg_in->rq_count;
		ocount = msg_in->rq_count;
		bcount = u.u_ru.ru_oublock;
		u.u_copybp = bp;
		msg_in->rq_sofar = 0;
		if (setjmp (&u.u_qsave))
		    u.u_error = EINTR;
		else {
		    switch (vp->v_type) {

		      case VREG:
			u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FAPPEND) != 0 ?
				  IO_APPEND | IO_UNIT : IO_UNIT), u.u_cred);
			/*
			 * Credentials of the opener are not available at
			 * this time 
			 */
			break;
		      case VLNK:
		      case VBLK:
		      case VCHR:
			u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FAPPEND) != 0 ?
						  IO_APPEND : 0), u.u_cred);
			break;
		      case VDIR:
			panic ("Write call on Directory!!\n");
			break;

		      case VFIFO:
			u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FNDELAY) != 0 ?
			      IO_APPEND | IO_NDELAY : IO_APPEND), u.u_cred);
			break;

		      case VSOCK:
			u.u_error = sosend ((struct socket *) vp, 0, &auio, 0, 0);
			break;

		      default:
			panic ("server DUWRITE");
			/* NOTREACHED */
		    }
		    /*
		     * if (type == IFREG || type == IFDIR || type== IFIFO)
		     * prele (ip); 
		     */
		}
		chkrsig ();
		if (msg_in->rq_fmode & FAPPEND) {
		    if (!u.u_copymsg) {
			while ((nbp = alocbuf (sizeof (struct response), BPRI_MED)) == NULL);
			u.u_copymsg = (struct response *) PTOMSG (nbp->b_rptr);
			u.u_copymsg->rp_type = RESP_MSG;
			u.u_msgend = u.u_copymsg->rp_data;
			u.u_copymsg->rp_bp = (long) nbp;
		    }
		    u.u_copymsg->rp_isize = VTOI(vp)->i_size;
		}
		
		srmount[u.u_mntindx].sr_bcount += (u.u_ru.ru_oublock - bcount);
		ret_val = auio.uio_resid;
		dinfo.iwritech += ocount - ret_val;	/* incoming ch's written */
		sysinfo.writech += ocount - ret_val;
		if (u.u_copybp) {
		    freemsg (u.u_copybp);	/* 0-length write */
		    u.u_copybp = NULL;
		}
		break;
	    }

	  case DUWRITEI:
	    {
		struct uio      auio;
		struct iovec    aiov;
		struct file 	f;

		dinfo.isyscall--;
		sysinfo.syscall--;
		vp = queue->rd_vnode;
		aiov.iov_base = (caddr_t) msg_in->rq_base;
		if ((auio.uio_offset = msg_in->rq_offset) < 0)
		    msg_in->rq_fmode |= FAPPEND;
		aiov.iov_len = msg_in->rq_count;
		auio.uio_iov = &aiov;
		auio.uio_iovcnt = 1;
		auio.uio_seg = UIOSEG_USER;
		auio.uio_resid = msg_in->rq_count;
		bcount = u.u_ru.ru_oublock;
		u.u_copybp = bp;
		msg_in->rq_sofar = 0;
		forgery(&f, vp, msg_in);
		/* plock(queue->rd_inode); */
		switch (vp->v_type) {

		  case VREG:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FAPPEND) != 0 ?
				  IO_APPEND | IO_UNIT : IO_UNIT), u.u_cred);
		    /*
		     * Credentials of the opener are not available at this
		     * time 
		     */
		    break;
		  case VLNK:
		  case VBLK:
		  case VCHR:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FAPPEND) != 0 ?
						  IO_APPEND : 0), u.u_cred);
		    break;
		  case VDIR:
		    panic ("Write call on Directory!!\n");
		    break;

		  case VFIFO:
		    u.u_error = VOP_RDWR (vp, &auio, UIO_WRITE, ((msg_in->rq_fmode & FNDELAY) != 0 ?
			      IO_APPEND | IO_NDELAY : IO_APPEND), u.u_cred);
		    break;

		  case VSOCK:
		    u.u_error = sosend ((struct socket *) vp, 0, &auio, 0, 0);
		    break;

		  default:
		    panic ("server DUWRITE");
		    /* NOTREACHED */
		}
		/* prele(queue->rd_inode); */
		srmount[u.u_mntindx].sr_bcount += (u.u_ru.ru_oublock - bcount);
		ret_val = auio.uio_resid;
		if (u.u_copybp) {
		    freemsg (u.u_copybp);	/* 0-length write */
		    u.u_copybp = NULL;
		}
		break;
	    }
	  default:
	    DUPRINT2 (DB_SERVE, "Server: Illegal msg %x\n",
		      u.u_procp->p_systemcall);
	    rmactive (u.u_procp);
	    continue;
	}
	rmactive (u.u_procp);
	if (u.u_error != EDOTDOT && u.u_error != ELBIN)
	    if (u.u_procp->p_systemcall != DUWRITE &&
		u.u_procp->p_systemcall != DUWRITEI &&
		u.u_procp->p_systemcall != DUREAD &&
		u.u_procp->p_systemcall != DUREADI)
		freemsg (bp);
	/*
	 * if msg needs to be sent, calculate size. else allocate a msg to
	 * send. 
	 */

	if (msg_out = u.u_copymsg) {
	    outsize = u.u_msgend - (char *) msg_out;
	    msg_out->rp_subyte = 0;
	}
	else {
	    while ((nbp = alocbuf (sizeof (struct response), BPRI_MED)) == NULL);
	    msg_out = (struct response *) PTOMSG (nbp->b_rptr);
	    msg_out->rp_type = RESP_MSG;
	    msg_out->rp_bp = (long) nbp;
	    msg_out->rp_subyte = 1;	/* set to indicate no data */
	    outsize = sizeof (struct response) - DATASIZE;
	}

	msg_out->rp_opcode = u.u_procp->p_systemcall;

	if (u.u_error == EDOTDOT || u.u_error == ELBIN) {
	    register struct pathname *pnp;

	    pnp = u.u_rfspnp;
	    if (u.u_error == EDOTDOT)
		msg_out->rp_opcode = DUDOTDOT;
	    else
		msg_out->rp_opcode = DULBIN;
	    DUPRINT2 (DB_SYSCALL, "serve:u.u_rfspnp %s\n", pnp);
	    (void) strncpy (msg_out->rp_data, pnp->pn_path, pnp->pn_pathlen);
	    kmem_free ((caddr_t) pnp->pn_buf, (u_int) MAXPATHLEN);
	    kmem_free ((caddr_t) pnp, (u_int) sizeof (struct pathname));
	    outsize = sizeof (struct response) - DATASIZE + pnp->pn_pathlen + 1;
	    u.u_error = 0;
	    DUPRINT2 (DB_SYSCALL, "serve: DOTDOT path=%s\n",
		      msg_out->rp_data);
	    freemsg (bp);
	}

	if (gift) {
	    register struct inode *ip = VTOI (vp);

	    vp = gift->rd_vnode;
	    msg_out->rp_ftype = VTTOIF (vp->v_type);
	    msg_out->rp_size = ip->i_size;
	    msg_out->rp_nlink = ip->i_nlink;
	    msg_out->rp_uid = ip->i_uid;
	    msg_out->rp_gid = ip->i_gid;
	}
	msg_out->rp_mntindx = u.u_mntindx;
	msg_out->rp_rval = ret_val;
	msg_out->rp_errno = u.u_error;
	msg_out->rp_sig = u.u_procp->p_sig;	/* return any remote signal */
	msg_out->rp_sysid = u.u_procp->p_sysid;
	if (sndmsg (sdp, (mblk_t *) msg_out->rp_bp,
		    outsize, gift) == FAILURE) {
	    register int    mntindx;
	    DUPRINT1 (DB_SERVE, "server sndmsg failed \n");
	    /*
	     * When sndmsg fails because link is down, recovery will clean
	     * up. Otherwise, we've done stuff on the server that we should
	     * undo. 
	     */

	    /*
	     * This code assumes that sndmsg fails only because link is down.
	     * A server that was working in disconnected resource is done.
	     * Reduce the count of such servers, and wakeup recovery if this
	     * is the last of them. 
	     */
	    mntindx = sdp->sd_mntindx;
	    if (--srmount[mntindx].sr_slpcnt == 0) {
		wakeup ((caddr_t) & srmount[mntindx]);
	    }
	}
    }
}

/*
 * pathname evaluation starts at either the current directory or the root
 * directory, depending on whether the filename starts with a slash (/). 
 */
set_dir (msg_in, queue)
    register struct request *msg_in;
    register rcvd_t queue;
{
    u.u_cdir = queue->rd_vnode;
    if (msg_in->rq_rrdir)
	u.u_rdir = rcvd[msg_in->rq_rrdir].rd_vnode;
    else
	u.u_rdir = (struct vnode *) NULL;
}

/*
 * Make a gift to give to a client. 
 */
rcvd_t
make_gift (vnodep, qsize, out_port)
    register struct vnode *vnodep;
    register char   qsize;
    register sndd_t out_port;		/* who the gift is for */
{
    register rcvd_t gift;

    /* if sd went bad, forget it */
    if (out_port->sd_stat & SDLINKDOWN) {
	u.u_error = ENOLINK;
	return (NULL);
    }

    gift = vnodep->v_rcvd;
    if (gift == NULL) {
	if ((gift = cr_rcvd (qsize, GENERAL)) == NULL) {
	    u.u_error = ENOMEM;
	    return (NULL);
	}
	gift->rd_vnode = vnodep;
	vnodep->v_rcvd = gift;
    }
    else
	gift->rd_refcnt++;

    /* keep track of who we gave it to */
    if ((cr_rduser (gift, out_port->sd_queue)) == (struct rd_user *) NULL) {
	del_rcvd (gift, (queue_t *) NULL);
	u.u_error = ENOSPC;
	return (NULL);
    }
    return (gift);
}


rmactive (proc)
    struct proc    *proc;
/* remove me from the list of active servers */
{
    register struct proc *current;
    extern int      currserv;

    currserv--;
    u.u_procp->p_sig &= ~USR1SIG;
    if ((current = s_active) == proc)
	s_active = s_active->p_rrlink;
    else {
	while (current && current->p_rrlink != proc)
	    current = current->p_rrlink;
	if (current)
	    current->p_rrlink = current->p_rrlink->p_rrlink;
    }
}

struct vnode   *
eval2_hdr (pnp)
	register struct pathname *pnp;
{
	struct vnode   *vp = NULL;
	register struct file *fp;
	
	u.u_error = lookuppn (pnp, FOLLOW_LINK, (struct vnode **) 0, &vp);
	if (u.u_error)
	  return (NULL);

	if (u.u_error = VOP_ACCESS (vp, VEXEC, u.u_cred))
	  goto bad;

	/*
	 * Check to make sure nobody is modifying the text right now 
	 */
	if ((vp->v_flag & VTEXTMOD) != 0) {
		u.u_error = ETXTBSY;
		goto bad;
	}

	if (((vp->v_flag & VTEXT) == 0) && (vp->v_count != 1)) {
	for (fp = file; fp < fileNFILE; fp++) {
			if (fp->f_type == DTYPE_VNODE && fp->f_count > 0 &&
			    (struct vnode *) fp->f_data == vp &&
			    (fp->f_flag & FWRITE)) {
				u.u_error = ETXTBSY;
				goto bad;
			}
		}
	}
	vp->v_flag |= VTEXT;
	return (vp);
      bad:
	VN_RELE (vp);
	return ((struct vnode *) NULL);
}

/*
 * This routine is called to search a receive descriptor queue for pid and
 * sysid.  The message which matches will be removed from the queue 
 */

#define	rsmsg	((struct request *)PTOMSG(current->b_rptr))
mblk_t         *
chkrdq (que, pid, sysid)
    rcvd_t          que;
    long            pid, sysid;
{
    mblk_t         *current;
    register int    i;

    DUPRINT3 (DB_SIGNAL, "chkrdq: que %x pid %x\n", que, pid);
    for (i = 0; i < que->rd_qcnt; i++) {
	current = (mblk_t *) deque ((QCTRL *) & que->rd_rcvdq);
	DUPRINT5 (DB_SIGNAL, "chkrdq: que %x pid %x rsmsg %x msgpid %x\n"
		  ,que, pid, rsmsg, rsmsg->rq_pid);
	if ((rsmsg->rq_pid == pid) && (rsmsg->rq_sysid == sysid)) {
	    que->rd_qcnt--;
	    if (rcvdemp (que))
		rm_msgs_list (que);
	    return (current);
	}
	enque ((QCTRL *) & que->rd_rcvdq, (QITEM *) current);
    }
    return (NULL);			/* signal msg not on queue */
}

/*
 * All dying servers come through here. A server dies when it is awakened
 * from de_queue with nothing on its queue. 
 */

serve_exit ()
{
    register int    i;
    extern struct vnode *rfs_cdir;
    extern struct proc *s_zombie;
    extern int      nzombcnt, nservers;
    extern rcvd_t   rd_recover;

    DUPRINT1 (DB_SERVE, "server_exit:\n");
    u.u_procp->p_epid = NULL;
    u.u_rdir = NULL;
    u.u_cdir = rfs_cdir;
    for (i = 0; i < NOFILE; i++) {
	u.u_ofile[i] = NULL;
	u.u_pofile[i] = 0;
    }
    if (u.u_gift)
	free_sndd (u.u_gift);
    --nservers;
    --idleserver;
    u.u_procp->p_rrlink = s_zombie;
    s_zombie = u.u_procp;
    if (++nzombcnt > 1)			/* clean up zombie servers */
	wakeup ((caddr_t) & rd_recover->rd_qslp);
    exit (0);
}

/*
 * Don't allow last server to sleep - return ENOMEM. 
 */

 /* static */ void
chkrsig ()
{
    if (u.u_procp->p_sig & USR1SIG)
	if (!(u.u_procp->p_sig & TERMSIG))
	    if (u.u_error == EINTR)
		u.u_error = ENOMEM;
    u.u_procp->p_sig &= ~TERMSIG;	/* server needs sig reset */
}

struct rcvd    *
setrsig (m, q)
    register struct message *m;
    register struct rcvd *q;
{
    if (m->m_stat & SIGNAL) {
	u.u_procp->p_sig |= TERMSIG;
	return (inxtord (m->m_dest));
    }
    return (q);
}



adjust_time (statbuf, qp)
    struct sysv_stat *statbuf;
    queue_t        *qp;
{
    register        gdp_time;

    gdp_time = GDP (qp)->time;
    statbuf->st_atime += gdp_time;
    statbuf->st_ctime += gdp_time;
    statbuf->st_mtime += gdp_time;
}

/*
 * Normalize SystemV-style record locks 
 */
 /* static */ rfs_rewhence (vp, ld, offset, newwhence)
    struct vnode   *vp;
    struct flock   *ld;
    off_t           offset;
    int             newwhence;
{
    struct vattr    va;
    register int    error;

    /* if reference to end-of-file, must get current attributes */
    if ((ld->l_whence == 2) || (newwhence == 2))
	if (error = VOP_GETATTR (vp, &va, u.u_cred))
	    return (error);

    /* normalize to start of file */
    switch (ld->l_whence) {
      case 0:
	break;
      case 1:
	ld->l_start += offset;
	break;
      case 2:
	ld->l_start += va.va_size;
	break;
      default:
	return (EINVAL);
    }

    /* renormalize to given start point */
    switch (ld->l_whence = newwhence) {
      case 1:
	ld->l_start -= offset;
	break;
      case 2:
	ld->l_start -= va.va_size;
	break;
    }
    return (0);
}

/*
 * Forge a file pointer that can be used by various routines.
 * Return code: none
 *
 * Side effects:
 *      fp is zero'd for sizeof (struct file) bytes.
 *	user's u_arg area is filled in with 0, rq_base and rq_count.
 */
forgery (fp, vp, msg_in)
	register struct file *fp;
	register struct vnode *vp;
	register struct request *msg_in;
{
	bzero (fp, sizeof (struct file));
	fp->f_type = DTYPE_VNODE;
	fp->f_count = msg_in->rq_count;
	fp->f_offset = msg_in->rq_offset;
	fp->f_flag = msg_in->rq_fmode;
	fp->f_data = (caddr_t)vp;
	fp->f_cred = u.u_cred;

	u.u_arg[0] = 0;
	u.u_arg[1] = msg_in->rq_base;
	u.u_arg[2] = msg_in->rq_count;
	u.u_ofile[0] = fp;
	u.u_ap = u.u_arg;
}
#endif	defined(SYSV) && defined(RFS)

