/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:nudnix/rsc.c	10.19"		*/

#if	defined(SYSV) && defined(RFS)
#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../h/param.h"
#include "../sysv/sys/errno.h"
#include "../sysv/sys/stream.h"
#include "../sysv/sys/comm.h"
#include "../h/user.h"
#include "../sysv/sys/message.h"
#include "../h/proc.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/cirmgr.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../h/uio.h"

extern	rcvd_t	cr_rcvd ();
extern	rcvd_t	de_queue ();
extern	mblk_t	*dupmsg();
extern	mblk_t	*reusebuf();


struct {
    int s_pid;
    int s_syscall;
    int s_seq;
    int s_arg0;
    int s_arg1;
    int s_arg2;
} last_rsc;
int rsc_seq;

/*
 * remote system call
 *
 *	Send a request to the server and wait for the response.
 *	Handle intermediate responses (ACK, NACK, data movement).
 *	This routine should never be called by server.
 *
 *	resp and gift are returned as side effects.
 */
rsc(sd, rq_bp, req_size, rp_bp, gift, uiop)
sndd_t	sd;			/* which send descriptor to send on	*/
sndd_t	gift;			/* gift back from the server		*/
mblk_t	*rq_bp;			/* incoming request block ptr		*/
mblk_t	**rp_bp;		/* ptr to response back from server	*/
int	req_size;		/* how many bytes			*/
struct uio *uiop;		/* uio structure if data expected	*/
{
	mblk_t	*nbp;
	struct	response *resp;	/* the response msg body		*/
	struct	response *nresp;
	struct  request *rq;
	struct message *smsg;
	rcvd_t  rd;		/* where to receive the response	*/
	int	unclean = TRUE;	/* need to free send buffer		*/
	int	ret = 0;	/* return from sndmsg			*/
	int	size;		/* ignored 				*/
	int	nackcnt = 0;	/* GDP NACK count 			*/

	if ((rd = cr_rcvd (FILE_QSIZE, SPECIFIC)) == NULL) {
		u.u_error = ENOMEM;
		freemsg (rq_bp);
		u.u_procp->p_flag &= ~SRSIG;	/*clear any remote signal flags*/	
		return (FAILURE);
	}

	/*
	 * for debugging purposes.
	 */
	rq = (struct request *) PTOMSG(rq_bp->b_rptr);
#ifdef notdef
	last_rsc.s_pid = u.u_procp->p_pid;
	last_rsc.s_syscall = u.u_procp->p_systemcall;
	/*
	 * rq_tmp[0] is used by rcopyin
	 */
	last_rsc.s_seq = rq->rq_tmp[1] = rsc_seq++;
	last_rsc.s_arg0 = rq->rq_arg[0];
	last_rsc.s_arg1 = rq->rq_arg[1];
	last_rsc.s_arg2 = rq->rq_arg[2];
#endif

	/* keep track of sd we're going out on (client side only) */
	rd->rd_vnode = (struct vnode *) sd;
	u.u_procp->p_minwd = (struct rcvd *) sd;	/* for remote signal */
sendit:	
	/* duplicate the message before sending out */
	nbp = dupmsg(rq_bp);
	if (nbp == NULL) {
		u.u_error = ENOMEM;
		ret = FAILURE;
		goto out;
	}
	if ((ret = sndmsg (sd, nbp, req_size, rd)) != SUCCESS)
		goto out;
getit:	if (de_queue (rd, rp_bp, gift, &size) == (rcvd_t)FAILURE) {
		u.u_error = ECOMM;
		ret = FAILURE;
		goto out;
	}
	if ((sd->sd_stat & SDLINKDOWN) && gift) {
		DUPRINT1(DB_RECOVER, "rsc: sd went bad during de_queue \n");
		freemsg (*rp_bp);
		u.u_error = ENOLINK;
		ret = FAILURE;
		goto out;
	}
	resp = (struct response *) PTOMSG((*rp_bp)->b_rptr);

	switch (resp->rp_opcode)  {
	/* server's queue was full, try again */
	case DUGDPNACK:
		freemsg (*rp_bp);
		nackcnt++;
		DUPRINT2(DB_RSC, "rsc: GDP nackcnt %x\n", nackcnt);
		/* request message already in canonical format due to
		   previous transmission,
		   we have to convert them back to local format
		   before sending them again */
		rffrcanon(rq_bp, GDP(sd->sd_queue)->hetero);

		if(u.u_procp->p_flag & SRSIG){	/*if signal msg already sent*/
			smsg = (struct message *)rq_bp->b_rptr;
			smsg->m_stat |= SIGNAL;				/*set signal bit*/
		}	
		goto sendit;

	/* server rec'd request. response coming */
	case DUGDPACK:
		freemsg (*rp_bp);
		freemsg (rq_bp);
		unclean = FALSE;
		goto getit;

	/* move data from kernel on remote machine to user on this machine */
	case DUREAD:
	case DUREADI:
		if(resp->rp_subyte)
			break;
	case DUCOPYOUT:
		if (u.u_error == 0 || resp->rp_errno == 0){
			if(u.u_procp->p_systemcall == DUREADI && uiop &&
				uiop->uio_seg != UIOSEG_USER)
				bcopy(resp->rp_data, resp->rp_bufptr, (unsigned)resp->rp_count);
			else
				u.u_error =  copyout(resp->rp_data,
					resp->rp_bufptr, (u_int)resp->rp_count);
		}
		if (resp->rp_opcode == DUCOPYOUT)  {
			/*  check if a response should be	
			 *  send back so that the
			 *  other end can do more copyout
			 */
			if (resp->rp_copysync) {
				nbp = reusebuf(rq_bp, sizeof(struct response)-DATASIZE);
				nresp = (struct response *) PTOMSG(nbp->b_rptr);
				nresp->rp_type = RESP_MSG;
				nresp->rp_opcode = DUCOPYOUT;
				if(sndmsg (gift, nbp, sizeof(struct response)
					-DATASIZE, (rcvd_t)NULL) == FAILURE)  {
					printf("rsc: copyout sndmsg on sd %x fail, remote syscall may hang\n",gift);
					freemsg (*rp_bp);
					ret = FAILURE;
					goto out;
				}
			}

			freemsg (*rp_bp);
			goto getit;
		}  else goto out;

	/*  copy from user on this machine to kernel on other machine	*/
	case DUCOPYIN:
	{
		char *from;
		int n;

		from = (char *)resp->rp_bufptr;
		n = resp->rp_count;
		for( ; n > 0; n -= DATASIZE, from += DATASIZE ){
			nbp = reusebuf (rq_bp, sizeof (struct response));
			nresp = (struct response *) PTOMSG(nbp->b_rptr);
			nresp->rp_type = RESP_MSG;
			nresp->rp_opcode = DUCOPYIN;
			nresp->rp_count = (n > DATASIZE) ? DATASIZE : n;
			nresp->rp_errno = 0;
			if (u.u_procp->p_systemcall == DUWRITEI && uiop &&
				uiop->uio_seg != UIOSEG_USER)
			      bcopy(from, nresp->rp_data, (unsigned)nresp->rp_count);
			else {
				if(nresp->rp_errno = copyin((caddr_t)from,
					(caddr_t)nresp->rp_data, (u_int)nresp->rp_count) )
						nresp->rp_count = 0;
			}
			if(sndmsg (gift, nbp, (int)(sizeof(struct response) -
				DATASIZE + nresp->rp_count), (rcvd_t)NULL) == FAILURE) {
				freemsg(*rp_bp);
				ret = FAILURE;
				goto out;
			}
		}
		freemsg (*rp_bp);
		goto getit;
	}
	} /* end of switch */

out:	if (unclean)
		freemsg (rq_bp);
	u.u_procp->p_flag &= ~SRSIG;	/*clear any remote signal flags*/	
	free_rcvd (rd);
	return (ret);
}
#endif	defined(SYSV) && defined(RFS)
