/*
 * rfs_vnodeops.c 87/01/27
 */


#if	defined(SYSV) && defined(RFS)
#include "../h/types.h"
#include "../h/param.h"
#include "../h/user.h"
#include "../h/file.h"
#include "../h/vnode.h"
#include "../h/vfs.h"
#include "../h/proc.h"
#include "../h/uio.h"
#include "../h/pathname.h"
#include "../ufs/inode.h"
#include "../sysv/sys/sema.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/rfsnode.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/stat.h"
#include "../sysv/sys/message.h"
#include "../sysv/sys/errno.h"

/*
 * These are the vnode ops routines which implement the vnode interface to
 * the remote file sharing.
 */

int	Rfs_open();
int	Rfs_close();
int	Rfs_rdwr();
int	Rfs_ioctl();
int	Rfs_select();
int	Rfs_getattr();
int	Rfs_setattr();
int	Rfs_access();
int	Rfs_lookup();
int	Rfs_create();
int	Rfs_remove();
int	Rfs_link();
int	Rfs_rename();
int	Rfs_mkdir();
int	Rfs_rmdir();
int	Rfs_readdir();
int	Rfs_symlink();
int	Rfs_readlink();
int	Rfs_fsync();
int	Rfs_inactive();
int	Rfs_bmap();
int	Rfs_badop();
int	Rfs_bread();
int	Rfs_brelse();
int	Rfs_lockctl();
int	Rfs_fid();
int	Rfs_getdents();

struct vnodeops rfs_vnodeops = {
	Rfs_open,
	Rfs_close,
	Rfs_rdwr,
	Rfs_ioctl,
	Rfs_select,
	Rfs_getattr,
	Rfs_setattr,
	Rfs_access,
	Rfs_lookup,
	Rfs_create,
	Rfs_remove,
	Rfs_link,
	Rfs_rename,
	Rfs_mkdir,
	Rfs_rmdir,
	Rfs_readdir,
	Rfs_symlink,
	Rfs_readlink,
	Rfs_fsync,
	Rfs_inactive,
	Rfs_bmap,
	Rfs_badop,
	Rfs_bread,
	Rfs_brelse,
	Rfs_lockctl,
	Rfs_fid,
	Rfs_getdents,
};

/*ARGSUSED*/
int
Rfs_inactive(vp, cred)
struct vnode *vp;
struct ucred *cred;
{
	register struct rfsnode *rp = VTORFS(vp);

	if(u.u_procp->p_universe != UNIVERSE_SYSV) 
		return(EINVAL);
	DUPRINT3(DB_RFSNODE, "Rfs_inactive: vp %x, rp %x\n", vp, rp);

	rfslock(rp);
	del_sndd(rp->rf_fsptr);	/* like duiput */
	rfsunlock(rp);

	rp->rf_fsptr = NULL;
	rfsunsave(rp);
	if (rp->rf_cred) {
		crfree(rp->rf_cred);
	}
	kmem_free((caddr_t)rp, (u_int)sizeof(struct rfsnode));
	return (u.u_error);
}

/*ARGSUSED*/
Rfs_lookup(dvp, nm, vpp, cred)
struct vnode *dvp;
char *nm;
struct vnode **vpp;
struct ucred *cred;
{
	register struct pathname *pnp;
	register u_int	len;

	pnp = u.u_rfspnp;	/* Set by lookuppn */
	len = strlen(nm);
	pnp->pn_path -= len;	/* Roll back the component */
	pnp->pn_pathlen += len;
	switch(rnamei1(dvp, vpp)) {
	case 0:	/* DOTDOT from server */
		return(EDOTDOT);	/* KLUDGE!! */

	default:
		return(u.u_error);
	}
}

Rfs_badop()
{
	panic("bad RFS op");
}

/*ARGSUSED*/
int
Rfs_open(vpp, flag, cred)
struct vnode **vpp;
int flag;
struct ucred *cred;
{
	DUPRINT1(DB_FSS,"Rfs_open called\n");
	return(0);
}

/*ARGSUSED*/
int
Rfs_close(fp)
    struct file *fp;
{
	int	tmpsyscall;
	struct a {
		int	mode;
		int	count;
		off_t	offset;
	} temp;

	DUPRINT2 (DB_FSS,"Rfs_close called syscall %d\n",u.u_procp->p_systemcall);
	temp.mode = fp->f_flag;
	temp.count = fp->f_count;
	temp.offset = fp->f_offset; /* Not used */
	tmpsyscall = u.u_procp->p_systemcall;
	u.u_procp->p_systemcall = DUCLOSE; 
	u.u_rfspnp = NULL;
	rfs_trace (2, 0);
	remote_call((struct vnode *)fp->f_data, (caddr_t)&temp);
	rfs_trace (5, 0);
	u.u_procp->p_systemcall = tmpsyscall; 
	return(u.u_error);
}

/*ARGSUSED*/
int
Rfs_rdwr(vp, uiop, rw, ioflag, cred)
struct vnode *vp;
struct uio *uiop;
enum uio_rw rw;
int ioflag;
struct ucred *cred;
{
    	int ret;

	DUPRINT3 (DB_FSS,"Rfs_rdwr: vp = %x   sndd = %x \n",vp,VTORFS(vp)->rf_fsptr);
	if(rw == UIO_READ) {
		if (u.u_procp->p_systemcall != DUREAD) 
			u.u_procp->p_systemcall = DUREADI;
	} else {
		if (u.u_procp->p_systemcall != DUWRITE) 
			u.u_procp->p_systemcall = DUWRITEI;
	}
	/************
	if(ip->i_ftype & IFIFO)
		prele(ip);
	*************/
	ret = remfileop(vp, ioflag, uiop);
	/***************
	if(ip->i_ftype & IFIFO)
		plock(ip);
	***************/
	return (ret);
}

/*ARGSUSED*/
int
Rfs_ioctl(vp, com, data, flag, cred)
struct vnode *vp;
int com;
caddr_t data;
int flag;
struct ucred *cred;
{
    int ret;

    DUPRINT4 (DB_FSS,"Rfs_ioctl: vp %x cmd %x flag %x\n", vp, com, flag);
    ret = remfileop(vp, flag,NULL);
    DUPRINT2 (DB_FSS,"Rfs_ioctl: u.u_error = %d \n",u.u_error);
    return (ret);
}

int
Rfs_select()
{
	panic("bad RFS op - select\n");
}

/*ARGSUSED*/
int
Rfs_getattr(vp, vap, cred)
register struct vnode *vp;
register struct vattr *vap;
struct ucred *cred;
{
	struct uio auio;
	struct iovec aiov;
	struct sysv_stat sb;
	register struct sysv_stat *sbp;
	int tsyscall;

	aiov.iov_base = (caddr_t)(sbp = &sb);
	auio.uio_iov = &aiov;
	auio.uio_iovcnt = 1;
	auio.uio_offset = 0;
	auio.uio_seg = UIOSEG_KERNEL;
	aiov.iov_len = auio.uio_resid = sizeof(struct sysv_stat);
	tsyscall = u.u_procp->p_systemcall;
	u.u_procp->p_systemcall = DUFSTAT;
	remfileop(vp, 0, &auio);
	u.u_procp->p_systemcall = tsyscall;
	if(!u.u_error) {
		vap->va_type = vp->v_type;
		vap->va_mode = sbp->st_mode;
		vap->va_uid = sbp->st_uid;
		vap->va_gid = sbp->st_gid;
		vap->va_fsid = sbp->st_dev;
		vap->va_nodeid = sbp->st_ino;
		vap->va_nlink = sbp->st_nlink;
		vap->va_size = sbp->st_size;
		vap->va_blocksize = vp->v_vfsp->vfs_bsize;
		vap->va_atime.tv_sec = sbp->st_atime;
		vap->va_mtime.tv_sec = sbp->st_mtime;
		vap->va_ctime.tv_sec = sbp->st_ctime;
		vap->va_atime.tv_usec =
		vap->va_mtime.tv_usec =
		vap->va_ctime.tv_usec = 0;
		vap->va_rdev = sbp->st_rdev;
		vap->va_blocks = -1;	/* Don't know as of now */
	}
	return (u.u_error);
}

int
Rfs_setattr(vp, vap, cred)
struct vnode *vp;
struct vattr *vap;
struct ucred *cred;
{
	DUPRINT1(DB_FSS,"Rfs_setattr called\n");
	return(0);
}

/*
 * Rfs_access: Checking access permissions. Note NFS has more elaborate
 *		checks.
 */
/*ARGSUSED*/
int
Rfs_access(vp, mode, cred)
struct vnode *vp;
int mode;
struct ucred *cred;
{
	register struct sndd *duip = (struct sndd *)VTORFS(vp)->rf_fsptr;

	DUPRINT3 (DB_FSS,"Rfs_access: vp %x, rp %x\n",vp, VTORFS(vp));
	switch (mode) {
	case ISUID:
	case ISGID:
	case ISVTX: 
		return (!(duip->sd_mode & mode));
	}
	return (0);
}

int
Rfs_create(dvp, nm, vap, exclusive, mode, vpp, cred)
struct vnode *dvp;
char *nm;
struct vattr *vap;
enum vcexcl exclusive;
int mode;
struct vnode **vpp;
struct ucred *cred;
{
	if (vap != (struct vattr *)0) {
		(void) VOP_GETATTR(*vpp, vap, cred);
	}
	DUPRINT1(DB_FSS,"Rfs_create called\n");
	return(0);
}

int
Rfs_remove()
{
	panic("bad RFS op - remove\n");
}

int
Rfs_link()
{
	panic("bad RFS op - link\n");
}

int
Rfs_rename()
{
	panic("bad RFS op - rename\n");
}

int
Rfs_mkdir()
{
	panic("bad RFS op - mkdir\n");
}

int
Rfs_rmdir()
{
	panic("bad RFS op - rmdir\n");
}

int
Rfs_readdir()
{
	panic("bad RFS op - readdir\n");
}

int
Rfs_symlink()
{
	panic("bad RFS op - symlink\n");
}

int
Rfs_readlink()
{
	panic("bad RFS op - readlink\n");
}

int
Rfs_fsync()
{
	panic("bad RFS op - fsync\n");
}

int
Rfs_bmap()
{
	panic("bad RFS op - bmap\n");
}

int
Rfs_bread()
{
	panic("bad RFS op - bread\n");
}

int
Rfs_brelse()
{
	panic("bad RFS op - brelse\n");
}

int
Rfs_lockctl(vp, lckdat, cmd, cred)
struct vnode *vp;
struct flock *lckdat;
int cmd;
struct ucred *cred;
{
    int ret;
	/* For Rfs the locks are released at close time
	 * So neglect this if the it is not FCNTL
	 */
	if(u.u_procp->p_systemcall == DUFCNTL) {
		DUPRINT3(DB_FSS,"Rfs_lockctl: vp %x cmd %x\n", vp, cmd);
		ret = remfileop(vp, NULL, (struct uio *)NULL);
		DUPRINT2(DB_FSS,"Rfs_lockctl: u.u_error = %d \n",u.u_error);
	}
	return (ret);
}

int
Rfs_fid()
{
	panic("bad RFS op - fsid\n");
}

int
Rfs_getdents(vp, uiop, cred, compat)
register struct	vnode *vp;
register struct uio *uiop;
struct	cred *cred;
int compat;
{
	DUPRINT2 (DB_FSS,"\nRfs_getdents vp %x\n", vp);
	remfileop (vp, NULL, uiop);
	uiop->uio_resid -= u.u_r.r_val1;
	return (u.u_error);
}
#endif	defined(SYSV) && defined(RFS)
