/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:nudnix/rfadmin.c	1.23"		*/
#if	defined(SYSV) && defined(RFS)
/*
 *	Kernel daemon for remote-file administration.
 */

#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../h/param.h"
#include "../sysv/sys/stream.h"
#include "../sysv/sys/comm.h"
#include "../h/user.h"
#include "../sysv/sys/message.h"
#include "../sysv/sys/errno.h"
#include "../h/proc.h"
#include "../machine/board.h"
#include "../h/mbuf.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/recover.h"
#include "../sysv/sys/cirmgr.h"
#include "../sysv/sys/adv.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/rfsys.h"
#include "../sysv/sys/tihdr.h"
#include "../sysv/sys/que.h"
	/***********************
	#include "sys/immu.h"
	#include "sys/region.h"
	#include "sys/signal.h"
	#include "sys/file.h"
	#include "sys/fs/s5dir.h"
	#include "sys/psw.h"
	#include "sys/pcb.h"
	#include "sys/inode.h"
	#include "sys/var.h"
	***********************/


extern	struct timeval	time;
extern	int	nservers;		/* current number of servers */
extern	int	idleserver;		/* number of idle servers */
extern	int	msglistcnt;		/* number of msgs in msglist */
extern	int	minserve, maxserve;	/* fewest, most servers in the system */
extern	int	bootstate;		/* state of RFS -- up, down, or inter */
extern struct proc *rec_proc;		/* pointer to recovery process */

int	nzombcnt;			/* how many zombie servers */
rcvd_t	rd_recover;			/* rd for daemon */
struct proc *rfsdp;			/* pointer to daemon process */
struct vnode *rfs_cdir;			/* server current directory */
int 	msgflag;			/* create server if set */
struct proc *s_active;			/* pointer to active servers */
struct proc *s_zombie;			/* pointer to zombie children */
sema_t rfadmin_sema;
struct bqctrl_st rfmsgq;		/* queue for user-level daemon */
int	rfmsgcnt;			/* how many msgs in user-level q */

void reply(), user_msg(), que_umsg();
extern void serv_fumount ();

/*
 *	File sharing daemon, started when file sharing starts.
 */

void
rfdaemon ()
{
	int	i,s,size;
	struct sndd reply_port;
	mblk_t	*bp;
	queue_t	*qp;
	struct request *request;
	struct response *response;
	mblk_t	*resp_bp;
	char usr_msg [ULINESIZ]; /* tmp space for user daemon message */
	register struct proc *p;

	extern int  nservers, msglistcnt;
	extern struct gdp gdp[];
	extern void cl_fumount();
	extern char *strncpy();

	/* disassociate this process from terminal */
	p = u.u_procp;
	p->p_flag |= SLOAD|SSYS;
	p->p_pgrp = p->p_pid;
	setctx(p->p_context = CTX_SYS);
	/*	strcpy(u.u_comm, "rfdaemon");	*/

	u.u_ap = u.u_arg;

	/* ignore all signals */
	for (i=0; i<NSIG; i++)
		u.u_signal[i] = SIG_IGN;

	nzombcnt = 0;
	msgflag = NULL;
	s_zombie = NULL;

	creat_server (minserve);

	/* Make user-daemon queue null. */
	while ((bp = (mblk_t *)deque ((QCTRL *)&rfmsgq)) != (mblk_t *)NULL) {
		DUPRINT1 (DB_RFSYS, "discarding old user-level message\n");
		freemsg (bp);
	}
	rfmsgq.qc_head = (struct msgb *) NULL;
	rfmsgq.qc_tail = (struct msgb *) NULL;
	rfmsgcnt = 0;
	bootstate = DU_UP;
	wakeup((caddr_t)&bootstate);	/* end of critical section begun in rfstart */

	for (;;) {
		/***	ASSERT(noilocks() == 0);	***/
		/* raise priority because vsema is called from gdpserv */
		s = spl5();
		u.u_error = 0;
		sleep((caddr_t)&rd_recover->rd_qslp, PRIBIO);
	loop:
		/***	ASSERT(noilocks() == 0);	***/
		bp = NULL;
		(void)dequeue(rd_recover, &bp, &reply_port, &size);
		if (nzombcnt)
			clean_proc_table ();
		if(bp) {
			splx(s);
			qp = (queue_t *)((struct message *)bp->b_rptr)->m_queue;
			request = (struct request *)
				  (bp->b_rptr + sizeof (struct message));
			DUPRINT4(DB_RECOVER, "rfadmin: bp %x qp %x rptr %x\n",
					bp, qp, bp->b_rptr);
			switch (request->rq_opcode ) {
			case REC_FUMOUNT:
				{
				register struct rfsmount *mp;
				mp = &rfsmount[request->rq_mntindx];
				cl_fumount ((index_t)request->rq_mntindx,
						(index_t)request->rq_srmntindx);
				freemsg (bp);
				reply (&reply_port, REC_FUMOUNT);
				user_msg ((long)RF_FUMOUNT, mp->m_name, NMSZ);
				break;
				}
			case REC_MSG:
				{
				int size;

				/* Got a message for user-level daemon.
				 * Enque message and wake up daemon.
 				 */
				DUPRINT1 (DB_RFSYS,
				"rfadmin: got a message for user daemon \n");
				size = request->rq_count;
				/* save message so we can free stream buf */
				(void)strncpy (usr_msg, request->rq_data, (u_int)size);
				freemsg (bp);
				reply (&reply_port, REC_MSG);
				user_msg ((long)RF_GETUMSG, usr_msg, size);
				break;
				}
			case DUSYNCTIME:
				DUPRINT1(DB_RFSYS, "rfadmin: date sync\n");
				GDP(qp)->time = request->rq_synctime - time.tv_sec;
				/*alocbuf and send reply */
				while ((resp_bp = alocbuf (sizeof (struct response) - DATASIZE, BPRI_MED)) == NULL) {
					u.u_procp->p_sig = u.u_procp->p_cursig = 0;
				}
				response = (struct response *)PTOMSG(resp_bp->b_rptr);
				response->rp_type = RESP_MSG;
				size = sizeof (struct response) - DATASIZE;
		 		response->rp_opcode = DUSYNCTIME;
				response->rp_synctime = time.tv_sec;
				response->rp_errno = 0;
				response->rp_sig = 0;
				freemsg (bp);
				(void)sndmsg (&reply_port, resp_bp, size,
					(rcvd_t)NULL);
				break;
			default:
				u.u_error = EINVAL;
				DUPRINT2 (DB_RFSYS, "rfadmin: unknown opcode %d\n",
					request->rq_opcode);
				freemsg (bp);
			}
		} else {
			if (!msgflag) {
				splx(s);
				continue;
			}
			if (msgflag & DISCONN) {
				register struct gdp *tmp;
				msgflag &= ~DISCONN;
				splx(s);
				for(tmp = gdp; tmp < &gdp[maxgdp]; tmp++)
					if(tmp->flag & GDPDISCONN) {
						rfscleanup (tmp->queue);
						tmp->flag = GDPRECOVER;
					}
			}
			else if (msgflag & RFSKILL) {
				 DUPRINT1(DB_RECOVER, "rfadmin: KILL case\n");
				msgflag = NULL;
				splx(s);
				gsignal (rfsdp->p_pgrp,SIGKILL);
				rfsdp = NULL;
				if (rec_proc == NULL) {
					bootstate = DU_DOWN;
					wakeup((caddr_t)&bootstate);
				}
				exit(0);
			}
			else if (msgflag & MORE_SERVE) {
				msgflag &= ~MORE_SERVE;
				splx(s);
				if(idleserver <= 1 && nservers < maxserve)
					creat_server(1);
			}
		}
		s = spl5();
		goto loop;
	}
}

/*
 *	Create num servers.
 */

creat_server(num)
int num;
{
	int i;

	DUPRINT2 (DB_SERVE,"create %d server(s) \n", num);
	for (i = 0; i < num; i++) {	/* make minimum server */
		u.u_r.r_val1 = 0;
		switch (fork1 (0)) {
		      	default:
				nservers++;
				break;
			case 1:
				u.u_procp->p_flag |= SSYS|SLOAD;
				/*	?setctx(p->p_context = CTX_SYS); */
				u.u_ru.ru_utime.tv_sec =
				u.u_ru.ru_utime.tv_usec =
				u.u_ru.ru_stime.tv_sec =
				u.u_ru.ru_stime.tv_usec =
				u.u_cru.ru_utime.tv_sec =
				u.u_cru.ru_utime.tv_usec =
				u.u_cru.ru_stime.tv_sec =
				u.u_cru.ru_stime.tv_usec = 0;
				u.u_procp->p_minwd = NULL;
				(void)serve();
			case 0:
				DUPRINT1(DB_SERVE,"cannot create server \n");
				/* post a signal to the last server so it won't go
				   to sleep */
				if (s_active)
					psignal(s_active, SIGUSR1);
				break;
		}
	}
}

/*
 *	Free zombie servers.
 */

clean_proc_table()
{
	struct proc *curproc;
	void freeprocent();

	DUPRINT2 (DB_SERVE, "clean_proc_table: nzombcnt %d\n", nzombcnt);
	curproc = rfsdp->p_cptr;
	while (curproc != NULL)  {
		if (curproc->p_stat == SZOMB) {
			freeprocent(curproc);
			nzombcnt--;
			curproc = rfsdp->p_cptr;
		} else
			curproc = curproc->p_osptr;
	}
}

/*
 * Do not use the following routine for normal processes, it's meant only
 * for RFS servers
 */

static void
freeprocent(p)
register struct proc *p;
{
	register struct proc *q;

	u.u_r.r_val1 = p->p_pid;
	u.u_r.r_val2 = p->p_xstat;
	p->p_xstat = 0;
	if (p->p_ru) {
		ruadd(&u.u_cru, p->p_ru);
		(void) m_free(dtom(p->p_ru));
		p->p_ru = 0;
	}
	p->p_stat = NULL;
	p->p_pid = 0;
	p->p_ppid = 0;
	/*
	 * The following four lines are new as of 17-Dec-1987.
	 * Over a period of time as rfs servers exited they would take
	 * one processes with them.  It would never be found again!
	 */
	if (*p->p_prev = p->p_nxt)	/* off zombproc */
	  p->p_nxt->p_prev = p->p_prev;
	p->p_nxt = freeproc;		/* onto freeproc */
	freeproc = p;
	if (q = p->p_ysptr)
		q->p_osptr = p->p_osptr;
	if (q = p->p_osptr)
		q->p_ysptr = p->p_ysptr;
	if ((q = p->p_pptr)->p_cptr == p)
		q->p_cptr = p->p_osptr;
	p->p_pptr = 0;
	p->p_ysptr = 0;
	p->p_osptr = 0;
	p->p_cptr = 0;
	p->p_sig = 0;
	p->p_sigcatch = 0;
	p->p_sigignore = 0;
	p->p_sigmask = 0;
	p->p_pgrp = 0;
	p->p_flag = 0;
	p->p_wchan = 0;
	p->p_cursig = 0;
}

/*
 *	Send reply with opcode over destination SD.
 */

void
reply (dest, opcode)
sndd_t	dest;		/* reply path */
int	opcode;		/* what we did */
{
	mblk_t	*resp_bp;
	struct response *response;
	int	size;

	/*alocbuf and send reply */
	while ((resp_bp = alocbuf (sizeof (struct response) - DATASIZE, BPRI_MED)) == NULL) {
		u.u_procp->p_sig = u.u_procp->p_cursig = 0;
	}
	response = (struct response *)PTOMSG(resp_bp->b_rptr);
	response->rp_type = RESP_MSG;
	size = sizeof (struct response) - DATASIZE;
	response->rp_opcode = opcode;
	response->rp_errno = 0;
	response->rp_sig = 0;
	(void)sndmsg (dest, resp_bp, size, (rcvd_t)NULL);
}

/*
 *	Create message for local user-level daemon, and enque it.
 */

void
user_msg (opcode, name, size)
long opcode;
char *name;
int  size;
{
	mblk_t	*bp;
	struct u_d_msg *request;

	if ((bp = allocb (sizeof(struct u_d_msg),BPRI_MED)) == NULL) {
		printf ("user_msg allocb fails: ");
		printf ("resource %s has been disconnected \n", name);
		return;
	}
	request = (struct u_d_msg *) bp->b_wptr;
	request->opcode = opcode;
	strcpy (request->res_name, name);
	request->count = size;
	que_umsg (bp);
}

/*
 *	If there's room on user_daemon queue, enque message and wake daemon.
 */

static void
que_umsg (bp)
mblk_t	*bp;
{
	register int s;
	struct u_d_msg *request;

	s = splrf ();
	request = (struct u_d_msg *) bp->b_wptr;
	if (rfmsgcnt > maxgdp) {
		printf ("rfs user-daemon queue overflow: ");
		printf ("make sure rfudaemon is running\n ");
		DUPRINT3 (DB_RFSYS, "opcode %d, name %s\n",
			request->opcode, request->res_name);
		freemsg (bp);
		splx (s);
		return;
	}
	++rfmsgcnt;
	DUPRINT2 (DB_RFSYS,
		"que_umsg: enque msg for user-daemon, count %d\n", rfmsgcnt);
	enque ((QCTRL *)&rfmsgq, (QITEM *)bp);
	splx (s);
	cvsema((caddr_t)&rfadmin_sema);
}
#endif	defined(SYSV) && defined(RFS)
