#if	defined(SYSV) && defined(RFS)
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)kern-port:nudnix/fileop.c	10.17"	*/

#include "../h/types.h"
#include "../sysv/sys/sema.h"
#include "../h/param.h"
#include "../sysv/sys/systm.h"
#include "../sysv/sys/errno.h"
#include "../h/file.h"
#include "../sysv/sys/idtab.h"
#include "../sysv/sys/stream.h"
#include "../h/user.h"
#include "../sysv/sys/nserve.h"
#include "../sysv/sys/cirmgr.h"
#include "../sysv/sys/message.h"
#include "../h/vnode.h"
#include "../h/vfs.h"
#include "../h/proc.h"
#include "../sysv/sys/mount.h"
#include "../sysv/sys/stat.h"
#include "../sysv/sys/region.h"
#include "../sysv/sys/debug.h"
#include "../sysv/sys/rdebug.h"
#include "../sysv/sys/sysinfo.h"
#include "../sysv/sys/comm.h"
#include "../sysv/sys/rfsnode.h"
#include "../sysv/sys/sysmacros.h"
#include "../h/uio.h"
#undef	NFS
#include "../h/mount.h"

	/**************************************************
	#include "sys/fs/s5dir.h"
	#include "sys/signal.h"
	#include "sys/sbd.h"
	#include "sys/immu.h"
	#include "sys/psw.h"
	#include "sys/pcb.h"
	#include "sys/inode.h"
	#include "sys/var.h"
	**************************************************/

/*  remote file operation
 *  Set up arguments from u area (later using common message builder)
 *  and send a message across requesting the operation.  If it's a
 *  write, send the first DATASIZE bytes of data.
 *  The message that comes back could have the answer to the request,
 *  or may need to transfer some information into or from user space.
 *  So COPYIN and COPYOUT messages may come back from the server as
 *  part of this system call.  The operation is done when the "more"
 *  flag is clear in the response.
 */

remfileop (vp,flag,uiop)
register struct vnode *vp;
register flag;
register struct uio *uiop;
{
	register struct sndd *sd = (struct sndd *)(VTORFS(vp))->rf_fsptr;
	mblk_t	*bp;
	mblk_t	*in_bp;
	register struct	request	*req;	/* request message to the server */
	register struct	response *resp;	/* response message from the server */
	register int	size = 0;	/* for de_queue, received size	*/
	sndd_t	gift = NULL;		/* return value of de_queue */
	register int	ret;		/* return instead of longjmp */

	if(u.u_procp->p_universe != UNIVERSE_SYSV) {
		u.u_error = EINVAL;
		return(FAILURE);
	}
	DUPRINT3(DB_SYSCALL, "remfileop: syscall = %d (%s)\n", 
			u.u_procp->p_systemcall, sysname(u.u_procp->p_systemcall));
	if (server()) {	/* if on server, this is multihop	*/
		u.u_error = EMULTIHOP;
		return(FAILURE);
	}
	sysinfo.fileop++;
	/* get a buffer for the request
	 */
	bp = alocbuf(sizeof (struct request), BPRI_LO);
	if (bp == NULL) {
		u.u_error = EINTR;
		return(FAILURE);
	}
	req = (struct request *)PTOMSG(bp->b_rptr);
	req->rq_type = REQ_MSG;
	/*  fill in u arguments  */
	req->rq_opcode = u.u_procp->p_systemcall;
	req->rq_sysid = get_sysid(sd);
	req->rq_uid = u.u_uid;
	req->rq_gid = u.u_gid;
	req->rq_ulimit = (u.u_rlimit[RLIMIT_FSIZE].rlim_max) >> 9;
	req->rq_mntindx = sd->sd_mntindx;
	if ((size = filluargs (bp, &gift, flag, uiop)) == -1) {
		freemsg (bp);
		return(FAILURE);
	}
	dinfo.osyscall++;		/* outgoing system calls */

#ifdef notdef
	rfslock (VTORFS(vp));
#endif
	/*  send the message and wait for the response  */
	if(rsc(sd, bp, sizeof (struct request) - DATASIZE + size, &in_bp,
			gift, uiop) == FAILURE)  {
		if (gift)
			free_sndd (gift);
		rfsunlock(VTORFS(vp));
		return(FAILURE);
	}

	/*  now take the arguments out of the message and put back  into
	 *  u area.
	 */
	resp = (struct response *)PTOMSG(in_bp->b_rptr);
	if (gift)
	  	free_sndd (gift);
	ret = replyuargs (resp, in_bp, vp, uiop);
	freemsg (in_bp);
#ifdef notdef
	rfsunlock(VTORFS(vp));
#endif

	/* Normally longjmp back to trap.c/syscall - we's done.
	 * readi/writei and errors return.
	 */
	if (ret)
		return (u.u_error);
	else  {
		u.u_rflags |= U_RSYS;
		VN_RELE(vp);
		longjmp (&u.u_qsave, 1);
	}
}

/*  set values in the message based on the system call.
 *  These are the file descriptor system calls.
 *  The server recreates the file descriptor before calling the system call.
 */

/*static*/
filluargs (bp, gift, flag, uiop)
mblk_t	*bp;
sndd_t	*gift;
register flag;
register struct uio *uiop;
{
	register struct	request	*req;
	register int	size = 0; /* how much more than sizeof struct request 
				     in msg */

	req = (struct request *)PTOMSG(bp->b_rptr);
	switch (u.u_procp->p_systemcall) {
	case	DUFCNTL:
	{
		register struct a { int fdes; int cmd; int arg; } 
		*uap = (struct a *) u.u_ap;
		register struct file *fp;

		GETF(fp, uap->fdes);
		if ((*gift = cr_sndd ()) == NULL){
			u.u_error = ENOMEM;
			return(-1);
		}
		req->rq_cmd = uap->cmd;
		req->rq_fcntl = uap->arg;
		req->rq_fflag = fp->f_flag;
		req->rq_foffset = fp->f_offset;
		break;
	}
	case	DUFSTAT:
	{
		/* It is actually getattr */

		req->rq_bufptr = (long)(uiop->uio_iov->iov_base);
		break;
	}
	case	DUSEEK:
		req->rq_whence = 2;
		break;
	case	DUFSTATFS:
	{
		req->rq_bufptr = (int) uiop->uio_iov->iov_base;
		req->rq_len = uiop->uio_iov->iov_len;
		req->rq_fstyp = MOUNT_RFS;
		break;
	}
	case	DUGETDENTS:
	{
		register struct	a { int fdes; char *cbuf; unsigned count; } 
		*uap = (struct a *) u.u_ap;
		if ((*gift = cr_sndd()) == NULL) {
			u.u_error = ENOMEM;
			return (-1);
		}
		req->rq_offset = uiop->uio_offset;
		req->rq_base = (int) uap->cbuf;
		req->rq_count = uap->count;
		break;
	}
	case	DUIOCTL:
	{
		register struct a { int fdes; int cmd; caddr_t arg; } 
		*uap = (struct a *) u.u_ap;

		if((*gift = cr_sndd()) == NULL){
			u.u_error = ENOMEM;
			return(-1);
		}
		req->rq_cmd = uap->cmd;
		req->rq_ioarg = (int) uap->arg;
		req->rq_fflag = flag;
		break;
	}
	case    DUUTSSYS:  /*  only ustat() gets this far  */
	{
		register struct a { char *cbuf; int dev; int cmd; } 
		*uap = (struct a *) u.u_ap;
		short dev;
		dev = (short)uap->dev;
		req->rq_dev =  lobyte(dev);
		req->rq_bufptr = (int) uap->cbuf;
		break;
	}
	case 	DUREAD:
	case	DUWRITE:
	{
	    	register struct a {
			int fdes;
			char *ptr;
			int count;
	    	} *uap = (struct a *)u.u_ap;
	    	struct file *fp;
	    
		GETF(fp, uap->fdes);
		req->rq_fmode = fp->f_flag;
		goto mainbody;
	}

	case	DUREADI:
		req->rq_fmode = FREAD;
		goto mainbody;

      	case	DUWRITEI:
	    req->rq_fmode = FWRITE;
mainbody:
	    if ((*gift = cr_sndd()) == NULL) {
		u.u_error = ENOMEM;
		return (-1);
	    }
	    req->rq_base = (int)uiop->uio_iov->iov_base;
	    req->rq_offset = uiop->uio_offset;
	    req->rq_count = uiop->uio_iov->iov_len;
	    if (flag & IO_NDELAY)
	      req->rq_fmode |= FNDELAY;
	    if(flag & IO_APPEND)
	      req->rq_fmode |= FAPPEND;
	    /*  if writei, copy the first DATASIZE bytes into msg	*/
	    if (u.u_procp->p_systemcall == DUWRITEI || 
		u.u_procp->p_systemcall == DUWRITE)  {
		    size = (req->rq_count > DATASIZE) ? DATASIZE : req->rq_count;
		    req->rq_prewrite = size;  /* amount of data present */
		    if (uiop->uio_seg == UIOSEG_USER)  {
			if(u.u_error = copyin(req->rq_base,
					      req->rq_data, size)) {
						  free_sndd (*gift);
						  return(-1);
					      }
		    } else	
		      bcopy (req->rq_base, req->rq_data, size);
		}
	    if (u.u_procp->p_systemcall == DUREAD)
	      dinfo.osysread++;	/* outgoing read's */
	    else if (u.u_procp->p_systemcall == DUWRITE)
	      dinfo.osyswrite++;	/* outgoing write's */
	    else
	      dinfo.osyscall--;	/* not a sect. 2 syscall; 
				   rescind inc */
	    break;
	      
	}  /*  end switch  */
	return (size);
}

/*  Depending on the system call, set necessary u area arguments to 
 *  finish the system call.
 * 
 *  Return value FALSE tells remfileop to do longjump.
 *  Return value TRUE causes return to caller.
 */

/*static*/
replyuargs (resp,in_bp,vp,uiop)
struct	response *resp;
mblk_t	*in_bp;
register struct vnode *vp;
register struct uio *uiop;
{
	register int ret = FALSE;  /* TRUE for readi/writei/iomove and error */
	u.u_procp->p_sig |= resp->rp_sig;
	DUPRINT3(DB_SIGNAL,"replyuarg: rp_sig=%x,p_sig=%x\n",resp->rp_sig,u.u_procp->p_sig);
	switch (u.u_procp->p_systemcall)  {

	case DUSEEK:	
	{
		register struct a  { int fdes; off_t off; int sbase; } 
		*uap = (struct a *)u.u_ap;
		uap->off += resp->rp_rval;
	}
	case DUFCNTL:
		/*	ret = TRUE;	/* We need a long jmp	*/
	case DUIOCTL:
		if (!u.u_error && !resp->rp_errno)
			VN_HOLD(vp); /* To avoid release at longjmp time */
		break;
	case DUFSTAT:
	{
		struct sysv_stat *statptr = (struct sysv_stat *) resp->rp_data;
		struct gdp *gp = (struct gdp *) ((queue_t *)((struct message *)
					in_bp->b_rptr)->m_queue)->q_ptr;
		extern struct gdp gdp[];

		hibyte (statptr->st_dev)  = ~(gp - gdp);
		if (resp->rp_errno == 0)
			if(uiop->uio_seg == UIOSEG_USER)
				resp->rp_errno = copyout(resp->rp_data,
					  resp->rp_bufptr, resp->rp_count);
			else
				bcopy(resp->rp_data,
					  resp->rp_bufptr, resp->rp_count);
		ret = TRUE;	/* Our implementation should not do longjmp */
		break;
	}
	case DUFSTATFS:
		if (resp->rp_errno == 0)
			if(uiop->uio_seg == UIOSEG_USER)
				resp->rp_errno = copyout(resp->rp_data,
					  resp->rp_bufptr, resp->rp_count);
			else
				bcopy(resp->rp_data,
					  resp->rp_bufptr, resp->rp_count);
		ret = TRUE;	/* Our implementation should not do longjmp */
		break;
	case DUGETDENTS:
	{
		register int i;
		  
		if (resp->rp_rval > 0)  {
			if(uiop->uio_seg == UIOSEG_USER)
				resp->rp_errno = copyout(resp->rp_data,
					  resp->rp_bufptr, resp->rp_count);
			else
				bcopy(resp->rp_data, resp->rp_bufptr,
							resp->rp_count);
		}
		if((u.u_r.r_val1 = resp->rp_rval) > 0)
			uiop->uio_offset = resp->rp_offset;
/*******************
		u.u_ioch += (unsigned) u.u_r.r_val1;
*******************/
		ret = TRUE;
		break;
	}
	case DUUTSSYS:	/*  only ustat() gets this far  */
	{
		struct ustat  {
			daddr_t	f_tfree;
			ushort	f_tinode;
			char	f_fname[6];
			char	f_fpack[6];
		};
		struct a { struct ustat *usb; int dev; int cmd; } *uap =
		  (struct a *) u.u_ap;

		ASSERT(uiop == NULL);
		if (resp->rp_errno == 0)
			resp->rp_errno = copyout(resp->rp_data, resp->rp_bufptr,
							sizeof(struct ustat));
		if (resp->rp_errno)
			free_sndd((sndd_t *)(VTORFS(vp))->rf_fsptr);
		break;
	}
	case DUREAD:
		dinfo.oreadch += (uiop->uio_iov->iov_len - resp->rp_rval);	/* ch's read by outgoing read's */
	case DUREADI:
		uiop->uio_offset += uiop->uio_iov->iov_len - resp->rp_rval;
		uiop->uio_resid = resp->rp_rval;
		ret = TRUE;
		break;
	case DUWRITE:
	    {
	    	struct file *fp;
		register struct a {
			int	fdes;
			char	*cbuf;
			unsigned count;
		} *uap = (struct a *) u.u_ap;
		GETF(fp, uap->fdes);
		if (fp->f_flag & FAPPEND) {
		    uiop->uio_offset = resp->rp_isize -
		      (uiop->uio_iov->iov_len - resp->rp_rval);
		}
		dinfo.owritech += (uiop->uio_iov->iov_len - resp->rp_rval);	/* ch's written by outgoing write's */
	    }
	case DUWRITEI:
		uiop->uio_offset += uiop->uio_iov->iov_len - resp->rp_rval;
		uiop->uio_resid = resp->rp_rval;
			
		ret = TRUE;
		break;
	}  /*  end switch  */
	if (u.u_error || (u.u_error = resp->rp_errno))
		ret = TRUE;
	return (ret);
}
#endif	defined(SYSV) && defined(RFS)
