#ifdef	SYSV
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "../h/types.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/buf.h"
#include "../h/vfs.h"
#include "../h/vnode.h"
#include "../h/proc.h"
#include "../h/uio.h"
#include "../h/conf.h"
#include "../h/kernel.h"
#include "../h/cmap.h"
#include "../h/file.h"
#include "../ufs/fs.h"
#include "../ufs/inode.h"
#include "../ufs/mount.h"
#include "../ufs/fsdir.h"
#ifdef	QUOTA
#include "../ufs/quota.h"
#endif	QUOTA
#include "../sysv/sys/dirent.h"
#include "../sysv/sys/fs/s5dir.h"

extern int dirchk;

/*
 * Read a System V directory using either 16 byte fixed format or floating
 * format used by getdents.  Three offsets are kept up to date.  First is
 * the real fp offset that is returned by VOP_READDIR.  The second offset is
 * the position into the buffer.  The third is a System V fixed format offset.
 */

s5getdents(vp, uio, cred, compat)
struct	vnode *vp;
register struct uio *uio;
struct	cred *cred;
int compat;
{
	register struct direct *dp = NULL;
	register unsigned count, offset;
	register long bp, base, i, eob, error = 0;
	register union a {
		struct dirent dirent;
		struct sysv_direct s5dir;
	} *entryptr, *saventryptr;
	u_int n;     /* # of bytes in the buffer where entries are collected */
	u_int reclen;	/* For dirent structure */
	int buf_offset, sysv_offset, real_offset;
	struct uio auio;
	struct iovec aiov;

#ifdef	TRFS
	u.u_pdir = vp;	/* KLUDGE: need to know it's a dir op at copyout time */
#endif	TRFS
	base = (long)uio->uio_iov->iov_base;
	count = uio->uio_iov->iov_len;
	offset = uio->uio_offset;
	bp = (long)kmem_alloc(2*DIRBLKSIZ);
	/* Take half of allocated memory! */
	saventryptr = entryptr = (union a *)((long)bp + DIRBLKSIZ);
	bzero(saventryptr, DIRBLKSIZ);
	n = 0;
	auio.uio_offset = real_offset = uio->uio_offset;
	buf_offset = uio->uio_offset_buf;
	sysv_offset = uio->uio_offset_sysv;
	while (count > 0) {
		if (dp == NULL || (long)dp >= eob) {
			/*
			 * Reset buf_offset when reading new buffer.
			 */
			if (dp != NULL)
			  buf_offset = 0;
			auio.uio_iov = &aiov;
			auio.uio_seg = UIOSEG_KERNEL;
			real_offset = auio.uio_offset;
			auio.uio_iovcnt = 1;
			auio.uio_iov->iov_base = (caddr_t)bp;
			auio.uio_resid = auio.uio_iov->iov_len = DIRBLKSIZ;
			if (error = VOP_READDIR(vp, &auio, cred))
			  break;

			dp = (struct direct *) (bp + (buf_offset & (DIRBLKSIZ-1)));
			eob = bp + DIRBLKSIZ - auio.uio_resid;
			if ((long)dp >= eob)
				break;
		}
		i = DIRBLKSIZ - (buf_offset & (DIRBLKSIZ - 1));
		if ((dp->d_reclen & 0x3) || dp->d_reclen == 0 ||
		    dp->d_reclen > i || DIRSIZ(dp) > dp->d_reclen ||
		    dirchk && (dp->d_namlen > MAXNAMLEN ||
		    dirbadname(dp->d_name, (int)dp->d_namlen))) {
			buf_offset += i;
			dp = (struct direct *)((long)dp + i);
		} else {
			if (dp->d_ino) {
				if (compat)
				  reclen = sizeof(struct sysv_direct);
				else {
					/* This is very compiler dependant */
					/* sizeof dirent includes 2 bytes  */
					/* for name (char d_name[1]) which */
					/* we don't want!		   */
					reclen = (dp->d_namlen + 1 +
						  sizeof(struct dirent) - 2
						  + NBPW - 1) & ~(NBPW - 1);
				}
				if (count < reclen)
					break;
				if((n += reclen) > DIRBLKSIZ) {
					n -= reclen;
#ifdef	TRFS
					vp->v_flag |= VSVDIROP;
#endif	TRFS
					if(error = copyout((caddr_t)saventryptr,
							(caddr_t)base, n))
						goto out;
					bzero(saventryptr, DIRBLKSIZ);
					base += n;
					entryptr = saventryptr;
					n = reclen;
				}
				if(compat) {
					entryptr->s5dir.d_ino = dp->d_ino;
					bcopy(dp->d_name,entryptr->s5dir.d_name,
						MIN(dp->d_namlen, SYSV_DIRSIZ));
				} else {
					/*
					 * Given the user the offset for the next
					 * entry in the directory.
					 */
					entryptr->dirent.d_off = sysv_offset + sizeof (struct sysv_direct);
					entryptr->dirent.d_ino = dp->d_ino;
					bcopy(dp->d_name,
					 entryptr->dirent.d_name, dp->d_namlen);
					entryptr->dirent.d_name[dp->d_namlen] = '\0';
					entryptr->dirent.d_reclen = reclen;
				}
				sysv_offset += sizeof (struct sysv_direct);
				count -= reclen;
				entryptr = (union a *)((long)entryptr + reclen);
			}
			buf_offset += dp->d_reclen;
			dp = (struct direct *)((long)dp + dp->d_reclen);
		}
	}
	if (n) {
#ifdef	TRFS
		vp->v_flag |= VSVDIROP;
#endif	TRFS
		error = copyout(saventryptr, base, n);
	}
out:
#ifdef	TRFS
	vp->v_flag &= ~VSVDIROP;
	u.u_pdir = NULL;
#endif	TRFS
	/*
	 * If we have reached the end of this buffer use the
	 * offset that was returned by VOP_READDIR.  If not,
	 * use the last remembered offset which will cause
	 * the block to be re-read the next time this routine
	 * is called.  This normally the case when someone
	 * does a read() on a directory.
	 */
	if ((long)dp >= eob) {
		buf_offset = 0;
		uio->uio_offset = auio.uio_offset;
	}
	else
	  uio->uio_offset = real_offset;
	uio->uio_offset_buf = buf_offset;
	uio->uio_offset_sysv = sysv_offset;
	uio->uio_resid = count;
	kmem_free(bp, 2*DIRBLKSIZ);
	return(error);
}

/*
 * Convert a BSD file offset to SYSV file offset.  Results are place in
 * argument pointer sysvoffset.
 * Return codes:    0 = sysvoffset contains a valid offset.
 * 		 non-zero = Error code. sysvoffset is invalid.
 * Side effects:
 *      Allocates DIRBLKSIZ bytes of kernel memory.
 *      Reads directory blocks to determine correct Sysv offset. 
 */
bsd_to_sysv(vp, bsdoffset, sysvoffset)
register struct	vnode *vp;
unsigned bsdoffset, *sysvoffset;
{
	register struct direct *dp = NULL;
	register unsigned offset;
	register long bp, i, eob, error = 0;
	struct uio auio;
	struct iovec aiov;
#ifdef NFS
	extern struct vnodeops nfs_vnodeops;
#endif

#ifdef	RFS
	if(vp->v_flag & VRFSNODE) { /* KLUDGE - How else does one do it? */
		/* For Rfs the conversion was done on the server */
		*sysvoffset = bsdoffset;
		return(0);
	}
#endif	RFS
	if ((bp = (long)kmem_alloc(DIRBLKSIZ)) == NULL) 
	  return (ENOMEM);

	*sysvoffset = auio.uio_offset = auio.uio_resid = 0;
	vp->v_flag |= VSVDIROP;
	while (bsdoffset > 0) {
		if (dp == NULL || (long)dp >= eob) {
			/*
			 * Have to second guess VOP_READDIR.  If the last
			 * read was not complete this next read should cause
			 * an eof condition for the BSD file system only.
			 * There are some things to watch out for here.  The
			 * BSD readdir requires the offset to be rounded to
			 * DIRBLKSIZ.  NFS on the other hand requires you to
			 * pass what ever was returned by the last call or
			 * 0.  Without second guessing we get screwed one
			 * way or another.
			 */
#ifdef NFS
			if ((vp->v_op != &nfs_vnodeops) && auio.uio_resid)
			  break;
#else
			if (auio.uio_resid)
			  break;
#endif 

			offset = 0;
			auio.uio_iov = &aiov;
			auio.uio_seg = UIOSEG_KERNEL;
			/*
			 * uio_offset will be updated by VOP_READDIR during
			 * the procedure call. NFS has a requirement that
			 * you use the offset that it returns for the next
			 * call.
			 */
			auio.uio_iovcnt = 1;
			auio.uio_iov->iov_base = (caddr_t)bp;
			auio.uio_resid = auio.uio_iov->iov_len = DIRBLKSIZ;
			if (error = VOP_READDIR(vp, &auio, u.u_cred))
			  break;
			dp = (struct direct *)bp;
			eob = bp + DIRBLKSIZ - auio.uio_resid;
			if ((long)dp >= eob)
			  break;
		}
		i = DIRBLKSIZ - (offset & (DIRBLKSIZ - 1));
		if ((dp->d_reclen & 0x3) || dp->d_reclen == 0 ||
		    dp->d_reclen > i || DIRSIZ(dp) > dp->d_reclen) {
			offset += i;
			bsdoffset -= i;
			dp = (struct direct *)((long)dp + i);
		} else {
			if (dp->d_ino)
				*sysvoffset += sizeof (struct sysv_direct);
			offset += dp->d_reclen;
			bsdoffset -= dp->d_reclen;
			dp = (struct direct *)((long)dp + dp->d_reclen);
		}
	}
	kmem_free(bp, DIRBLKSIZ);
	vp->v_flag &= ~VSVDIROP;
	return(error);
}

/*
 * Convert a SYSV file offset to BSD file offset
 */
sysv_to_bsd(vp, sysvoffset, fp)
	register struct	vnode *vp;
	unsigned sysvoffset;
	struct file *fp;
{
	register struct direct *dp = NULL;
	register unsigned offset;
	register long bp, i, eob, error = 0, real_offset;
	struct uio auio;
	struct iovec aiov;

#ifdef	RFS
	if(vp->v_flag & VRFSNODE) { /* KLUDGE - How else does one do it? */
		/* For Rfs the conversion was done on the server */
		fp->f_offset = sysvoffset;
		return(0);
	}
#endif	RFS

	if ((bp = (long)kmem_alloc(DIRBLKSIZ)) == NULL)
	  return (ENOMEM);

	offset = auio.uio_offset = real_offset = 0;
	vp->v_flag |= VSVDIROP;
	fp->f_offset_sysv = sysvoffset;
	while (sysvoffset > 0) {
		if (dp == NULL || (long)dp >= eob) {
			if (dp != NULL)
			  offset = 0;
			auio.uio_iov = &aiov;
			auio.uio_seg = UIOSEG_KERNEL;
			real_offset = auio.uio_offset;
			auio.uio_iovcnt = 1;
			auio.uio_iov->iov_base = (caddr_t)bp;
			auio.uio_resid = auio.uio_iov->iov_len = DIRBLKSIZ;
			if (error = VOP_READDIR(vp, &auio, u.u_cred))
				break;
			dp = (struct direct *) (bp + (offset & (DIRBLKSIZ - 1)));
			eob = bp + DIRBLKSIZ - auio.uio_resid;
			if ((long)dp >= eob)
				break;
		}
		i = DIRBLKSIZ - (offset & (DIRBLKSIZ - 1));
		if ((dp->d_reclen & 0x3) || dp->d_reclen == 0 ||
		    dp->d_reclen > i || DIRSIZ(dp) > dp->d_reclen) {
			offset += i;
			dp = (struct direct *)((long)dp + i);
		} else {
			if (dp->d_ino)
				sysvoffset -= sizeof (struct sysv_direct);
			offset += dp->d_reclen;
			dp = (struct direct *)((long)dp + dp->d_reclen);
		}
	}
	if ((long)dp >= eob) {
		offset = 0;
		fp->f_offset = auio.uio_offset;
	}
	else
	  fp->f_offset = real_offset;
	fp->f_offset_buf = offset;
	kmem_free(bp, DIRBLKSIZ);
	vp->v_flag &= ~VSVDIROP;
	return(error);
}
#endif	SYSV
