/*	@(#)vfs_conf.c 1.1 86/02/03 SMI	*/

#include "param.h"
#include "vfs.h"

extern	struct vfsops ufs_vfsops;	/* XXX Should be ifdefed */

#ifdef NFS
extern	struct vfsops nfs_vfsops;
#endif

#ifdef PCFS
extern	struct vfsops pcfs_vfsops;
#endif

#ifdef NPC
extern struct vfsops npc_vfsops;
#endif

#if	defined(SYSV) && defined(RFS)
extern	struct vfsops rfs_vfsops;
#endif

struct vfsops *vfssw[] = {
	&ufs_vfsops,		/* 0 = MOUNT_UFS */
#ifdef NFS
	&nfs_vfsops,		/* 1 = MOUNT_NFS */
#else
	(struct vfsops *)0,
#endif
#ifdef PCFS
	&pcfs_vfsops,		/* 2 = MOUNT_PC */
#else
	(struct vfsops *)0,
#endif
#if	defined(SYSV) && defined(RFS)
	&rfs_vfsops,		/* 3 = MOUNT_RFS */
#else
	(struct vfsops *)0,
#endif
#ifdef NPC
	&npc_vfsops,		/* 4 = MOUNT_NPC */
#else
	(struct vfsops *)0,
#endif
};
