/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)syscalls.c	7.1 (Berkeley) 6/5/86
 */

/*
 * BSD System call names.
 * Must match:	/sys/sys/init_sysent.c /sys/sys/syscalls.c 
 *		/usr/include/syscall.h /usr/src/lib/libc/is68k/sys/NARGS.h
 */
char *syscallnames[] = {
	"indir",		/*   0 = indir */
	"exit",			/*   1 = exit */
	"fork",			/*   2 = fork */
	"read",			/*   3 = read */
	"write",		/*   4 = write */
	"open",			/*   5 = open */
	"close",		/*   6 = close */
	"old wait",		/*   7 = old wait */
	"creat",		/*   8 = creat */
	"old link",		/*   9 = link */
	"unlink",		/*  10 = unlink */
	"execv",		/*  11 = execv */
	"chdir",		/*  12 = chdir */
	"old time",		/*  13 = old time */
	"mknod",		/*  14 = mknod */
	"chmod",		/*  15 = chmod */
	"chown",		/*  16 = chown; now 3 args */
	"old break",		/*  17 = old break */
	"old stat",		/*  18 = old stat */
	"lseek",		/*  19 = lseek */
	"getpid",		/*  20 = getpid */
	"old mount",		/*  21 = old mount */
	"old unmount",		/*  22 = old umount */
	"old setuid",		/*  23 = old setuid */
	"getuid",		/*  24 = getuid */
	"old stime",		/*  25 = old stime */
	"ptrace",		/*  26 = ptrace */
	"old alarm",		/*  27 = old alarm */
	"old fstat",		/*  28 = old fstat */
	"old pause",		/*  29 = opause */
	"old utime",		/*  30 = old utime */
	"old stty",		/*  31 = old stty */
	"old gtty",		/*  32 = old gtty */
	"access",		/*  33 = access */
	"old nice",		/*  34 = old nice */
	"old ftime",		/*  35 = old ftime */
	"sync",			/*  36 = sync */
	"kill",			/*  37 = kill */
	"stat",			/*  38 = stat */
	"old setpgrp",		/*  39 = old setpgrp */
	"lstat",		/*  40 = lstat */
	"dup",			/*  41 = dup */
	"pipe",			/*  42 = pipe */
	"old times",		/*  43 = old times */
	"profil",		/*  44 = profil */
	"#45",			/*  45 = nosys */
	"old setgid",		/*  46 = old setgid */
	"getgid",		/*  47 = getgid */
	"old signal",		/*  48 = old sig */
	"#49",			/*  49 = reserved for USG */
	"#50",			/*  50 = reserved for USG */
	"acct",			/*  51 = turn acct off/on */
#ifdef vax
	"old phys - nosys",	/*  52 = old set phys addr */
	"old lock - nosys",	/*  53 = old lock in core */
#endif vax
#ifdef is68k
	"ISI: sky",		/*  52 = ISI: old sky board map */
	"ISI: ulock",		/*  53 = ISI: lock process in core */
#endif is68k
	"ioctl",		/*  54 = ioctl */
	"reboot",		/*  55 = reboot */
#ifdef vax
	"old mpx - nosys",	/*  56 = old mpxchan */
#endif vax
#ifdef is68k
	"ISI: skymap",		/*  56 = ISI: sky board map */
#endif is68k
	"symlink",		/*  57 = symlink */
	"readlink",		/*  58 = readlink */
	"execve",		/*  59 = execve */
	"umask",		/*  60 = umask */
	"chroot",		/*  61 = chroot */
	"fstat",		/*  62 = fstat */
	"#63",			/*  63 = used internally */
	"getpagesize",		/*  64 = getpagesize */
	"mremap",		/*  65 = mremap */
	"vfork",		/*  66 = vfork */
	"old vread - read",	/*  67 = old vread */
	"old vwrite - write",	/*  68 = old vwrite */
	"sbrk",			/*  69 = sbrk */
	"sstk",			/*  70 = sstk */
	"mmap",			/*  71 = mmap */
	"old vadvise",		/*  72 = old vadvise */
	"munmap",		/*  73 = munmap */
	"mprotect",		/*  74 = mprotect */
	"madvise",		/*  75 = madvise */
	"vhangup",		/*  76 = vhangup */
	"old vlimit",		/*  77 = old vlimit */
	"mincore",		/*  78 = mincore */
	"getgroups",		/*  79 = getgroups */
	"setgroups",		/*  80 = setgroups */
	"getpgrp",		/*  81 = getpgrp */
	"setpgrp",		/*  82 = setpgrp */
	"setitimer",		/*  83 = setitimer */
	"wait",			/*  84 = wait */
	"old swapon",		/*  85 = old swapon */
	"getitimer",		/*  86 = getitimer */
	"gethostname",		/*  87 = gethostname */
	"sethostname",		/*  88 = sethostname */
	"getdtablesize",	/*  89 = getdtablesize */
	"dup2",			/*  90 = dup2 */
	"getdopt",		/*  91 = getdopt */
	"fcntl",		/*  92 = fcntl */
	"select",		/*  93 = select */
	"setdopt",		/*  94 = setdopt */
	"fsync",		/*  95 = fsync */
	"setpriority",		/*  96 = setpriority */
	"socket",		/*  97 = socket */
	"connect",		/*  98 = connect */
	"accept",		/*  99 = accept */
	"getpriority",		/* 100 = getpriority */
	"send",			/* 101 = send */
	"recv",			/* 102 = recv */
	"old socketaddr",	/* 103 = old socketaddr */
	"bind",			/* 104 = bind */
	"setsockopt",		/* 105 = setsockopt */
	"listen",		/* 106 = listen */
	"old vtimes",		/* 107 = old vtimes */
	"sigvec",		/* 108 = sigvec */
	"sigblock",		/* 109 = sigblock */
	"sigsetmask",		/* 110 = sigsetmask */
	"sigpause",		/* 111 = sigpause */
	"sigstack",		/* 112 = sigstack */
	"recvmsg",		/* 113 = recvmsg */
	"sendmsg",		/* 114 = sendmsg */
#ifdef TRACE
	"vtrace",		/* 115 = vtrace */
#else
	"#115",			/* 115 = nosys */
#endif
	"gettimeofday",		/* 116 = gettimeofday */
	"getrusage",		/* 117 = getrusage */
	"getsockopt",		/* 118 = getsockopt */
	"resuba",		/* 119 = resuba */
	"readv",		/* 120 = readv */
	"writev",		/* 121 = writev */
	"settimeofday",		/* 122 = settimeofday */
	"fchown",		/* 123 = fchown */
	"fchmod",		/* 124 = fchmod */
	"recvfrom",		/* 125 = recvfrom */
	"setreuid",		/* 126 = setreuid */
	"setregid",		/* 127 = setregid */
	"rename",		/* 128 = rename */
	"truncate",		/* 129 = truncate */
	"ftruncate",		/* 130 = ftruncate */
	"flock",		/* 131 = flock */
#ifdef vax
	"#132",			/* 132 = nosys */
#endif vax
#ifdef is68k
	"adjtime",		/* 132 = ISI: 4.3 adjtime */
#endif is68k
	"sendto",		/* 133 = sendto */
	"shutdown",		/* 134 = shutdown */
	"socketpair",		/* 135 = socketpair */
	"mkdir",		/* 136 = mkdir */
	"rmdir",		/* 137 = rmdir */
	"utimes",		/* 138 = utimes */
	"#139",			/* 139 = used internally */
#ifdef vax
	"adjtime",		/* 140 = adjtime */
#endif vax
#ifdef is68k
#ifdef	TRFS
	"sysMname",		/* 140 = ISI: sysMname */
#else	TRFS
	"#140",			/* 140 = nosys */
#endif	TRFS
#endif is68k
	"getpeername",		/* 141 = getpeername */
	"gethostid",		/* 142 = gethostid */
	"sethostid",		/* 143 = old sethostid */
	"getrlimit",		/* 144 = getrlimit */
	"setrlimit",		/* 145 = setrlimit */
	"killpg",		/* 146 = killpg */
	"lockf",		/* 147 = ISI: lockf */
	"setquota",		/* 148 = setquota */
	"qquota",		/* 149 = qquota */
	"getsockname",		/* 150 = getsockname */
	"plock",		/* 151 = ISI: plock */
	"punlock",		/* 152 = ISI: punlock */
	"highpri",		/* 153 = ISI: highpri */
	"normalpri",		/* 154 = ISI: normalpri */
	"nfs_svc",		/* 155 = nfs_svc */
	"getdirentries",	/* 156 = getdirentries */
	"statfs",		/* 157 = statfs */
	"fstatfs",		/* 158 = fstatfs */
	"unmount",		/* 159 = unmount */
	"async_daemon",		/* 160 = async_daemon */
	"getfh", 		/* 161 = nfs_getfh */
	"getdomainname",	/* 162 = getdomainname */
	"setdomainname",	/* 163 = setdomainname */
	"#164",			/* 164 = old pcfs_mount */
#ifndef is68k_kobj
#ifdef	QUOTA
	"quotactl",		/* 165 = NFS: quotactl */
#else
	"#165",			/* 165 = nullsys */
#endif
#endif	is68k_kobj
	"exportfs",		/* 166 = exportfs */
	"mount",		/* 167 = mount */
	"",			/* 168 = nfs -- */
	"",			/* 169 = nfs -- */
	"getuniverse",		/* 170 = SYSV: getuniverse -- */
	"setuniverse",		/* 171 = SYSV: setuniverse -- */
	"getmachtype",		/* 172 = ISI: set machine type */
#ifdef	SYSV
	"msgctl",		/* 173 = SYSV: */
	"msgget",		/* 174 = SYSV: */
	"msgsnd",		/* 175 = SYSV: */
	"msgrcv",		/* 176 = SYSV: */
	"semctl",		/* 177 = SYSV: */
	"semget",		/* 178 = SYSV: */
	"semop",		/* 179 = SYSV: */
	"shmctl",		/* 180 = SYSV: */
	"shmget",		/* 181 = SYSV: */
	"shmat",		/* 182 = SYSV: */
	"shmdt",		/* 183 = SYSV: */
#endif	SYSV
};
