/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)subr_prf.c	7.1 (Berkeley) 6/5/86
 */

#include "../machine/pte.h"
#include "../machine/board.h"

#include "param.h"
#include "systm.h"
#include "seg.h"
#include "buf.h"
#include "conf.h"
#include "reboot.h"
#include "vm.h"
#include "msgbuf.h"
#include "user.h"
#include "proc.h"
#include "ioctl.h"
#include "tty.h"
#include "syslog.h"

#include "../is68kdev/qbvar.h"

#if	DEBUGGER
#include "debug.h"
extern int	sym_magic;
#endif	DEBUGGER

#ifdef vax
#include "../vax/mtpr.h"
#endif vax

#ifdef	is68k
#include "../is68kdev/gpreg.h"		/* ISI: GWS: */
#endif	is68k
#ifdef	VQX
#include "qp.h"
#endif	VQX

#define TOCONS	0x1
int	tocons = 0;			/* ISI: GWS:  = TOCONS to force sio */
int	togws = 1;
#ifdef VQX
int     toqp = 1;
#endif VQX
#define TOTTY	0x2
#define TOLOG	0x4
#ifdef	GWS
#define TOGWS	0x8			/* ISI: GWS: */
#endif	GWS
#define TOBUF	0x10			/* ISI: */

/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */
char	*panicstr;
label_t	panic_regs;			/* ISI: save regs on panic */
char	*prf_bufp;			/* ISI: sprintf */

/*
 * Scaled down version of C Library printf. Used to print diagnostic 
 * information directly on console tty.  Since it is not interrupt driven, 
 * all system activities are suspended.  Printf should not be used for 
 * chit-chat.
 *
 * One additional format: %b is supported to decode error registers.
 * Usage is:
 *	printf("reg=%b\n", regval, "<base><arg>*");
 * Where <base> is the output base expressed as a control character, e.g. \10 
 * gives octal; \20 gives hex. If the high bit of <base> is set then regval is 
 * negated. Each arg is a sequence of characters, the first of which gives the 
 * bit number to be inspected (origin 1), and the next characters (up to a 
 * control character, i.e. a character <= 32), give the name of the register. 
 * Thus
 *	printf("reg=%b\n", 3, "\10\2BITTWO\1BITONE\n");		and
 *	printf("reg=%b\n", 0xFC, "\210\2BITTWO\1BITONE\n");
 * would produce output:
 *	reg=3<BITTWO,BITONE>
 */
/*VARARGS1*/
printf(fmt, x1)
	char *fmt;
	unsigned x1;
{
#ifdef	GWS
	prf(fmt, &x1, ((gptype&GPEXISTS)?0:TOCONS) | tocons | TOLOG, 
		(struct tty *)0);
	if ((gptype&GPEXCLUSIVE) == 0 || panicstr)
		prf(fmt, &x1, TOGWS, (struct tty *)0);
#else	GWS
	prf(fmt, &x1, TOCONS | TOLOG, (struct tty *)0);
#endif	GWS
	logwakeup();
}

/*
 *	this returns the number of chars stuffed in buf (including the NULL)
 */
/*VARARGS1*/
sprintf(buf, fmt, x1)			/* ISI: */
	char *buf;
	char *fmt;
	unsigned x1;
{

	prf_bufp = buf;
	prf(fmt, &x1, TOBUF, (struct tty *)0);
	*prf_bufp++ = '\0';
	return (prf_bufp - buf);
}

/*
 * Uprintf prints to the current user's terminal.
 * It may block if the tty queue is overfull.
 * Should determine whether current terminal user is related
 * to this process.
 */
/*VARARGS1*/
uprintf(fmt, x1)
	char *fmt;
	unsigned x1;
{
#ifdef notdef
	register struct proc *p;
#endif
	register struct tty *tp;

	if ((tp = u.u_ttyp) == NULL)
		return;
#ifdef notdef
	if (tp->t_pgrp && (p = pfind(tp->t_pgrp)))
		if (p->p_uid != u.u_uid)	/* doesn't account for setuid */
			return;
#endif
	if (ttycheckoutq(tp, 1))
		prf(fmt, &x1, TOTTY, tp);
}

/*
 * tprintf prints on the specified terminal (console if none)
 * and logs the message.  It is designed for error messages from
 * single-open devices, and may be called from interrupt level.
 * (does not sleep).
 */
/*VARARGS2*/
tprintf(tp, fmt, x1)
	struct tty *tp;
	char *fmt;
	unsigned x1;
{
	int flags = TOTTY | TOLOG;
#ifdef vax
	extern struct tty cons;
#endif vax
#ifdef is68k
	extern struct tty sio_tty[];
#endif is68k

	logpri(LOG_INFO);
	if (tp == (struct tty *)NULL)
#ifdef vax
		tp = &cons;
#endif vax
#ifdef is68k
		tp = &sio_tty[0];
#endif is68k
	if (ttycheckoutq(tp, 0) == 0)
		flags = TOLOG;
	prf(fmt, &x1, flags, tp);
	logwakeup();
}

/*
 * cprintf prints on the console only. It is designed for kernel debug messages.
 */
/*VARARGS2*/
cprintf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	prf(fmt, &x1, TOCONS, (struct tty *)0);
}

/*
 * mprintf prints into the log only.
 */
/*VARARGS2*/
mprintf(fmt, x1)
	char *fmt;
	unsigned x1;
{
	prf(fmt, &x1, TOLOG, (struct tty *)0);
}

/*
 * Log writes to the log buffer,
 * and guarantees not to sleep (so can be called by interrupt routines).
 * If there is no process reading the log yet, it writes to the console also.
 */
/*VARARGS2*/
log(level, fmt, x1)
	char *fmt;
	unsigned x1;
{
	register s = splhigh();
	extern int log_open;

	logpri(level);
	prf(fmt, &x1, TOLOG, (struct tty *)0);
	splx(s);
	if (!log_open) {
#ifdef	GWS
		if (((gptype&GPEXISTS)?0:TOCONS) | tocons)
			prf(fmt, &x1, TOCONS, (struct tty *)0);
		if ((gptype&GPEXCLUSIVE) == 0 || panicstr)
			prf(fmt, &x1, TOGWS, (struct tty *)0);
#else	GWS
		prf(fmt, &x1, TOCONS, (struct tty *)0);
#endif	GWS
	}
	logwakeup();
}

logpri(level)
	int level;
{

	putchar('<', TOLOG, (struct tty *)0);
	printn((u_long)level, 10, 0, TOLOG, (struct tty *)0);
	putchar('>', TOLOG, (struct tty *)0);
}

prf(fmt, adx, flags, ttyp)
	register char *fmt;
	register u_int *adx;
	struct tty *ttyp;
{
	register int b, c, i, p, pad;
	char *s;
	int any;

loop:
	while ((c = *fmt++) != '%') {
		if (c == '\0')
			return;
		putchar(c, flags, ttyp);
	}
	p = 0;
	pad = 0;
again:
	if ((c = *fmt++) == '\0')
		return;
	if (p == 0 && (c == '-' || c == '+')) {
		pad++;
		goto again;
	}
	if (p == 0 && c >= '0' && c <= '9') {	/* number of places */
		do {
			p = (p * 10) + (c - '0');
			if ((c = *fmt++) == '\0')
				return;
		} while (c >= '0' && c <= '9');
	}

	/* THIS CODE IS VAX DEPENDENT IN HANDLING %l? AND %c */
	switch (c) {

	case 'l':
		goto again;
	case 'x': case 'X':
		b = 16;
		goto number;
	case 'd': case 'D':
	case 'u':		/* what a joke */
		b = 10;
		goto number;
	case 'o': case 'O':
		b = 8;
number:
		printn((u_long)*adx, b, p, flags, ttyp);
		break;
	case 'a':		/* address */
		printn((u_long)*adx, 16, 8, flags, ttyp);
#if	DEBUGGER
		if (sym_magic == NEWDBG_MAGIC) {
			putchar('/', flags, ttyp);
			s = (char *)psymbol((u_long)*adx, 1);
			p = 14;
			pad = 1;
			goto str;
		}
#endif	DEBUGGER
		break;
	case 'A':			/* IO Address */
		b = *adx;
#ifdef	VBUS
#ifdef	M68020
#ifndef VQX

		if ((b & MEMR_MASK) == SYSV_BASE)
			b = svtop(b);
#endif VQX
#endif	M68020
#ifdef	M68025
		if ((btop(b) & PG_VMEEXT) == PG_VMEEXT) {
		    s = "vme_ext 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 8, flags, ttyp);
		} else if ((btop(b) & PG_VMESTD) == PG_VMESTD) {
		    b &= 0xFFFFFF;
		    s = "vme_std 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 6, flags, ttyp);
		} else if ((btop(b) & PG_VMESHORT) == PG_VMESHORT) {
		    b &= 0xFFFF;
		    s = "vme_short 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 4, flags, ttyp);
		} else {
		    s = "hs_mem 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 8, flags, ttyp);
		}
#else	M68025
#ifdef VQX
                if ((b >= (int)vme_short) &&
                    (b <= (int)&vme_short[VME_SHRT_LEN-2]) ) {
                    b &= VME_SHRT_LEN-1;
                    s = "vme_short 0x";
                    while ((c = *s++))
                        putchar(c, flags, ttyp);
                    printn(b, 16, 4, flags, ttyp);
                } else if ((b >= (int)vme_std) &&
                    (b <= (int)&vme_std[VME_STD_LEN-2]) ) {
                    b &= VME_STD_LEN-1;
                    s = "vme_std 0x";
                    while ((c = *s++))
                        putchar(c, flags, ttyp);
                    printn(b, 16, 6, flags, ttyp);
                } else if ((b >= (int)vme_ext) &&
                          (b <= (int)&vme_ext[VME_EX_LEN-2]) ) {
                        b &= VME_EX_LEN-1;
                        s = "vme_ext 0x";
                        while ((c = *s++))
                            putchar(c, flags, ttyp);
                        printn(b, 16, 4, flags, ttyp);
                } else {
                        s = "address 0x";
                        while ((c = *s++))
                            putchar(c, flags, ttyp);
                        printn(b, 16, 8, flags, ttyp);
                }
#else   VQX
		if ((b >= (int)vme_short) && 
		    (b <= (int)&vme_short[0xFFFE]) ) {
		    b &= 0xFFFF;
		    s = "vme_short 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 4, flags, ttyp);
		} else if ((b >= (int)vme_std) && 
		    (b <= (int)&vme_std[0xFFFFFE]) ) {
		    b &= 0xFFFFFF;
		    s = "vme_std 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 6, flags, ttyp);
		} else {
		    s = "address 0x";
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		    printn(b, 16, 8, flags, ttyp);
		}
#endif	VQX
#endif	M68025
#else	VBUS
		b = svtop(b);
		b = svtop(b);
		s = "address 0x";
		while ((c = *s++))
		    putchar(c, flags, ttyp);
		printn(b, 16, 8, flags, ttyp);
		s = "/0";
		while ((c = *s++))
		    putchar(c, flags, ttyp);
		printn(b, 8, 7, flags, ttyp);
#endif	VBUS
		break;
		
	case 'c':
#ifdef	vax
		b = *adx;
		for (i = 24; i >= 0; i -= 8)
			if (c = (b >> i) & 0x7f)
				putchar(c, flags, ttyp);
#endif	vax
#ifdef	is68k
		c = *adx;
		putchar(c, flags, ttyp);
#endif	is68k
		break;
	case 'b':
		b = *adx++;
		s = (char *)*adx;
		c = *s++;
		i = c & 0x80;
		c &= 0x7F;
		printn((u_long)b, c, 0, flags, ttyp);
		if (i)
			b = ~b;
		any = 0;
		if (b) {
			while (i = *s++) {
				if (b & (1 << (i-1))) {
					putchar(any? ',' : '<', flags, ttyp);
					any = 1;
					for (; (c = *s) > 32; s++)
						putchar(c, flags, ttyp);
				} else
					for (; *s > 32; s++)
						;
			}
			if (any)
				putchar('>', flags, ttyp);
		}
		break;

	case 's':
		s = (char *)*adx;
	str:	if (p == 0) {
		    while ((c = *s++))
			putchar(c, flags, ttyp);
		} else if (pad) {
		    while ((c = *s++)) {
			putchar(c, flags, ttyp);
			p--;
		    }
		    c = ' ';
		    while (p-- > 0)
			putchar(c, flags, ttyp);
		} else {
		    while ((c = *s++) && p--)
			putchar(c, flags, ttyp);
		}
		break;

	case '%':
		putchar('%', flags, ttyp);
		break;

	case 'm':
		i = (int)*adx;
		b = i >> 20;
		printn(b, 10, 0, flags, ttyp);
		if (p == 0) {
			putchar('.', flags, ttyp);
			b = 99-(((0x100 - ((i>>12)&0xFF))*99)/0x100);
			if (b < 10)
				putchar('0', flags, ttyp);
			printn(b, 10, 0, flags, ttyp);
		}
		break;

	case 'e':		/* print out ethernet address */
		for (s = (char *)*adx, i = 0 ; i < 6 ; i++, s++) {
			printn((*s)&0xFF, 16, 0, flags, ttyp);
			if (i < 5)
				putchar(':', flags, ttyp);
		}
		break;

	}
	adx++;
	goto loop;
}

/*
 * Printn prints a number n in base b using p places.
 * We don't use recursion to avoid deep kernel stacks.
 */
printn(n, b, p, flags, ttyp)
	u_long n;
	struct tty *ttyp;
{
	char prbuf[32];
	register char *cp;
	register int np = 0;

	if (b == 10 && (int)n < 0) {
		putchar('-', flags, ttyp);
		n = (unsigned)(-(int)n);
	}
	cp = prbuf;
	do {
		*cp++ = "0123456789abcdef"[n%b];
		n /= b;
		np++;
	} while (n);
	if (p) {
		while (np++ < p)
			if (b == 10)
				putchar(' ', flags, ttyp);
			else
				putchar('0', flags, ttyp);
	}
	do
		putchar(*--cp, flags, ttyp);
	while (cp > prbuf);
}

/*
 * Panic is called on unresolvable fatal errors. It prints "panic: mesg", and 
 * then reboots. If we are called twice, then we avoid trying to sync the 
 * disks as this often leads to recursive panics.
 */
char panic_buffer[100];

panic(s, x1)
	char *s;
	unsigned x1;
{
	int bootopt = RB_AUTOBOOT;

	if (panicstr)
		bootopt |= RB_NOSYNC;
	else {
		panicstr = s;
#ifdef	is68k
		tocons = 1;
#endif	is68k
		if (u.u_procp && u.u_procp->p_addr)
			(void) setjmp(&panic_regs);

		/* do format expansion in panic messages */
		prf_bufp = panic_buffer;
		prf(s, &x1, TOBUF, (struct tty *)0);
		*prf_bufp++ = '\0';
		printf("panic: %s\n", panicstr = panic_buffer);
#ifdef is68k
		stacktrace();
#ifdef	GWS
		gpwho();
#endif	GWS
#endif is68k
	}
	boot(RB_PANIC, bootopt);
}

/*
 * Warn that a system table is full.
 */
tablefull(tab)
	char *tab;
{

	log(LOG_ERR, "%s: table is full\n", tab);
}

/*
 * Hard error is the preface to plaintive error messages
 * about failing disk transfers.
 */
harderr(bp, cp)
	struct buf *bp;
	char *cp;
{

	printf("%s%d%c: hard error sn%d ", cp,
	    minor(bp->b_dev) >> 3, 'a'+(minor(bp->b_dev)&07), bp->b_blkno);
}

/*
 * Print a character on console or users terminal.
 * If destination is console then the last MSGBUFS characters
 * are saved in msgbuf for inspection later.
 */
/*ARGSUSED*/
putchar(c, flags, tp)
	register int c;
	struct tty *tp;
{
#ifdef is68k
	extern int msgbuf_setup;
#endif is68k

	if (flags & TOTTY) {
		register s = spltty();

		if (tp && (tp->t_state & (TS_CARR_ON | TS_ISOPEN)) ==
		    (TS_CARR_ON | TS_ISOPEN)) {
			if (c == '\n')
				(void) ttyoutput('\r', tp);
			(void) ttyoutput(c, tp);
			ttstart(tp);
		}
		splx(s);
	}
	if ((flags & TOLOG) && c != '\0' && c != '\r' && c != 0177
#ifdef vax
	    && mfpr(MAPEN)
#endif
#ifdef is68k
	    && msgbuf_setup
#endif is68k
	    ) {
		if (msgbuf.msg_magic != MSG_MAGIC) {
			register int i;

			msgbuf.msg_magic = MSG_MAGIC;
			msgbuf.msg_bufx = msgbuf.msg_bufr = 0;
			for (i=0; i < MSG_BSIZE; i++)
				msgbuf.msg_bufc[i] = 0;
		}
		if (msgbuf.msg_bufx < 0 || msgbuf.msg_bufx >= MSG_BSIZE)
			msgbuf.msg_bufx = 0;
		msgbuf.msg_bufc[msgbuf.msg_bufx++] = c;
	}
	if ((flags & TOCONS) && c != '\0')
		cnputc(c);
#ifdef GWS
	if (togws && (flags & TOGWS) && c != '\0')
		vt_cnputc(c);
#endif GWS
	if (flags & TOBUF)
		*prf_bufp++ = c;
#ifdef VQX
#if	(NQP > 0)
        if (toqp)
            con_putc(c);
#endif	NQP 
#endif 	VQX
}

#ifdef	SYSV
assfail(a, f, l)
register char *a, *f;
int l;
{
	printf("assertion failed: %s, file: %s, line: %d\n",a, f, l);
/*	panic("sysv assertion failure"); /* */
}
#endif	SYSV
