/*
 *	SMBcommands.h -- offsets into smb packet, and other odds and
 *      ends
 */

#define	    	SMB_IDF		0
#define 	SMB_COM		4	/* command code */
#define		SMB_RCLS	5	/* error code class */
#define		SMB_REH		6
#define		SMB_ERR		7
#define		SMB_REB		9
#define		SMB_RES		10
#define		SMB_TID		24
#define		SMB_PID		26	/* caller's process id */
#define		SMB_UID		28
#define		SMB_MID		30
#define		SMB_WCT		32	/* count of parameter words */
#define		SMB_VWV		33	/* variable number of param words */
  /* return smb word at address (W) as 68000 word, W is an address */
#define GET_SMBWORD(W) ((*(unsigned char *)(W))|\
			((*((unsigned char *)(W)+1))<<8))

  /* return smb double at address (W) as 68000 word, W is an address */
#define GET_SMBDOUBLE(W) ((GET_SMBWORD((W))&0xffff)|\
			  (GET_SMBWORD((W)+2)<<16))

  /* place a 68000 word value (V) into smb word order at address (W) */
#define PUT_SMBWORD(W,V) (*(unsigned char *)(W) = ((V)&0xff),\
			  *((unsigned char *)(W)+1) = ((V)&0xff00) >> 8)

  /* place a 68000 double value (V) into smb word order at address (W) */
#define PUT_SMBDOUBLE(W,V) (PUT_SMBWORD((W),(V)&0xffff),\
			    PUT_SMBWORD((((unsigned char *)(W))+2),\
					(V)>>16))

  /* return offset of smb buffer count (smb_bcc) from smb packet (P) */
#define SMB_BCC(P) (SMB_WCT+(P[SMB_WCT]<<1)+1)

  /* return offset of smb buffer (smb_buf) from packet (P) */
#define SMB_BUF(P) (SMB_WCT+(P[SMB_WCT]<<1)+3)

  /* return byte size of smb packet */
#define SMB_SIZE(P) (SMB_BCC(P)+2+GET_SMBWORD(&P[SMB_BCC(P)]))

#define MAX_SMBPKT  4096
#define MIN_SMBPKT  (SMB_WCT+3)

/* the SMB command codes */

#define	    SMBmkdir	    0x00
#define	    SMBrmdir	    0x01
#define	    SMBopen	    0x02
#define	    SMBcreate	    0x03
#define	    SMBclose	    0x04
#define	    SMBflush	    0x05
#define	    SMBunlink	    0x06
#define	    SMBmv	    0x07
#define	    SMBgetatr	    0x08
#define	    SMBsetatr	    0x09
#define	    SMBread	    0x0a
#define	    SMBwrite	    0x0b
#define	    SMBlock	    0x0c
#define	    SMBunlock	    0x0d
#define	    SMBctemp	    0x0e
#define	    SMBmknew	    0x0f
#define	    SMBchkpath	    0x10
#define	    SMBexit	    0x11
#define	    SMBlseek	    0x12
#define	    SMBtcon	    0x70
#define	    SMBtdis	    0x71
#define	    SMBnegprot	    0x72
#define	    SMBdskattr	    0x80
#define	    SMBsearch	    0x81
#define	    SMBsplopen	    0xc0
#define	    SMBsplwr	    0xc1
#define	    SMBsplclose	    0xc2
#define	    SMBsplretq	    0xc3

/* SMB error class codes */
#define SUCCESS		0
#define ERRDOS		0x01
#define ERRSRV		0x02
#define ERRHRD		0x03
#define ERRCMD		0xff

/* SMB error codes for clase SUCCESS */
/* #define  SUCCESS	0 */
#define BUFFERED	0x54
#define LOGGED		0x55
#define DISPLAYED	0x56

/* SMB error codes for class ERRDOS */
#define ERRbadfunc	1
#define ERRbadfile	2
#define ERRbadpath	3
#define ERRnofids	4
#define ERRnoaccess	5
#define ERRbadfid	6
#define ERRbadmcd	7
#define ERRnomem	8
#define ERRbadmem	9
#define ERRbadenv	10
#define ERRformat	11
#define ERRbadaccess	12
#define ERRbaddata	13
/* #define ERR reserved	14 */
#define ERRbaddrive	15
#define ERRremcd	16
#define ERRdiffdevice	17
#define ERRnofiles	18
#define ERRfilexists	80
#define ERRbadshare	32
#define ERRlock		33
#define ERRnotables	24


/* SMB error codes for class ERRSRV */
#define ERRerror	1
#define ERRbadpw	2
#define ERRbadtype	3
#define ERRaccess	4
#define ERRinvnid	5
#define ERRinvnetname	6
#define ERRinvdevice	7
#define ERRqfull	49
#define ERRqtoobig	50
#define ERRqeof		51
#define ERRinvpfid	52
#define ERRpaused	81
#define ERRmsgoff	82
#define ERRnoroom	83
#define ERRrmuns	87
#define ERRnosupport	0xffff

/*  offsets and sizes for dir_info structures */

#define		DIR_INFO_SIZ	    43
#define		DIR_INFO_STATSIZ    21
#define		DIR_INFO_PATHSIZ    13
#define		DIR_INFO_ATTRSIZ    1
#define		DIR_INFO_STAT	    0
#define		DIR_INFO_ATTR	    21
#define		DIR_INFO_TIME	    22
#define		DIR_INFO_DATE	    24
#define		DIR_INFO_SIZE_L	    26
#define		DIR_INFO_SIZE_H     28
#define		DIR_INFO_PATH	    30

/*  The SMB file attribute bitflags representing DOS attrs */

#define		FA_RO	    0x01	/*  readonly */
#define		FA_HID	    0x02	/*  hidden */
#define		FA_SYS	    0x04	/*  system */
#define		FA_VOLID    0x08	/*  volume id */
#define		FA_DIR	    0x10	/*  directory */
#define		FA_ARCH	    0x20	/*  archive */
/* A "regular" file (readwrite) indicated by no bits turned on */

#define    extractSMBtdis(buf,rcls,err) \
	   extractSMB(buf,rcls,err,(unsigned char)SMBtdis)
	   
#define	    extractSMBclose(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBclose)

#define	    extractSMBflush(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBflush)
	    
#define	    extractSMBmkdir(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBmkdir)

#define	    extractSMBrmdir(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBrmdir)

#define	    extractSMBunlink(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBunlink)

#define	    extractSMBmv(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBmv)
	    
#define	    extractSMBsetatr(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBsetatr)
	    
#define	    extractSMBchkpath(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBchkpath)

#define	    extractSMBlock(buf,rcls,err) \
	    extractSMB(buf,rcls,err,(unsigned char)SMBlock)

#define     extractSMBunlock(buf,rcls,err) \
 	    extractSMB(buf,rcls,err,(unsigned char)SMBunlock)

#define     extractSMBexit(buf,rcls,err) \
 	    extractSMB(buf,rcls,err,(unsigned char)SMBexit)
#define		SMB_TCP_PORT	560
#define		FILESHARE	"PC NETWORK PROGRAM 1.0"

#define		DOSSERVE_PATH	"/usr/smb/DosServ"
#define		DOSSERVE	"DosServ"

#define		PROTOSTRING	36
#define		SMB_NO_GO	0xffff   /* -1: don't recog. protocols */
