/*
 *	$Header: npcfs.h,v 1.2 88/08/29 06:30:15 mark Locked $
 */

/*
 * vfs pointer to mount info
 */
#define	vftomi(vfsp)	((struct pcmountinfo *)((vfsp)->vfs_data))

/*
 * vnode pointer to pcnode pointer
 */
#define vtopc(vp)	((struct pcnode *)((vp)->v_data))

#define	    MAXDOSNAME	12		/* ????????.??? */
#define	    DOSNMDEC	(((MAXDOSNAME+2)>>1)<<1)
#define	    MAXPCNODE	200		/* maximum pc nodes before fail */
#define	    NORMPCNODE	100		/* if pcnodecnt > NORMPCNODE,
					 * freelist is empty */
extern int		pcnodecnt;
extern struct pcnode	*pcnodefreel;
char			*put_word();
char			*get_word();
/*
 *	Mount structure.
 *	One allocated on every mount.
 */
struct pcmountinfo {
    struct vfs	    *m_vfsp;		/* vfs structure for this Fs */
    struct vnode    *m_rootvp;		/* vnode for fs root */
    struct in_addr  m_addr;		/* ip_address for remote machine */
    struct pcsock   *m_sock;		/* null if socket disconnected */
    char	    m_name[NB_NAME_LEN];/* remote machine name */
    char	    m_sname[NB_SNAME_LEN+1];
					/* short name specified in mnt */
    struct timeval  m_atime;		/* last time vfs was used */
    struct pcaccess *m_alist;		/* list of uid that have mounted */
    char	    m_flags;		/* see below */
    short	    m_vcnt;		/* count of held vnodes */
    short	    m_tid;		/* tree id for smb packets */
    short	    m_maxpkt;		/* maximum transmit packet size */
    short	    m_blksize;		/* size of disk blocks on pc */
    long	    m_time;		/* time of last sock chkout */
    char	    m_passwd[NB_PASSWD_LEN+1];	/* password for tree-connect */
};
/*
 *	flags for npc specific attributes
 */
#define	NPCMNT_NOAGE	1		/* do not age mount */
#define	NPCMNT_BADFS	2		/* something wrong with FS */
#define	NPCMNT_ACTIVE	4		/* if aging and no vnodes held, then
					 * active flag is reset when too old */

/* linked list of pids attached to sock struct.  Each time pid accesses
   vc, it gets added to list.  whenever process exits, search list, if found
   cut it from list and send SMBexit.  when deallocating sock struct, remember
   to reel in pids that are left and dealloc them too.
*/
struct npcpid {
    int			pid;
    struct npcpid	*next;
};

struct pcsock {
    struct socket	*ps_sock;   /* tcp sock is good if struct exists */
    struct pcmountinfo	*ps_minfo;
    short		ps_refcnt;  /* count of pcmountinfo's pointing here */
    short		ps_busy;    /* smb operation in progress when on */
    struct npcpid	*ps_pidp;   /* list of pids that have acessed pc */
/* cleanup fields */
    short		ps_state;   /* whether sock is clear or receiving */
#define	    PS_CLEAR	0
#define	    PS_RECV	1
    unsigned short	ps_needed;  /* how many bytes required */
    unsigned short	ps_received; 	/* how many read in so far */
    unsigned char	ps_smbcmd;
    unsigned char	ps_smbrcls;
    unsigned short	ps_smbtid;
    unsigned short	ps_smbpid;
    unsigned short	ps_smbfid;
    unsigned long	ps_lockcnt;
    unsigned long	ps_lockoff;
};

struct pcaccess {
    struct pcaccess *pa_next;		/* null if not more */
    uid_t	    pa_uid;		/* uid that did mount */
    int		    pa_usecnt;		/* number of mounts by this uid */
    u_long	    pa_mode;		/* mode for mount */
    char	    pa_flags;
};

struct pc_lock {
    int		    l_pid;		/* the process that owns the lock */
    int		    l_len;		/* length of locked region (positive) */
    int		    l_start;		/* starting offset of lock */
    struct pc_lock  *l_next;		/* next element in chain */
};

struct pcnode {
    struct pcnode   *pc_next;		/* next node in free/cache list */
    struct vnode    pc_vnode;		/* vnode for pcnode */
    short	    pc_opencnt;		/* count of active opens for node */
    short	    pc_xocnt;		/* count of active FEXCLO opens */
    short	    pc_smbfid;		/* returned by the server for a file */
    short	    pc_omode;		/* permissions achieved on open */
    int		    pc_opid;		/* which pid used SMBopen */
    char	    pc_name[DOSNMDEC];/* name for this componant of path */
    struct vnode    *pc_parent;		/* parent vnode, null if root */
    struct pc_lock  *pc_locklist;	/* all standing region locks on file */
    short	    pc_nodeid		/* unique node id for htis node,
					 * could change from one open/close
					 * to next */
};

extern struct vfs	*npc_searchforfs();
extern struct vnode	*npc_getvnode();
extern char		*npc_buildpath();
extern struct vnode	*npc_dirlookup();
extern struct vnode	*npc_findv();
extern struct vnode	*npc_findpccomp();

#define	    NMS_S2UNIX_SOCK    "/nbiow/tmp/nms_socket"
#define	    MAX_NBIOWLEN    128

#define	    AGE_TIME_PW	    2700
#define	    AGE_TIME_NPW    300

extern int  npc_have_zoneinfo;
extern int  npc_zoneinfo_failed;
#define	    HIDDEN_FAILURES 20

#ifdef DEBUG
#define	    CKHEALTH(mi) \
if((mi)->m_flags & NPCMNT_BADFS) { \
    printf("BADFS ***********************\n"); \
    return(EIO); \
}
#else
#define	    CKHEALTH(mi) \
if((mi)->m_flags & NPCMNT_BADFS) { \
    return(EIO); \
}
#endif
    
/* nmserv stuff */

struct sys2req {
    int		s2_req;
    int		s2_len;
    char	s2_data[1024 - 2 * sizeof(int)];
};

struct nament {
    char	    ne_name[NB_NAME_LEN+1];
    struct in_addr  ne_inaddr;
    short	    ne_flags;
};

#define	    S2REPORTNAMES	0xa1	/* report of valid names
					 * from refresh process */
#define	    S2REPORTSILENT	0xa2	/* report of old valid names
					 * nolonger responding */
#define	    S2REPORTVSIL	0xa3	/* report of old silent names
					 * nolonger responding */
/*
 *	requests only report registed non-silent names
 */
#define	    S2REQLOCNET		0xa4	/* request for all names
					 * on local nets */
#define	    S2REQFORNET		0xa5	/* request for all names on foreign
					 * nets */
#define	    S2REQLOCSRV		0xa6	/* request for all servers on local
					 * nets */
#define	    S2REQFORSRV		0xa7	/* request for all servers on foreign
					     * nets */
#define	    S2SETCONFLICT	0xa8	/* broadcast that the specified name is
					 * in conflict */
#define	    S2REQRELEASE	0xa9	/* broadcast a request for release */
#define	    S2NMQUERY		0xaa	/* given a name, return IP address */
#define	    S2GETTIME		0xab	/* pass gmt to local data to kernel */
